/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.analysis.core.util.ModelValidation;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.QualityGate;
import java.util.function.Function;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class WarningsQualityGate
extends QualityGate {
    private static final long serialVersionUID = -3560049414586166711L;
    private final QualityGateType type;

    @DataBoundConstructor
    public WarningsQualityGate(QualityGateType type) {
        this.type = type;
    }

    public WarningsQualityGate(int threshold, QualityGateType type, QualityGate.QualityGateCriticality criticality) {
        this(type);
        this.setIntegerThreshold(threshold);
        this.setCriticality(criticality);
    }

    public boolean isUnstable() {
        return this.getCriticality() == QualityGate.QualityGateCriticality.UNSTABLE || this.getCriticality() == QualityGate.QualityGateCriticality.NOTE;
    }

    @DataBoundSetter
    @Deprecated
    public void setUnstable(boolean unstable) {
        if (unstable) {
            this.setCriticality(QualityGate.QualityGateCriticality.UNSTABLE);
        } else {
            this.setCriticality(QualityGate.QualityGateCriticality.FAILURE);
        }
    }

    public Function<IssuesStatistics, Integer> getActualSizeMethodReference() {
        return this.type.getSizeGetter();
    }

    public String getName() {
        return this.type.getDisplayName();
    }

    public QualityGateType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WarningsQualityGate that = (WarningsQualityGate)((Object)o);
        return this.type == that.type;
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public static enum QualityGateType {
        TOTAL(IssuesStatistics.StatisticProperties.TOTAL),
        TOTAL_ERROR(IssuesStatistics.StatisticProperties.TOTAL_ERROR),
        TOTAL_HIGH(IssuesStatistics.StatisticProperties.TOTAL_HIGH),
        TOTAL_NORMAL(IssuesStatistics.StatisticProperties.TOTAL_NORMAL),
        TOTAL_LOW(IssuesStatistics.StatisticProperties.TOTAL_LOW),
        TOTAL_MODIFIED(IssuesStatistics.StatisticProperties.TOTAL_MODIFIED),
        NEW(IssuesStatistics.StatisticProperties.NEW),
        NEW_ERROR(IssuesStatistics.StatisticProperties.NEW_ERROR),
        NEW_HIGH(IssuesStatistics.StatisticProperties.NEW_HIGH),
        NEW_NORMAL(IssuesStatistics.StatisticProperties.NEW_NORMAL),
        NEW_LOW(IssuesStatistics.StatisticProperties.NEW_LOW),
        NEW_MODIFIED(IssuesStatistics.StatisticProperties.NEW_MODIFIED),
        DELTA(IssuesStatistics.StatisticProperties.DELTA),
        DELTA_ERROR(IssuesStatistics.StatisticProperties.DELTA_ERROR),
        DELTA_HIGH(IssuesStatistics.StatisticProperties.DELTA_HIGH),
        DELTA_NORMAL(IssuesStatistics.StatisticProperties.DELTA_NORMAL),
        DELTA_LOW(IssuesStatistics.StatisticProperties.DELTA_LOW);

        private final IssuesStatistics.StatisticProperties properties;

        private QualityGateType(IssuesStatistics.StatisticProperties statisticProperties) {
            this.properties = statisticProperties;
        }

        public String getDisplayName() {
            return this.properties.getDisplayName();
        }

        public Function<IssuesStatistics, Integer> getSizeGetter() {
            return this.properties.getSizeGetter();
        }
    }

    @Extension
    public static class WarningsQualityGateDescriptor
    extends QualityGate.QualityGateDescriptor {
        private final ModelValidation modelValidation = new ModelValidation();
        private final JenkinsFacade jenkins;

        @VisibleForTesting
        WarningsQualityGateDescriptor(JenkinsFacade jenkinsFacade) {
            this.jenkins = jenkinsFacade;
        }

        public WarningsQualityGateDescriptor() {
            this(new JenkinsFacade());
        }

        @POST
        public ListBoxModel doFillTypeItems() {
            ListBoxModel model = new ListBoxModel();
            if (this.jenkins.hasPermission(Jenkins.READ)) {
                for (QualityGateType qualityGateType : QualityGateType.values()) {
                    model.add(qualityGateType.getDisplayName(), qualityGateType.name());
                }
            }
            return model;
        }

        @POST
        public FormValidation doCheckThreshold(@AncestorInPath BuildableItem project, @QueryParameter int threshold) {
            if (!this.jenkins.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return this.modelValidation.validateThreshold(threshold);
        }
    }
}

