/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import edu.hm.hafner.analysis.Severity;
import io.jenkins.plugins.analysis.core.util.Messages;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jvnet.localizer.Localizable;

public class IssuesStatistics
implements Serializable {
    private static final long serialVersionUID = 2885481384170602793L;
    private final int totalErrorSize;
    private final int totalHighSize;
    private final int totalNormalSize;
    private final int totalLowSize;
    private final int totalModifiedSize;
    private final int newErrorSize;
    private final int newHighSize;
    private final int newNormalSize;
    private final int newLowSize;
    private final int newModifiedSize;
    private final int deltaErrorSize;
    private final int deltaHighSize;
    private final int deltaNormalSize;
    private final int deltaLowSize;
    private final int fixedSize;
    private final Map<Severity, Integer> totalSizeBySeverity = new HashMap<Severity, Integer>();
    private final Map<Severity, Integer> newSizeBySeverity = new HashMap<Severity, Integer>();

    IssuesStatistics(int totalErrorSize, int totalHighSize, int totalNormalSize, int totalLowSize, int totalModifiedSize, int newErrorSize, int newHighSize, int newNormalSize, int newLowSize, int newModifiedSize, int deltaErrorSize, int deltaHighSize, int deltaNormalSize, int deltaLowSize, int fixedSize) {
        this.totalErrorSize = totalErrorSize;
        this.totalHighSize = totalHighSize;
        this.totalNormalSize = totalNormalSize;
        this.totalLowSize = totalLowSize;
        this.totalModifiedSize = totalModifiedSize;
        this.totalSizeBySeverity.put(Severity.ERROR, totalErrorSize);
        this.totalSizeBySeverity.put(Severity.WARNING_HIGH, totalHighSize);
        this.totalSizeBySeverity.put(Severity.WARNING_NORMAL, totalNormalSize);
        this.totalSizeBySeverity.put(Severity.WARNING_LOW, totalLowSize);
        this.newErrorSize = newErrorSize;
        this.newHighSize = newHighSize;
        this.newNormalSize = newNormalSize;
        this.newLowSize = newLowSize;
        this.newModifiedSize = newModifiedSize;
        this.newSizeBySeverity.put(Severity.ERROR, newErrorSize);
        this.newSizeBySeverity.put(Severity.WARNING_HIGH, newHighSize);
        this.newSizeBySeverity.put(Severity.WARNING_NORMAL, newNormalSize);
        this.newSizeBySeverity.put(Severity.WARNING_LOW, newLowSize);
        this.deltaErrorSize = deltaErrorSize;
        this.deltaHighSize = deltaHighSize;
        this.deltaNormalSize = deltaNormalSize;
        this.deltaLowSize = deltaLowSize;
        this.fixedSize = fixedSize;
    }

    public IssuesStatistics aggregate(IssuesStatistics other) {
        return new IssuesStatistics(this.totalErrorSize + other.totalErrorSize, this.totalHighSize + other.totalHighSize, this.totalNormalSize + other.totalNormalSize, this.totalLowSize + other.totalLowSize, this.totalModifiedSize + other.totalModifiedSize, this.newErrorSize + other.newErrorSize, this.newHighSize + other.newHighSize, this.newNormalSize + other.newNormalSize, this.newLowSize + other.newLowSize, this.newModifiedSize + other.newModifiedSize, this.deltaErrorSize + other.deltaErrorSize, this.deltaHighSize + other.deltaHighSize, this.deltaNormalSize + other.deltaNormalSize, this.deltaLowSize + other.deltaLowSize, this.fixedSize + other.fixedSize);
    }

    @Whitelisted
    public int getTotalSize() {
        return this.totalErrorSize + this.totalHighSize + this.totalNormalSize + this.totalLowSize;
    }

    @Whitelisted
    public int getTotalModifiedSize() {
        return this.totalModifiedSize;
    }

    @Whitelisted
    public int getNewSize() {
        return this.newErrorSize + this.newHighSize + this.newNormalSize + this.newLowSize;
    }

    @Whitelisted
    public int getNewModifiedSize() {
        return this.newModifiedSize;
    }

    @Whitelisted
    public int getDeltaSize() {
        return this.deltaErrorSize + this.deltaHighSize + this.deltaNormalSize + this.deltaLowSize;
    }

    @Whitelisted
    public int getTotalErrorSize() {
        return this.totalErrorSize;
    }

    @Whitelisted
    public int getTotalHighSize() {
        return this.totalHighSize;
    }

    @Whitelisted
    public int getTotalNormalSize() {
        return this.totalNormalSize;
    }

    @Whitelisted
    public int getTotalLowSize() {
        return this.totalLowSize;
    }

    @Whitelisted
    public int getNewErrorSize() {
        return this.newErrorSize;
    }

    @Whitelisted
    public int getNewHighSize() {
        return this.newHighSize;
    }

    @Whitelisted
    public int getNewNormalSize() {
        return this.newNormalSize;
    }

    @Whitelisted
    public int getNewLowSize() {
        return this.newLowSize;
    }

    @Whitelisted
    public int getDeltaErrorSize() {
        return this.deltaErrorSize;
    }

    @Whitelisted
    public int getDeltaHighSize() {
        return this.deltaHighSize;
    }

    @Whitelisted
    public int getDeltaNormalSize() {
        return this.deltaNormalSize;
    }

    @Whitelisted
    public int getDeltaLowSize() {
        return this.deltaLowSize;
    }

    @Whitelisted
    public int getFixedSize() {
        return this.fixedSize;
    }

    public ImmutableMap<Severity, Integer> getTotalSizePerSeverity() {
        return Maps.immutable.ofMap(this.totalSizeBySeverity);
    }

    public int getTotalSizeOf(Severity severity) {
        this.validateSeverity(severity);
        return this.totalSizeBySeverity.get(severity);
    }

    public ImmutableMap<Severity, Integer> getNewSizePerSeverity() {
        return Maps.immutable.ofMap(this.newSizeBySeverity);
    }

    public int getNewSizeOf(Severity severity) {
        this.validateSeverity(severity);
        return this.newSizeBySeverity.get(severity);
    }

    private void validateSeverity(Severity severity) {
        if (!Severity.getPredefinedValues().contains(severity)) {
            throw new NoSuchElementException("There is no such severity: " + String.valueOf(severity));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssuesStatistics that = (IssuesStatistics)o;
        return this.totalErrorSize == that.totalErrorSize && this.totalHighSize == that.totalHighSize && this.totalNormalSize == that.totalNormalSize && this.totalLowSize == that.totalLowSize && this.totalModifiedSize == that.totalModifiedSize && this.newErrorSize == that.newErrorSize && this.newHighSize == that.newHighSize && this.newNormalSize == that.newNormalSize && this.newLowSize == that.newLowSize && this.newModifiedSize == that.newModifiedSize && this.deltaErrorSize == that.deltaErrorSize && this.deltaHighSize == that.deltaHighSize && this.deltaNormalSize == that.deltaNormalSize && this.deltaLowSize == that.deltaLowSize && this.fixedSize == that.fixedSize;
    }

    public int hashCode() {
        return Objects.hash(this.totalErrorSize, this.totalHighSize, this.totalNormalSize, this.totalLowSize, this.totalModifiedSize, this.newErrorSize, this.newHighSize, this.newNormalSize, this.newLowSize, this.totalModifiedSize, this.deltaErrorSize, this.deltaHighSize, this.deltaNormalSize, this.deltaLowSize, this.fixedSize);
    }

    public static enum StatisticProperties {
        TOTAL(Messages._Statistics_Total(), IssuesStatistics::getTotalSize, ""),
        TOTAL_ERROR(Messages._Statistics_Total_Error(), IssuesStatistics::getTotalErrorSize, "error"),
        TOTAL_HIGH(Messages._Statistics_Total_High(), IssuesStatistics::getTotalHighSize, "high"),
        TOTAL_NORMAL(Messages._Statistics_Total_Normal(), IssuesStatistics::getTotalNormalSize, "normal"),
        TOTAL_LOW(Messages._Statistics_Total_Low(), IssuesStatistics::getTotalLowSize, "low"),
        TOTAL_MODIFIED(Messages._Statistics_Total_Modified(), IssuesStatistics::getTotalModifiedSize, "modified"),
        NEW(Messages._Statistics_New(), IssuesStatistics::getNewSize, "new"),
        NEW_ERROR(Messages._Statistics_New_Error(), IssuesStatistics::getNewErrorSize, "new/error"),
        NEW_HIGH(Messages._Statistics_New_High(), IssuesStatistics::getNewHighSize, "new/high"),
        NEW_NORMAL(Messages._Statistics_New_Normal(), IssuesStatistics::getNewNormalSize, "new/normal"),
        NEW_LOW(Messages._Statistics_New_Low(), IssuesStatistics::getNewLowSize, "new/low"),
        NEW_MODIFIED(Messages._Statistics_New_Modified(), IssuesStatistics::getNewModifiedSize, "new/modified"),
        DELTA(Messages._Statistics_Delta(), IssuesStatistics::getDeltaSize, ""),
        DELTA_ERROR(Messages._Statistics_Delta_Error(), IssuesStatistics::getDeltaErrorSize, ""),
        DELTA_HIGH(Messages._Statistics_Delta_High(), IssuesStatistics::getDeltaHighSize, ""),
        DELTA_NORMAL(Messages._Statistics_Delta_Normal(), IssuesStatistics::getDeltaNormalSize, ""),
        DELTA_LOW(Messages._Statistics_Delta_Low(), IssuesStatistics::getDeltaLowSize, ""),
        FIXED(Messages._Statistics_Fixed(), IssuesStatistics::getFixedSize, "fixed");

        private final Localizable displayName;
        private final SerializableGetter sizeGetter;
        private final String url;

        private StatisticProperties(Localizable displayName, SerializableGetter sizeGetter, String url) {
            this.displayName = displayName;
            this.sizeGetter = sizeGetter;
            this.url = url;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }

        public Function<IssuesStatistics, Integer> getSizeGetter() {
            return this.sizeGetter;
        }

        public String getUrl(String prefix) {
            if (StringUtils.isEmpty((CharSequence)this.url)) {
                return prefix;
            }
            return prefix + "/" + this.url;
        }

        public int get(IssuesStatistics statistics) {
            return (Integer)this.sizeGetter.apply(statistics);
        }

        @FunctionalInterface
        private static interface SerializableGetter
        extends Function<IssuesStatistics, Integer>,
        Serializable {
        }
    }
}

