/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import edu.hm.hafner.analysis.Severity;
import java.io.Serializable;

public class HealthDescriptor
implements Serializable {
    private static final long serialVersionUID = -2509226746813680432L;
    private final int healthy;
    private final int unhealthy;
    private final Severity minimumSeverity;

    public HealthDescriptor(int healthy, int unhealthy, Severity minimumSeverity) {
        this.healthy = healthy;
        this.unhealthy = unhealthy;
        this.minimumSeverity = minimumSeverity;
    }

    public int getHealthy() {
        return this.healthy;
    }

    public int getUnhealthy() {
        return this.unhealthy;
    }

    public Severity getMinimumSeverity() {
        return this.minimumSeverity;
    }

    public boolean isEnabled() {
        return this.healthy > 0 || this.unhealthy > 0;
    }

    public boolean isValid() {
        return this.healthy > 0 && this.unhealthy > this.healthy;
    }

    public String toString() {
        return "Healthy=%d, Unhealthy=%d, Minimum Severity=%s".formatted(this.healthy, this.unhealthy, this.minimumSeverity);
    }
}

