/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import hudson.console.ConsoleNote;
import hudson.model.Run;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import java.util.regex.Pattern;

public class ConsoleLogReaderFactory
extends ReaderFactory {
    private final Run<?, ?> run;
    private static final Pattern TIME_STAMPER_PREFIX = Pattern.compile("\\[\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}Z] ");
    private static final Function<String, String> REMOVE_TIME_STAMPER_PREFIX = string -> TIME_STAMPER_PREFIX.matcher((CharSequence)string).replaceFirst("");

    public ConsoleLogReaderFactory(Run<?, ?> run) {
        super(run.getCharset(), REMOVE_TIME_STAMPER_PREFIX.compose(ConsoleNote::removeNotes));
        this.run = run;
    }

    public String getFileName() {
        return "jenkins-console.log";
    }

    @MustBeClosed
    public Reader create() {
        try {
            return this.run.getLogReader();
        }
        catch (IOException e) {
            throw new ParsingException((Throwable)e);
        }
    }
}

