/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import hudson.model.Run;
import java.util.Optional;

public class BuildResultNavigator {
    private static final String SLASH = "/";

    public Optional<String> getSameUrlForOtherBuild(Run<?, ?> currentBuild, String viewUrl, String resultId, String selectedBuildNumber) {
        try {
            return this.getSameUrlForOtherBuild(currentBuild, viewUrl, resultId, Integer.parseInt(selectedBuildNumber));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public Optional<String> getSameUrlForOtherBuild(Run<?, ?> currentBuild, String viewUrl, String resultId, int selectedBuildNumber) {
        String match;
        Run selectedBuild = currentBuild.getParent().getBuildByNumber(selectedBuildNumber);
        if (selectedBuild != null && viewUrl.contains(match = SLASH + currentBuild.getNumber() + SLASH + resultId)) {
            return Optional.of(viewUrl.replaceFirst(match + ".*", SLASH + selectedBuildNumber + SLASH + resultId));
        }
        return Optional.empty();
    }
}

