/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.tokens;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;

@Extension(optional=true)
public class IssuesSizeTokenMacro
extends DataBoundTokenMacro {
    private String tool;
    private IssuesStatistics.StatisticProperties type = IssuesStatistics.StatisticProperties.TOTAL;

    @DataBoundTokenMacro.Parameter
    public void setTool(String tool) {
        this.tool = tool;
    }

    @DataBoundTokenMacro.Parameter
    public void setType(String type) {
        this.type = IssuesStatistics.StatisticProperties.valueOf(type);
    }

    public boolean acceptsMacroName(String macroName) {
        return "ANALYSIS_ISSUES_COUNT".equals(macroName);
    }

    public String evaluate(AbstractBuild<?, ?> abstractBuild, TaskListener taskListener, String macroName) {
        return this.extractSelectedTotals((Run<?, ?>)abstractBuild);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) {
        return this.extractSelectedTotals(run);
    }

    private String extractSelectedTotals(Run<?, ?> run) {
        return String.valueOf(run.getActions(ResultAction.class).stream().filter(this.createToolFilter()).map(ResultAction::getResult).map(AnalysisResult::getTotals).mapToInt(totals -> this.type.getSizeGetter().apply((IssuesStatistics)totals)).reduce(Integer::sum).orElse(0));
    }

    private Predicate<ResultAction> createToolFilter() {
        if (StringUtils.isBlank((CharSequence)this.tool)) {
            return jobAction -> true;
        }
        return jobAction -> jobAction.getId().equals(this.tool);
    }
}

