/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import io.jenkins.plugins.analysis.core.model.JobAction;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ToolSelection
extends AbstractDescribableImpl<ToolSelection> {
    private String id = "";

    @DataBoundConstructor
    public ToolSelection() {
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ToolSelectionDescriptor getDescriptor() {
        return (ToolSelectionDescriptor)super.getDescriptor();
    }

    public static Predicate<ResultAction> createToolFilter(boolean canSelectTools, List<ToolSelection> selectedTools) {
        if (canSelectTools) {
            return action -> StringUtils.containsAnyIgnoreCase((CharSequence)action.getId(), (CharSequence[])ToolSelection.getIds(selectedTools));
        }
        return jobAction -> true;
    }

    public static String[] getIds(List<ToolSelection> tools) {
        return (String[])tools.stream().map(ToolSelection::getId).toArray(String[]::new);
    }

    @Extension
    public static class ToolSelectionDescriptor
    extends Descriptor<ToolSelection> {
        private static JenkinsFacade jenkinsFacade = new JenkinsFacade();

        @VisibleForTesting
        static void setJenkinsFacade(JenkinsFacade facade) {
            jenkinsFacade = facade;
        }

        @POST
        public ComboBoxModel doFillIdItems(@AncestorInPath BuildableItem project) {
            ComboBoxModel model = new ComboBoxModel();
            if (jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                model.addAll(this.collectAvailableIds());
            }
            return model;
        }

        private Set<String> collectAvailableIds() {
            return jenkinsFacade.getAllJobs().stream().flatMap(job -> job.getActions(JobAction.class).stream()).map(JobAction::getId).collect(Collectors.toSet());
        }

        @POST
        public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter String id) {
            if (!new JenkinsFacade().hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            if (this.collectAvailableIds().contains(id)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("None of the selected jobs contains the tool " + id));
        }
    }
}

