/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import io.jenkins.plugins.analysis.core.model.IssueReportScanner;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.core.util.ConsoleLogReaderFactory;
import io.jenkins.plugins.util.AgentFileVisitor;
import io.jenkins.plugins.util.EnvironmentResolver;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class ReportScanningTool
extends Tool {
    private static final long serialVersionUID = 2250515287336975478L;
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private String pattern = "";
    private String reportEncoding = "";
    private boolean skipSymbolicLinks;
    private int linesLookAhead = 3;

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @CheckForNull
    public String getPattern() {
        return this.pattern;
    }

    public String getActualPattern() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.pattern, (CharSequence)this.getDescriptor().getPattern());
    }

    @Override
    public ReportScanningToolDescriptor getDescriptor() {
        return (ReportScanningToolDescriptor)super.getDescriptor();
    }

    public abstract IssueParser createParser();

    @DataBoundSetter
    public void setSkipSymbolicLinks(boolean skipSymbolicLinks) {
        this.skipSymbolicLinks = skipSymbolicLinks;
    }

    public boolean getSkipSymbolicLinks() {
        return this.skipSymbolicLinks;
    }

    private boolean followSymlinks() {
        return !this.getSkipSymbolicLinks();
    }

    private boolean isEmptyFileValid() {
        return this.getDescriptor().canScanConsoleLog();
    }

    @DataBoundSetter
    public void setReportEncoding(String reportEncoding) {
        this.reportEncoding = reportEncoding;
    }

    @CheckForNull
    public String getReportEncoding() {
        return this.reportEncoding;
    }

    @DataBoundSetter
    public void setLinesLookAhead(int linesLookAhead) {
        this.linesLookAhead = linesLookAhead;
    }

    public int getLinesLookAhead() {
        return this.linesLookAhead;
    }

    @Override
    public Report scan(Run<?, ?> run, FilePath workspace, Charset sourceCodeEncoding, LogHandler logger) {
        Report report = this.scan(run, workspace, logger);
        report.setOrigin(this.getActualId(), this.getActualName());
        return report;
    }

    private Report scan(Run<?, ?> run, FilePath workspace, LogHandler logger) {
        String actualPattern = this.getActualPattern();
        if (StringUtils.isBlank((CharSequence)actualPattern)) {
            return this.scanInConsoleLog(workspace, run, logger);
        }
        if (StringUtils.isBlank((CharSequence)this.getPattern())) {
            logger.log("Using default pattern '%s' since user defined pattern is not set", new Object[]{this.getDescriptor().getPattern()});
        }
        return this.scanInWorkspace(workspace, this.expandPattern(run, actualPattern), logger);
    }

    private String expandPattern(Run<?, ?> run, String actualPattern) {
        try {
            EnvironmentResolver environmentResolver = new EnvironmentResolver();
            return environmentResolver.expandEnvironmentVariables(run.getEnvironment(TaskListener.NULL), actualPattern);
        }
        catch (IOException | InterruptedException ignore) {
            return actualPattern;
        }
    }

    private Report scanInWorkspace(FilePath workspace, String expandedPattern, LogHandler logger) {
        try {
            AgentFileVisitor.FileVisitorResult report = (AgentFileVisitor.FileVisitorResult)workspace.act((FilePath.FileCallable)new IssueReportScanner(expandedPattern, this.reportEncoding, this.followSymlinks(), this.createParser(), !this.isEmptyFileValid()));
            FilteredLog log = report.getLog();
            logger.log(log);
            List results = report.getResults();
            Report aggregation = results.isEmpty() ? new Report() : (results.size() == 1 ? (Report)results.get(0) : new Report((Collection)results));
            aggregation.mergeLogMessages(log);
            return aggregation;
        }
        catch (IOException e) {
            throw new ParsingException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ParsingCanceledException((Throwable)e);
        }
    }

    private Report scanInConsoleLog(FilePath workspace, Run<?, ?> run, LogHandler logger) {
        Ensure.that((boolean)this.getDescriptor().canScanConsoleLog()).isTrue("Static analysis tool %s cannot scan console log output, please define a file pattern", new Object[]{this.getActualName()});
        Report consoleReport = new Report();
        consoleReport.logInfo("Parsing console log (workspace: '%s')", new Object[]{workspace});
        logger.logInfoMessages(consoleReport.getInfoMessages());
        logger.logErrorMessages(consoleReport.getErrorMessages());
        Report report = this.createParser().parse((ReaderFactory)new ConsoleLogReaderFactory(run));
        report.logInfo("Successfully parsed console log", new Object[0]);
        report.logInfo("-> found %s (skipped %s)", new Object[]{this.plural(report.getSize(), "issue"), this.plural(report.getDuplicatesSize(), "duplicate")});
        report.setOriginReportFile("jenkins-console.log");
        consoleReport.addAll(new Report[]{report});
        logger.logInfoMessages(consoleReport.getInfoMessages());
        logger.logErrorMessages(consoleReport.getErrorMessages());
        return consoleReport;
    }

    private String plural(int count, String itemName) {
        StringBuilder builder = new StringBuilder(itemName);
        if (count != 1) {
            builder.append('s');
        }
        builder.insert(0, ' ');
        builder.insert(0, count);
        return builder.toString();
    }

    public static class ReportScanningToolDescriptor
    extends Tool.ToolDescriptor {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();

        protected ReportScanningToolDescriptor(String id) {
            super(id);
        }

        @POST
        public ComboBoxModel doFillReportEncodingItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return VALIDATION_UTILITIES.getAllCharsets();
            }
            return new ComboBoxModel();
        }

        @POST
        public FormValidation doCheckReportEncoding(@AncestorInPath BuildableItem project, @QueryParameter String reportEncoding) {
            if (!JENKINS.hasPermission(Jenkins.READ)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateCharset(reportEncoding);
        }

        @POST
        public FormValidation doCheckPattern(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String pattern) {
            boolean thereIsNoPatternConfigured;
            if (!JENKINS.hasPermission(Item.CONFIGURE, project)) {
                return FormValidation.ok();
            }
            if (!this.hasDefaultPattern() && !this.canScanConsoleLog() && (thereIsNoPatternConfigured = StringUtils.isBlank((CharSequence)pattern))) {
                return FormValidation.error((String)Messages.ReportScanningTool_PatternIsEmptyAndConsoleParsingDisabled());
            }
            return VALIDATION_UTILITIES.doCheckPattern(project, pattern);
        }

        public boolean hasDefaultPattern() {
            return StringUtils.isNotBlank((CharSequence)this.getPattern());
        }

        public boolean canScanConsoleLog() {
            return true;
        }

        public String getPattern() {
            return "";
        }
    }
}

