/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.DetailsTableModel;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.ArrayList;
import java.util.List;

public class IssuesModel
extends DetailsTableModel {
    IssuesModel(Report report, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider descriptionProvider) {
        this(report, fileNameRenderer, ageBuilder, descriptionProvider, new JenkinsFacade());
    }

    @VisibleForTesting
    IssuesModel(Report report, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider descriptionProvider, JenkinsFacade jenkinsFacade) {
        super(report, fileNameRenderer, ageBuilder, descriptionProvider, jenkinsFacade);
    }

    public String getId() {
        return "issues";
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(this.createDetailsColumn());
        columns.add(this.createFileColumn());
        if (this.getReport().hasPackages()) {
            columns.add(this.createPackageColumn());
        }
        if (this.getReport().hasCategories()) {
            TableColumn category = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Category()).withDataPropertyKey("category").withResponsivePriority(100).build();
            columns.add(category);
        }
        if (this.getReport().hasTypes()) {
            TableColumn type = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Type()).withDataPropertyKey("type").withResponsivePriority(1000).build();
            columns.add(type);
        }
        columns.add(this.createSeverityColumn());
        columns.add(this.createAgeColumn());
        columns.add(this.createHiddenDetailsColumn());
        return columns;
    }

    @Override
    public IssuesRow getRow(Issue issue) {
        IssuesRow row = new IssuesRow(this.getAgeBuilder(), this.getFileNameRenderer(), this.getDescriptionProvider(), issue, this.getJenkinsFacade());
        row.setPackageName(issue);
        row.setCategory(issue);
        row.setType(issue);
        row.setSeverity(issue);
        return row;
    }

    public static class IssuesRow
    extends DetailsTableModel.TableRow {
        private String packageName;
        private String category;
        private String type;
        private String severity;

        IssuesRow(StaticAnalysisLabelProvider.AgeBuilder ageBuilder, FileNameRenderer fileNameRenderer, DescriptionProvider descriptionProvider, Issue issue, JenkinsFacade jenkinsFacade) {
            super(ageBuilder, fileNameRenderer, descriptionProvider, issue, jenkinsFacade);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getCategory() {
            return this.category;
        }

        public String getType() {
            return this.type;
        }

        public String getSeverity() {
            return this.severity;
        }

        void setPackageName(Issue issue) {
            this.packageName = this.formatProperty("packageName", issue.getPackageName());
        }

        void setCategory(Issue issue) {
            this.category = this.formatProperty("category", issue.getCategory());
        }

        void setType(Issue issue) {
            this.type = this.formatProperty("type", issue.getType());
        }

        void setSeverity(Issue issue) {
            this.severity = this.formatSeverity(issue.getSeverity());
        }
    }
}

