/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ConsoleDetail;
import io.jenkins.plugins.analysis.core.model.FixedWarningsDetail;
import io.jenkins.plugins.analysis.core.model.IssuesDetail;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.TabLabelProvider;
import io.jenkins.plugins.analysis.core.util.BuildFolderFacade;
import io.jenkins.plugins.analysis.core.util.ConsoleLogHandler;
import io.jenkins.plugins.analysis.core.util.LocalizedSeverity;
import io.jenkins.plugins.bootstrap5.MessagesViewModel;
import io.jenkins.plugins.prism.Marker;
import io.jenkins.plugins.prism.SourceCodeViewModel;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DetailFactory {
    private static final Report EMPTY = new Report();
    private static final String LINK_SEPARATOR = ".";
    private static final String ORIGIN_PROPERTY = "origin";
    private static final String FILE_NAME_PROPERTY = "fileName";
    private final JenkinsFacade jenkins;
    private final BuildFolderFacade buildFolder;

    public DetailFactory() {
        this(new JenkinsFacade(), new BuildFolderFacade());
    }

    @VisibleForTesting
    DetailFactory(JenkinsFacade jenkinsFacade, BuildFolderFacade buildFolder) {
        this.jenkins = jenkinsFacade;
        this.buildFolder = buildFolder;
    }

    Object createTrendDetails(String link, Run<?, ?> owner, AnalysisResult result, Report allIssues, Report newIssues, Report outstandingIssues, Report fixedIssues, Charset sourceEncoding, IssuesDetail parent) {
        StaticAnalysisLabelProvider labelProvider = parent.getLabelProvider();
        if (link.contains(LINK_SEPARATOR)) {
            return this.createFilteredView(link, owner, result, allIssues, newIssues, outstandingIssues, fixedIssues, sourceEncoding, parent, labelProvider);
        }
        return this.createNewDetailView(link, owner, result, allIssues, newIssues, outstandingIssues, fixedIssues, sourceEncoding, parent, labelProvider);
    }

    private Object createFilteredView(String link, Run<?, ?> owner, AnalysisResult result, Report allIssues, Report newIssues, Report outstandingIssues, Report fixedIssues, Charset sourceEncoding, IssuesDetail parent, StaticAnalysisLabelProvider labelProvider) {
        String plainLink = this.removePropertyPrefix(link);
        if (link.startsWith("source.")) {
            SourceCodeViewModel sourceCodeViewModel;
            block21: {
                Issue issue = allIssues.findById(UUID.fromString(plainLink));
                if (ConsoleLogHandler.isInConsoleLog(issue.getFileName())) {
                    try (Stream<String> consoleLog = this.buildFolder.readConsoleLog(owner);){
                        ConsoleDetail consoleDetail = new ConsoleDetail(owner, consoleLog, issue.getLineStart(), issue.getLineEnd());
                        return consoleDetail;
                    }
                }
                Marker marker = this.asMarker(issue, labelProvider.getSourceCodeDescription(owner, issue), labelProvider.getSmallIconUrl());
                Reader affectedFile = this.buildFolder.readFile(owner, issue.getFileName(), sourceEncoding);
                try {
                    sourceCodeViewModel = new SourceCodeViewModel(owner, issue.getBaseName(), affectedFile, marker);
                    if (affectedFile == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (affectedFile != null) {
                            try {
                                affectedFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        try (StringReader fallback = new StringReader("%s%n%s".formatted(ExceptionUtils.getMessage((Throwable)e), ExceptionUtils.getStackTrace((Throwable)e)));){
                            SourceCodeViewModel sourceCodeViewModel2 = new SourceCodeViewModel(owner, issue.getBaseName(), (Reader)fallback, marker);
                            return sourceCodeViewModel2;
                        }
                    }
                }
                affectedFile.close();
            }
            return sourceCodeViewModel;
        }
        String url = parent.getUrl() + "/" + plainLink;
        String property = StringUtils.substringBefore((String)link, (String)LINK_SEPARATOR);
        Predicate<Issue> filter = this.createPropertyFilter(plainLink, property);
        Report selectedIssues = allIssues.filter(filter);
        String displayName = this.getDisplayNameOfDetails(property, selectedIssues, plainLink, result.getSizePerOrigin().keySet());
        return new IssuesDetail(owner, result, selectedIssues, newIssues.filter(filter), outstandingIssues.filter(filter), fixedIssues.filter(filter), displayName, url, labelProvider, sourceEncoding);
    }

    private Marker asMarker(Issue issue, String description, String icon) {
        return new Marker.MarkerBuilder().withTitle(issue.getMessage()).withDescription(description).withIcon(icon).withLineStart(issue.getLineStart()).withLineEnd(issue.getLineEnd()).withColumnStart(issue.getColumnStart()).withColumnEnd(issue.getColumnEnd()).build();
    }

    @SuppressFBWarnings(value={"IMPROPER_UNICODE"})
    private Object createNewDetailView(String link, Run<?, ?> owner, AnalysisResult result, Report allIssues, Report newIssues, Report outstandingIssues, Report fixedIssues, Charset sourceEncoding, IssuesDetail parent, StaticAnalysisLabelProvider labelProvider) {
        String url = parent.getUrl() + "/" + link;
        if ("all".equalsIgnoreCase(link)) {
            return new IssuesDetail(owner, result, allIssues, newIssues, outstandingIssues, fixedIssues, labelProvider.getLinkName(), url, labelProvider, sourceEncoding);
        }
        if ("modified".equalsIgnoreCase(link)) {
            return new IssuesDetail(owner, result, this.filterModified(allIssues), this.filterModified(newIssues), this.filterModified(outstandingIssues), EMPTY, Messages.Modified_Warnings_Header(), url, labelProvider, sourceEncoding);
        }
        if ("unchanged".equalsIgnoreCase(link)) {
            return new IssuesDetail(owner, result, this.filterUnchanged(allIssues), this.filterUnchanged(newIssues), this.filterUnchanged(outstandingIssues), EMPTY, Messages.Modified_Warnings_Header(), url, labelProvider, sourceEncoding);
        }
        if ("fixed".equalsIgnoreCase(link)) {
            return new FixedWarningsDetail(owner, result, fixedIssues, url, labelProvider, sourceEncoding);
        }
        if ("new".equalsIgnoreCase(link)) {
            return new IssuesDetail(owner, result, newIssues, newIssues, EMPTY, EMPTY, Messages.New_Warnings_Header(), url, labelProvider, sourceEncoding);
        }
        if ("outstanding".equalsIgnoreCase(link)) {
            return new IssuesDetail(owner, result, outstandingIssues, EMPTY, outstandingIssues, EMPTY, Messages.Outstanding_Warnings_Header(), url, labelProvider, sourceEncoding);
        }
        if ("info".equalsIgnoreCase(link)) {
            return new MessagesViewModel(owner, labelProvider.getName(), result.getInfoMessages().castToList(), result.getErrorMessages().castToList());
        }
        for (Severity severity : Severity.getPredefinedValues()) {
            if (!severity.getName().equalsIgnoreCase(link)) continue;
            Predicate severityFilter = Issue.bySeverity((Severity)severity);
            return new IssuesDetail(owner, result, allIssues.filter(severityFilter), newIssues.filter(severityFilter), outstandingIssues.filter(severityFilter), fixedIssues.filter(severityFilter), LocalizedSeverity.getLongLocalizedString(severity), url, labelProvider, sourceEncoding);
        }
        throw new NoSuchElementException("There is no URL mapping for %s and %s".formatted(parent.getUrl(), link));
    }

    private Report filterModified(Report report) {
        return report.filter(Issue::isPartOfModifiedCode);
    }

    private Report filterUnchanged(Report report) {
        return report.filter(Predicate.not(Issue::isPartOfModifiedCode));
    }

    private Predicate<Issue> createPropertyFilter(String plainLink, String property) {
        return issue -> plainLink.equals(String.valueOf(Issue.getPropertyValueAsString((Issue)issue, (String)property).hashCode()));
    }

    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="Hashcode is used as URL")
    private String getDisplayNameOfDetails(String property, Report selectedIssues, String originHash, Set<String> origins) {
        if (ORIGIN_PROPERTY.equals(property)) {
            LabelProviderFactory factory = this.createFactory();
            for (String origin : origins) {
                if (!String.valueOf(origin.hashCode()).equals(originHash)) continue;
                return factory.create(origin).getName();
            }
            return factory.create("").getName();
        }
        return this.getColumnHeaderFor(selectedIssues, property) + " " + this.getPropertyValueAsString(property, selectedIssues);
    }

    @VisibleForTesting
    private LabelProviderFactory createFactory() {
        return new LabelProviderFactory(this.jenkins);
    }

    private String getPropertyValueAsString(String property, Report selectedIssues) {
        if (selectedIssues.isEmpty()) {
            return "n/a";
        }
        if (FILE_NAME_PROPERTY.equals(property)) {
            return selectedIssues.get(0).getBaseName();
        }
        return Issue.getPropertyValueAsString((Issue)selectedIssues.get(0), (String)property);
    }

    private String removePropertyPrefix(String link) {
        return StringUtils.substringAfter((String)link, (String)LINK_SEPARATOR);
    }

    private String getColumnHeaderFor(Report report, String propertyName) {
        try {
            return PropertyUtils.getProperty((Object)new TabLabelProvider(report), (String)propertyName).toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return "Element";
        }
    }
}

