/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.DetailsTableModel;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.util.Blame;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.forensics.blame.Blames;
import io.jenkins.plugins.forensics.util.CommitDecorator;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.ArrayList;
import java.util.List;

public class BlamesModel
extends DetailsTableModel {
    static final String UNDEFINED = "-";
    private final Blames blames;
    private final CommitDecorator commitDecorator;

    BlamesModel(Report report, Blames blames, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider labelProvider, CommitDecorator commitDecorator) {
        this(report, blames, fileNameRenderer, ageBuilder, labelProvider, commitDecorator, new JenkinsFacade());
    }

    @VisibleForTesting
    BlamesModel(Report report, Blames blames, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider labelProvider, CommitDecorator commitDecorator, JenkinsFacade jenkinsFacade) {
        super(report, fileNameRenderer, ageBuilder, labelProvider, jenkinsFacade);
        this.blames = blames;
        this.commitDecorator = commitDecorator;
    }

    public String getId() {
        return "blames";
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(this.createDetailsColumn());
        columns.add(this.createFileColumn());
        columns.add(this.createAgeColumn());
        TableColumn author = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Author()).withDataPropertyKey("author").withResponsivePriority(1).build();
        columns.add(author);
        TableColumn email = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Email()).withDataPropertyKey("email").withResponsivePriority(50).build();
        columns.add(email);
        TableColumn commit = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Commit()).withDataPropertyKey("commit").withResponsivePriority(10).build();
        columns.add(commit);
        TableColumn addedAt = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_AddedAt()).withDataPropertyKey("addedAt").withResponsivePriority(25).withHeaderClass(TableColumn.ColumnCss.DATE).build();
        columns.add(addedAt);
        columns.add(this.createHiddenDetailsColumn());
        return columns;
    }

    @Override
    protected BlamesRow getRow(Issue issue) {
        Blame blame = new Blame(issue, this.blames);
        return new BlamesRow(this.getAgeBuilder(), this.getFileNameRenderer(), this.getDescriptionProvider(), issue, this.getJenkinsFacade(), blame, this.commitDecorator.asLink(blame.getCommit()));
    }

    public static class BlamesRow
    extends DetailsTableModel.TableRow {
        private final Blame blame;
        private final String commit;

        BlamesRow(StaticAnalysisLabelProvider.AgeBuilder ageBuilder, FileNameRenderer fileNameRenderer, DescriptionProvider descriptionProvider, Issue issue, JenkinsFacade jenkinsFacade, Blame blame, String commit) {
            super(ageBuilder, fileNameRenderer, descriptionProvider, issue, jenkinsFacade);
            this.blame = blame;
            this.commit = commit;
        }

        public String getAuthor() {
            return this.blame.getAuthorName();
        }

        public String getEmail() {
            return this.blame.getAuthorEmail();
        }

        public String getCommit() {
            return this.commit;
        }

        public int getAddedAt() {
            return this.blame.getAddedAt();
        }
    }
}

