/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.columns;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.columns.Messages;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.util.GlobalConfigurationFacade;
import io.jenkins.plugins.util.GlobalConfigurationItem;
import io.jenkins.plugins.util.JenkinsFacade;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"warnings"})
public class WarningsAppearanceConfiguration
extends GlobalConfigurationItem {
    private boolean enableColumnByDefault = true;
    private IssuesStatistics.StatisticProperties defaultType = IssuesStatistics.StatisticProperties.TOTAL;
    private String defaultName = Messages.IssuesTotalColumn_Label();
    private final JenkinsFacade jenkins;

    public static WarningsAppearanceConfiguration getInstance() {
        return (WarningsAppearanceConfiguration)((Object)WarningsAppearanceConfiguration.all().get(WarningsAppearanceConfiguration.class));
    }

    @DataBoundConstructor
    public WarningsAppearanceConfiguration() {
        this.jenkins = new JenkinsFacade();
        this.load();
    }

    @VisibleForTesting
    WarningsAppearanceConfiguration(GlobalConfigurationFacade facade, JenkinsFacade jenkins) {
        super(facade);
        this.jenkins = jenkins;
        this.load();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    public boolean isEnableColumnByDefault() {
        return this.enableColumnByDefault;
    }

    @DataBoundSetter
    public void setEnableColumnByDefault(boolean enableColumnByDefault) {
        this.enableColumnByDefault = enableColumnByDefault;
        this.save();
    }

    public IssuesStatistics.StatisticProperties getDefaultType() {
        return this.defaultType;
    }

    @DataBoundSetter
    public void setDefaultType(IssuesStatistics.StatisticProperties defaultType) {
        this.defaultType = defaultType;
        this.save();
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    @DataBoundSetter
    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
        this.save();
    }

    @POST
    public ListBoxModel doFillDefaultTypeItems() {
        ListBoxModel model = new ListBoxModel();
        if (this.jenkins.hasPermission(Jenkins.READ)) {
            for (IssuesStatistics.StatisticProperties types : IssuesStatistics.StatisticProperties.values()) {
                model.add(types.getDisplayName(), types.name());
            }
        }
        return model;
    }
}

