/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.columns;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import io.jenkins.plugins.analysis.core.columns.Messages;
import io.jenkins.plugins.analysis.core.columns.WarningsAppearanceConfiguration;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.ToolSelection;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.ObjectUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public class IssuesTotalColumn
extends ListViewColumn {
    private boolean selectTools;
    private List<ToolSelection> tools = new ArrayList<ToolSelection>();
    private String name = "# Issues";
    private LabelProviderFactory labelProviderFactory = new LabelProviderFactory();
    private IssuesStatistics.StatisticProperties type;

    @DataBoundConstructor
    public IssuesTotalColumn() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    IssuesTotalColumn(JenkinsFacade facade) {
        this.name = IssuesTotalColumn.getConfiguration(facade).getDefaultName();
        this.type = IssuesTotalColumn.getConfiguration(facade).getDefaultType();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Deserialization of instances that do not have all fields yet")
    protected Object readResolve() {
        if (this.type == null) {
            this.type = IssuesStatistics.StatisticProperties.TOTAL;
        }
        return this;
    }

    public boolean getSelectTools() {
        return this.selectTools;
    }

    @DataBoundSetter
    public void setSelectTools(boolean selectTools) {
        this.selectTools = selectTools;
    }

    public List<ToolSelection> getTools() {
        return this.tools;
    }

    @DataBoundSetter
    public void setTools(List<ToolSelection> tools) {
        this.tools = tools;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public IssuesStatistics.StatisticProperties getType() {
        return this.type;
    }

    @DataBoundSetter
    public void setType(IssuesStatistics.StatisticProperties type) {
        this.type = type;
    }

    @VisibleForTesting
    void setLabelProviderFactory(LabelProviderFactory labelProviderFactory) {
        this.labelProviderFactory = labelProviderFactory;
    }

    private LabelProviderFactory getLabelProviderFactory() {
        return (LabelProviderFactory)ObjectUtils.defaultIfNull((Object)this.labelProviderFactory, (Object)new LabelProviderFactory());
    }

    public OptionalInt getTotal(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return OptionalInt.empty();
        }
        return lastCompletedBuild.getActions(ResultAction.class).stream().filter(ToolSelection.createToolFilter(this.selectTools, this.tools)).map(ResultAction::getResult).map(AnalysisResult::getTotals).mapToInt(totals -> this.type.getSizeGetter().apply((IssuesStatistics)totals)).reduce(Integer::sum);
    }

    public List<AnalysisResultDescription> getDetails(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return Collections.emptyList();
        }
        return lastCompletedBuild.getActions(ResultAction.class).stream().filter(ToolSelection.createToolFilter(this.selectTools, this.tools)).map(result -> new AnalysisResultDescription((ResultAction)result, this.getLabelProviderFactory(), this.type)).collect(Collectors.toList());
    }

    public String getUrl(Job<?, ?> job) {
        String selectedId;
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return "";
        }
        List actions = lastCompletedBuild.getActions(ResultAction.class);
        Set actualIds = actions.stream().map(ResultAction::getId).collect(Collectors.toSet());
        String[] selectedIds = ToolSelection.getIds(this.tools);
        if (selectedIds.length == 1 && this.selectTools && actualIds.contains(selectedId = selectedIds[0])) {
            ResultAction result = actions.stream().filter(action -> action.getId().equals(selectedId)).findFirst().get();
            return this.type.getUrl(result.getOwner().getNumber() + "/" + result.getUrlName());
        }
        if (actualIds.size() == 1) {
            ResultAction result = (ResultAction)actions.iterator().next();
            return this.type.getUrl(result.getOwner().getNumber() + "/" + result.getUrlName());
        }
        return "";
    }

    private static WarningsAppearanceConfiguration getConfiguration(JenkinsFacade jenkins) {
        DescriptorExtensionList configurations = jenkins.getDescriptorsFor(GlobalConfiguration.class);
        return Objects.requireNonNull((WarningsAppearanceConfiguration)((Object)configurations.get(WarningsAppearanceConfiguration.class)));
    }

    public static class AnalysisResultDescription {
        private final String icon;
        private final String name;
        private final int total;
        private final String url;

        @VisibleForTesting
        AnalysisResultDescription(String icon, String name, int total, String url) {
            this.icon = icon;
            this.name = name;
            this.total = total;
            this.url = url;
        }

        AnalysisResultDescription(ResultAction result, LabelProviderFactory labelProviderFactory, IssuesStatistics.StatisticProperties type) {
            StaticAnalysisLabelProvider labelProvider = labelProviderFactory.create(result.getId(), result.getName());
            this.name = labelProvider.getLinkName();
            this.icon = labelProvider.getSmallIconUrl();
            this.total = type.getSizeGetter().apply(result.getResult().getTotals());
            this.url = type.getUrl(result.getOwner().getNumber() + "/" + result.getUrlName());
        }

        public String getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int getTotal() {
            return this.total;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnalysisResultDescription that = (AnalysisResultDescription)o;
            return this.getTotal() == that.getTotal() && Objects.equals(this.getIcon(), that.getIcon()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getUrl(), that.getUrl());
        }

        public int hashCode() {
            return Objects.hash(this.getIcon(), this.getName(), this.getTotal(), this.getUrl());
        }

        public String toString() {
            return "AnalysisResultDescription{icon='" + this.getIcon() + "', name='" + this.getName() + "', total=" + this.getTotal() + ", url='" + this.getUrl() + "'}";
        }
    }

    @Extension(optional=true)
    @Symbol(value={"issueTotalsColumn"})
    public static class IssuesTablePortletDescriptor
    extends ListViewColumnDescriptor {
        private final JenkinsFacade jenkins;

        public IssuesTablePortletDescriptor() {
            this(new JenkinsFacade());
        }

        @VisibleForTesting
        IssuesTablePortletDescriptor(JenkinsFacade jenkins) {
            this.jenkins = jenkins;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IssuesTotalColumn_Name();
        }

        public boolean shownByDefault() {
            return IssuesTotalColumn.getConfiguration(this.jenkins).isEnableColumnByDefault();
        }

        @POST
        public ListBoxModel doFillTypeItems() {
            ListBoxModel model = new ListBoxModel();
            if (new JenkinsFacade().hasPermission(Jenkins.READ)) {
                for (IssuesStatistics.StatisticProperties qualityGateType : IssuesStatistics.StatisticProperties.values()) {
                    model.add(qualityGateType.getDisplayName(), qualityGateType.name());
                }
            }
            return model;
        }
    }
}

