/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.charts;

import edu.hm.hafner.echarts.SeriesBuilder;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import java.util.HashMap;
import java.util.Map;

public class HealthSeriesBuilder
extends SeriesBuilder<AnalysisBuildResult> {
    static final String HEALTHY = "healthy";
    static final String BETWEEN = "between";
    static final String UNHEALTHY = "unhealthy";
    static final String TOTAL = "total";
    private final HealthDescriptor healthDescriptor;

    public HealthSeriesBuilder(HealthDescriptor healthDescriptor) {
        this.healthDescriptor = healthDescriptor;
    }

    protected Map<String, Integer> computeSeries(AnalysisBuildResult current) {
        HashMap<String, Integer> series = new HashMap<String, Integer>();
        int remainder = current.getTotalSize();
        if (this.healthDescriptor.isEnabled()) {
            series.put(HEALTHY, Math.min(remainder, this.healthDescriptor.getHealthy()));
            int range = this.healthDescriptor.getUnhealthy() - this.healthDescriptor.getHealthy();
            if ((remainder -= this.healthDescriptor.getHealthy()) > 0) {
                series.put(BETWEEN, Math.min(remainder, range));
                series.put(UNHEALTHY, Math.max(remainder -= range, 0));
            } else {
                series.put(BETWEEN, 0);
                series.put(UNHEALTHY, 0);
            }
        } else {
            series.put(TOTAL, current.getTotalSize());
        }
        return series;
    }
}

