/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.charts;

import edu.hm.hafner.analysis.Severity;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.analysis.core.util.IssuesStatisticsBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CompositeBuildResult
implements AnalysisBuildResult {
    private final Map<String, Integer> sizesPerOrigin;
    private final IssuesStatistics totals;

    public CompositeBuildResult(Collection<? extends AnalysisBuildResult> results) {
        this.totals = results.stream().map(AnalysisBuildResult::getTotals).map(Objects::requireNonNull).reduce(new IssuesStatisticsBuilder().build(), IssuesStatistics::aggregate);
        this.sizesPerOrigin = results.stream().map(AnalysisBuildResult::getSizePerOrigin).reduce(new HashMap(), (first, second) -> {
            second.forEach((key, value) -> first.merge(key, value, Integer::sum));
            return first;
        });
    }

    @Override
    public Map<String, Integer> getSizePerOrigin() {
        return this.sizesPerOrigin;
    }

    @Override
    public int getFixedSize() {
        return this.getTotals().getFixedSize();
    }

    @Override
    public int getTotalSize() {
        return this.getTotals().getTotalSize();
    }

    @Override
    public int getTotalSizeOf(Severity severity) {
        return this.getTotals().getTotalSizeOf(severity);
    }

    @Override
    public int getNewSize() {
        return this.getTotals().getNewSize();
    }

    @Override
    public int getNewSizeOf(Severity severity) {
        return this.getTotals().getNewSizeOf(severity);
    }

    @Override
    public IssuesStatistics getTotals() {
        return this.totals;
    }
}

