/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedIntStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableIntStack;
import org.eclipse.collections.impl.stack.primitive.AbstractIntStack;

public class IntArrayStack
extends AbstractIntStack
implements MutableIntStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient IntArrayList delegate;

    public IntArrayStack() {
        this.delegate = new IntArrayList();
    }

    private IntArrayStack(int size) {
        this.delegate = new IntArrayList(size);
    }

    private IntArrayStack(int ... items) {
        this.delegate = new IntArrayList(items);
    }

    public static IntArrayStack newStackFromTopToBottom(int ... items) {
        IntArrayStack stack = new IntArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static IntArrayStack newStackWith(int ... items) {
        return new IntArrayStack(items);
    }

    public static IntArrayStack newStack(IntIterable items) {
        IntArrayStack stack = new IntArrayStack(items.size());
        stack.delegate = IntArrayList.newList(items);
        return stack;
    }

    public static IntArrayStack newStackFromTopToBottom(IntIterable items) {
        IntArrayStack stack = new IntArrayStack(items.size());
        stack.delegate = IntArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected IntArrayList getDelegate() {
        return this.delegate;
    }

    public void push(int item) {
        this.delegate.add(item);
    }

    public int pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    public IntList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new IntArrayList(0);
        }
        IntArrayList subList = new IntArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    public MutableIntStack select(IntPredicate predicate) {
        return IntArrayStack.newStackFromTopToBottom((IntIterable)this.delegate.asReversed().select(predicate));
    }

    public MutableIntStack reject(IntPredicate predicate) {
        return IntArrayStack.newStackFromTopToBottom((IntIterable)this.delegate.asReversed().reject(predicate));
    }

    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public void clear() {
        this.delegate.clear();
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public MutableIntStack asUnmodifiable() {
        return new UnmodifiableIntStack(this);
    }

    public MutableIntStack asSynchronized() {
        return new SynchronizedIntStack(this);
    }

    public ImmutableIntStack toImmutable() {
        return IntStacks.immutable.withAll((IntIterable)this.delegate);
    }

    public IntArrayStack newEmpty() {
        return new IntArrayStack();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        IntIterator iterator = this.delegate.asReversed().intIterator();
        while (iterator.hasNext()) {
            int each = iterator.next();
            out.writeInt(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        int[] array = new int[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readInt();
        }
        this.delegate = IntArrayList.newListWith(array);
    }
}

