/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.groovy;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Script;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import io.jenkins.plugins.analysis.warnings.groovy.DynamicDocumentParser;
import io.jenkins.plugins.analysis.warnings.groovy.DynamicLineParser;
import io.jenkins.plugins.analysis.warnings.groovy.GroovyExpressionMatcher;
import io.jenkins.plugins.analysis.warnings.groovy.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class GroovyParser
extends AbstractDescribableImpl<GroovyParser>
implements Serializable {
    private static final long serialVersionUID = 2447124045452896581L;
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    static final int MAX_EXAMPLE_SIZE = 4096;
    private final String id;
    private final String name;
    private final String regexp;
    private final String script;
    private final String example;
    @SuppressFBWarnings(value={"SE"})
    private transient JenkinsFacade jenkinsFacade = new JenkinsFacade();

    @DataBoundConstructor
    public GroovyParser(String id, String name, String regexp, String script, String example) {
        VALIDATION_UTILITIES.ensureValidId(id);
        this.id = id;
        this.name = name;
        this.regexp = regexp;
        this.script = script;
        this.example = example.length() > 4096 ? example.substring(0, 4096) : example;
    }

    private static boolean containsNewline(String expression) {
        return StringUtils.containsAny((CharSequence)expression, (CharSequence[])new CharSequence[]{"\\n", "\\r", "\\R"});
    }

    public boolean isValid() {
        DescriptorImpl d = new DescriptorImpl(this.getJenkinsFacade());
        return d.checkScript((String)this.script).kind == FormValidation.Kind.OK && d.checkRegexp((String)this.regexp).kind == FormValidation.Kind.OK && d.checkName((String)this.name).kind == FormValidation.Kind.OK;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public String getScript() {
        return this.script;
    }

    public String getExample() {
        return StringUtils.defaultString((String)this.example);
    }

    public final boolean hasMultiLineSupport() {
        return GroovyParser.containsNewline(this.regexp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroovyParser that = (GroovyParser)o;
        if (!this.regexp.equals(that.regexp)) {
            return false;
        }
        return this.script.equals(that.script);
    }

    public int hashCode() {
        int result = this.regexp.hashCode();
        result = 31 * result + this.script.hashCode();
        return result;
    }

    public IssueParser createParser() {
        DescriptorImpl descriptor = new DescriptorImpl(this.getJenkinsFacade());
        FormValidation nameCheck = descriptor.checkName(this.name);
        if (nameCheck.kind == FormValidation.Kind.ERROR) {
            throw new IllegalArgumentException("Name is not valid: " + nameCheck.getMessage());
        }
        FormValidation scriptCheck = descriptor.checkScript(this.script);
        if (scriptCheck.kind == FormValidation.Kind.ERROR) {
            throw new IllegalArgumentException("Script is not valid: " + scriptCheck.getMessage());
        }
        FormValidation regexpCheck = descriptor.checkRegexp(this.regexp);
        if (regexpCheck.kind == FormValidation.Kind.ERROR) {
            throw new IllegalArgumentException("RegExp is not valid: " + regexpCheck.getMessage());
        }
        if (this.hasMultiLineSupport()) {
            return new DynamicDocumentParser(this.regexp, this.script);
        }
        return new DynamicLineParser(this.regexp, this.script);
    }

    @VisibleForTesting
    void setJenkinsFacade(JenkinsFacade jenkinsFacade) {
        this.jenkinsFacade = jenkinsFacade;
    }

    private JenkinsFacade getJenkinsFacade() {
        return (JenkinsFacade)ObjectUtils.defaultIfNull((Object)this.jenkinsFacade, (Object)new JenkinsFacade());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GroovyParser> {
        private static final String NEWLINE = "\n";
        private static final int MAX_MESSAGE_LENGTH = 60;
        private static final FormValidation NO_RUN_SCRIPT_PERMISSION_WARNING = FormValidation.warning((String)Messages.GroovyParser_Warning_NoRunScriptPermission());
        private final JenkinsFacade jenkinsFacade;

        public DescriptorImpl() {
            this(new JenkinsFacade());
        }

        DescriptorImpl(JenkinsFacade jenkinsFacade) {
            this.jenkinsFacade = jenkinsFacade;
        }

        @POST
        public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter(required=true) String id) {
            if (!this.jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateId(id);
        }

        @POST
        public FormValidation doCheckName(@AncestorInPath BuildableItem project, @QueryParameter(required=true) String name) {
            if (!this.jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return this.checkName(name);
        }

        FormValidation checkName(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return FormValidation.error((String)Messages.GroovyParser_Error_Name_isEmpty());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckRegexp(@AncestorInPath BuildableItem project, @QueryParameter(required=true) String regexp) {
            if (!this.jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return this.checkRegexp(regexp);
        }

        FormValidation checkRegexp(String regexp) {
            try {
                if (StringUtils.isBlank((CharSequence)regexp)) {
                    return FormValidation.error((String)Messages.GroovyParser_Error_Regexp_isEmpty());
                }
                Pattern pattern = Pattern.compile(regexp);
                Ensure.that((Object)pattern, (Object[])new Object[0]).isNotNull();
                return FormValidation.ok();
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)Messages.GroovyParser_Error_Regexp_invalid(exception.getLocalizedMessage()));
            }
        }

        @POST
        public FormValidation doCheckScript(@AncestorInPath BuildableItem project, @QueryParameter(required=true) String script) {
            if (!this.jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            if (!this.jenkinsFacade.hasPermission(Jenkins.ADMINISTER)) {
                return NO_RUN_SCRIPT_PERMISSION_WARNING;
            }
            return this.checkScript(script);
        }

        FormValidation checkScript(String script) {
            try {
                if (StringUtils.isBlank((CharSequence)script)) {
                    return FormValidation.error((String)Messages.GroovyParser_Error_Script_isEmpty());
                }
                GroovyExpressionMatcher matcher = new GroovyExpressionMatcher(script);
                Script compiled = matcher.compile();
                Ensure.that((Object)compiled, (Object[])new Object[0]).isNotNull();
                return FormValidation.ok();
            }
            catch (CompilationFailedException exception) {
                return FormValidation.error((String)Messages.GroovyParser_Error_Script_invalid(exception.getLocalizedMessage()));
            }
        }

        @POST
        public FormValidation doCheckExample(@AncestorInPath BuildableItem project, @QueryParameter String example, @QueryParameter String regexp, @QueryParameter String script) {
            if (!this.jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            if (!this.jenkinsFacade.hasPermission(Jenkins.ADMINISTER)) {
                return NO_RUN_SCRIPT_PERMISSION_WARNING;
            }
            return this.checkExample(example, regexp, script);
        }

        FormValidation checkExample(String example, String regexp, String script) {
            if (StringUtils.isNotBlank((CharSequence)example) && StringUtils.isNotBlank((CharSequence)regexp) && StringUtils.isNotBlank((CharSequence)script)) {
                FormValidation response = this.parseExample(script, example, regexp, GroovyParser.containsNewline(regexp));
                if (example.length() <= 4096) {
                    return response;
                }
                return FormValidation.aggregate(Arrays.asList(FormValidation.warning((String)Messages.GroovyParser_long_examples_will_be_truncated()), response));
            }
            return FormValidation.ok();
        }

        private FormValidation parseExample(String script, String example, String regexp, boolean hasMultiLineSupport) {
            Pattern pattern = hasMultiLineSupport ? Pattern.compile(regexp, 8) : Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(example);
            try {
                if (matcher.find()) {
                    Object wrappedIssue;
                    GroovyExpressionMatcher checker = new GroovyExpressionMatcher(script);
                    Object result = checker.run(matcher, new IssueBuilder(), 0, "UI Example");
                    Optional optional = (Optional)result;
                    if (optional.isPresent() && (wrappedIssue = optional.get()) instanceof Issue) {
                        Issue issue = (Issue)wrappedIssue;
                        return this.createOkMessage(issue);
                    }
                    return FormValidation.error((String)Messages.GroovyParser_Error_Example_wrongReturnType(result));
                }
                return FormValidation.error((String)Messages.GroovyParser_Error_Example_regexpDoesNotMatch());
            }
            catch (Exception exception) {
                return FormValidation.error((String)Messages.GroovyParser_Error_Example_exception(exception.getMessage()));
            }
        }

        private FormValidation createOkMessage(Issue issue) {
            StringBuilder okMessage = new StringBuilder(Messages.GroovyParser_Error_Example_ok_title());
            this.message(okMessage, Messages.GroovyParser_Error_Example_ok_file(issue.getFileName()));
            this.message(okMessage, Messages.GroovyParser_Error_Example_ok_line(issue.getLineStart()));
            this.message(okMessage, Messages.GroovyParser_Error_Example_ok_priority(issue.getSeverity()));
            this.message(okMessage, Messages.GroovyParser_Error_Example_ok_category(issue.getCategory()));
            this.message(okMessage, Messages.GroovyParser_Error_Example_ok_type(issue.getType()));
            this.message(okMessage, Messages.GroovyParser_Error_Example_ok_message(issue.getMessage()));
            return FormValidation.ok((String)okMessage.toString());
        }

        private void message(StringBuilder okMessage, String message) {
            okMessage.append(NEWLINE);
            int max = 60;
            if (message.length() > max) {
                int size = max / 2 - 1;
                okMessage.append(message, 0, size);
                okMessage.append("[...]");
                okMessage.append(message, message.length() - size, message.length());
            } else {
                okMessage.append(message);
            }
        }

        @NonNull
        public String getDisplayName() {
            return "";
        }
    }
}

