/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.axivion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.analysis.warnings.axivion.AxIssueKind;
import io.jenkins.plugins.analysis.warnings.axivion.AxivionDashboard;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

class RemoteAxivionDashboard
implements AxivionDashboard {
    private static final String X_AXIVION_USER_AGENT = "x-axivion-user-agent";
    private static final String API_USER_AGENT = "ApiClient/6.9.3";
    private static final String FALL_USER_AGENT = "AxivionEclipsePlugin/6.9.2";
    private static final int HTTP_STATUS_OK = 200;
    private final String projectUrl;
    private final UsernamePasswordCredentials credentials;
    private final String namedFilter;

    RemoteAxivionDashboard(String projectUrl, UsernamePasswordCredentials credentials, String namedFilter) {
        this.projectUrl = projectUrl;
        this.credentials = credentials;
        this.namedFilter = namedFilter;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"RCN"}, justification="Value might be null in old serializations")
    public JsonObject getIssues(AxIssueKind kind) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)this.credentials);
        try (CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();){
            JsonObject jsonObject;
            block24: {
                URIBuilder uriBuilder = new URIBuilder(this.projectUrl + "/issues");
                uriBuilder.setParameter("kind", kind.toString());
                if (!this.namedFilter.isEmpty()) {
                    uriBuilder.setParameter("namedFilter", this.namedFilter);
                }
                HttpGet httpget = new HttpGet(uriBuilder.build());
                httpget.addHeader((Header)new BasicHeader("Accept", "application/json"));
                BasicHeader userAgent = new BasicHeader(X_AXIVION_USER_AGENT, API_USER_AGENT);
                httpget.addHeader((Header)userAgent);
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpget);){
                    if (response.getStatusLine().getStatusCode() == 200) {
                        JsonObject jsonObject2 = this.convertToJson((HttpResponse)response);
                        return jsonObject2;
                    }
                }
                httpget.removeHeader((Header)userAgent);
                httpget.addHeader((Header)new BasicHeader(X_AXIVION_USER_AGENT, FALL_USER_AGENT));
                CloseableHttpResponse legacyResponse = client.execute((HttpUriRequest)httpget);
                try {
                    jsonObject = this.convertToJson((HttpResponse)legacyResponse);
                    if (legacyResponse == null) break block24;
                }
                catch (Throwable throwable) {
                    if (legacyResponse != null) {
                        try {
                            legacyResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                legacyResponse.close();
            }
            return jsonObject;
        }
        catch (IOException | URISyntaxException e) {
            throw new ParsingException((Throwable)e, "Cannot retrieve information from dashboard", new Object[0]);
        }
    }

    private JsonObject convertToJson(HttpResponse response) throws IOException {
        try (InputStream is = response.getEntity().getContent();){
            JsonObject jsonObject;
            if (is == null) {
                throw new ParsingException("Response without a json body", new Object[0]);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                if (!json.isJsonObject()) {
                    throw new ParsingException("Invalid response from dashboard. Json object expected.", new Object[0]);
                }
                jsonObject = json.getAsJsonObject();
            }
            return jsonObject;
        }
    }
}

