/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.TypeSelector;

public class FileFinder
extends MasterToSlaveFileCallable<String[]> {
    private static final long serialVersionUID = 2970029366847565970L;
    private final String includesPattern;
    private final String excludesPattern;
    private final boolean followSymlinks;

    public FileFinder(String includesPattern) {
        this(includesPattern, "");
    }

    public FileFinder(String includesPattern, String excludesPattern) {
        this(includesPattern, excludesPattern, false);
    }

    public FileFinder(String includesPattern, String excludesPattern, boolean followSymlinks) {
        this.includesPattern = includesPattern;
        this.excludesPattern = excludesPattern;
        this.followSymlinks = followSymlinks;
    }

    public String[] invoke(File workspace, VirtualChannel channel) throws IOException {
        return this.find(workspace);
    }

    public String[] find(File workspace) {
        try {
            FileSet fileSet = new FileSet();
            Project antProject = new Project();
            fileSet.setProject(antProject);
            fileSet.setDir(workspace);
            fileSet.setIncludes(this.includesPattern);
            TypeSelector selector = new TypeSelector();
            TypeSelector.FileType fileType = new TypeSelector.FileType();
            fileType.setValue("file");
            selector.setType(fileType);
            fileSet.addType(selector);
            if (StringUtils.isNotBlank((CharSequence)this.excludesPattern)) {
                fileSet.setExcludes(this.excludesPattern);
            }
            fileSet.setFollowSymlinks(this.followSymlinks);
            return fileSet.getDirectoryScanner(antProject).getIncludedFiles();
        }
        catch (BuildException ignored) {
            return new String[0];
        }
    }
}

