/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import edu.hm.hafner.analysis.Issue;
import io.jenkins.plugins.forensics.blame.Blames;
import io.jenkins.plugins.forensics.blame.FileBlame;

public class Blame {
    static final String UNDEFINED = "-";
    static final int UNDEFINED_DATE = 0;
    private final String author;
    private final String email;
    private final String commit;
    private final int addedAt;

    public Blame(Issue issue, Blames blames) {
        if (blames.contains(issue.getFileName())) {
            FileBlame blameRequest = blames.getBlame(issue.getFileName());
            int line = issue.getLineStart();
            this.author = blameRequest.getName(line);
            this.email = blameRequest.getEmail(line);
            this.commit = blameRequest.getCommit(line);
            this.addedAt = blameRequest.getTime(line);
        } else {
            this.author = UNDEFINED;
            this.email = UNDEFINED;
            this.commit = UNDEFINED;
            this.addedAt = 0;
        }
    }

    public String getAuthorName() {
        return this.author;
    }

    public String getAuthorEmail() {
        return this.email;
    }

    public String getCommit() {
        return this.commit;
    }

    public int getAddedAt() {
        return this.addedAt;
    }
}

