/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.FilePath;
import hudson.model.Run;
import io.jenkins.plugins.prism.FilePermissionEnforcer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class AffectedFilesResolver {
    public static final String AFFECTED_FILES_FOLDER_NAME = "files-with-issues";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TEXT_EXTENSION = ".tmp";

    public static boolean hasAffectedFile(Run<?, ?> run, Issue issue) {
        return AffectedFilesResolver.canAccess(AffectedFilesResolver.getFile(run, issue.getFileName())) || AffectedFilesResolver.canAccess(AffectedFilesResolver.getZipFile(run, issue.getFileName()));
    }

    private static boolean canAccess(Path file) {
        return Files.isReadable(file);
    }

    static InputStream asStream(Run<?, ?> build, String fileName) throws IOException {
        try {
            Path file = AffectedFilesResolver.getFile(build, fileName);
            if (AffectedFilesResolver.canAccess(file)) {
                return Files.newInputStream(file, new OpenOption[0]);
            }
            return AffectedFilesResolver.extractFromZip(build, fileName);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream extractFromZip(Run<?, ?> build, String fileName) throws IOException, InterruptedException {
        Path tempDir = Files.createTempDirectory(AFFECTED_FILES_FOLDER_NAME, new FileAttribute[0]);
        FilePath unzippedSourcesDir = new FilePath(tempDir.toFile());
        try {
            Path zipFile = AffectedFilesResolver.getZipFile(build, fileName);
            FilePath inputZipFile = new FilePath(zipFile.toFile());
            inputZipFile.unzip(unzippedSourcesDir);
            StringUtils.removeEnd((String)zipFile.toString(), (String)ZIP_EXTENSION);
            Path sourceFile = tempDir.resolve(FilenameUtils.getName((String)fileName));
            InputStream inputStream = Files.newInputStream(sourceFile, new OpenOption[0]);
            return inputStream;
        }
        finally {
            try {
                unzippedSourcesDir.deleteRecursive();
            }
            catch (IOException | InterruptedException exception) {}
        }
    }

    public static Path getFile(Run<?, ?> run, String fileName) {
        return AffectedFilesResolver.getPath(run, AffectedFilesResolver.getTempName(fileName));
    }

    public static Path getZipFile(Run<?, ?> run, String fileName) {
        return AffectedFilesResolver.getPath(run, AffectedFilesResolver.getZipName(fileName));
    }

    private static Path getPath(Run<?, ?> run, String zipName) {
        return run.getRootDir().toPath().resolve(AFFECTED_FILES_FOLDER_NAME).resolve(zipName);
    }

    private static String getTempName(String fileName) {
        return Integer.toHexString(fileName.hashCode()) + TEXT_EXTENSION;
    }

    private static String getZipName(String fileName) {
        return AffectedFilesResolver.getTempName(fileName) + ZIP_EXTENSION;
    }

    public void copyAffectedFilesToBuildFolder(Report report, FilePath workspace, Set<String> permittedSourceDirectories, FilePath buildFolder) throws InterruptedException {
        this.copyAffectedFilesToBuildFolder(report, new RemoteFacade(workspace, permittedSourceDirectories, buildFolder));
    }

    @VisibleForTesting
    void copyAffectedFilesToBuildFolder(Report report, RemoteFacade remoteFacade) throws InterruptedException {
        int copied = 0;
        int notFound = 0;
        int notInWorkspace = 0;
        FilteredLog log = new FilteredLog("Can't copy some affected workspace files to Jenkins build folder:");
        for (Issue issue : report) {
            if (remoteFacade.existsInBuildFolder(issue.getFileName())) continue;
            if (remoteFacade.exists(issue.getAbsolutePath())) {
                if (remoteFacade.isInWorkspace(issue.getAbsolutePath())) {
                    try {
                        remoteFacade.copy(issue.getAbsolutePath(), issue.getFileName());
                        ++copied;
                    }
                    catch (IOException exception) {
                        log.logError("- '%s', IO exception has been thrown: %s", new Object[]{issue.getAbsolutePath(), exception});
                    }
                    continue;
                }
                ++notInWorkspace;
                continue;
            }
            ++notFound;
        }
        log.getInfoMessages().forEach(x$0 -> report.logInfo(x$0, new Object[0]));
        log.getErrorMessages().forEach(x$0 -> report.logError(x$0, new Object[0]));
        report.logInfo("-> %d copied, %d not in workspace, %d not-found, %d with I/O error", new Object[]{copied, notInWorkspace, notFound, log.size()});
    }

    static class RemoteFacade {
        private static final PathUtil PATH_UTIL = new PathUtil();
        private static final FilePermissionEnforcer PERMISSION_ENFORCER = new FilePermissionEnforcer();
        private final FilePath buildFolder;
        private final FilePath workspace;
        private final Set<String> permittedAbsolutePaths;

        RemoteFacade(FilePath workspace, Set<String> permittedSourceDirectories, FilePath buildFolder) {
            this.workspace = workspace;
            this.permittedAbsolutePaths = permittedSourceDirectories.stream().map(arg_0 -> ((PathUtil)PATH_UTIL).getAbsolutePath(arg_0)).collect(Collectors.toSet());
            this.buildFolder = buildFolder;
        }

        boolean exists(String fileName) {
            try {
                return this.createFile(fileName).exists();
            }
            catch (IOException | InterruptedException exception) {
                return false;
            }
        }

        private FilePath createFile(String fileName) {
            return new FilePath(this.workspace.getChannel(), fileName);
        }

        boolean isInWorkspace(String fileName) {
            String sourceFile = PATH_UTIL.getAbsolutePath(this.createFile(fileName).getRemote());
            return PERMISSION_ENFORCER.isInWorkspace(sourceFile, this.workspace, this.permittedAbsolutePaths);
        }

        public void copy(String from, String to) throws IOException, InterruptedException {
            FilePath file = this.createFile(from);
            if (!file.toVirtualFile().canRead()) {
                throw new IOException("Can't read file: " + from);
            }
            file.zip(this.computeBuildFolderFileName(to));
        }

        public boolean existsInBuildFolder(String fileName) {
            try {
                return this.computeBuildFolderFileName(fileName).exists();
            }
            catch (IOException | InterruptedException ignore) {
                return false;
            }
        }

        private FilePath computeBuildFolderFileName(String fileName) {
            return this.buildFolder.child(AffectedFilesResolver.getZipName(fileName));
        }
    }
}

