/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.hm.hafner.analysis.Severity;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.analysis.core.filter.RegexpFilter;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.core.steps.AnalysisExecution;
import io.jenkins.plugins.analysis.core.steps.AnalysisStepDescriptor;
import io.jenkins.plugins.analysis.core.steps.IssuesRecorder;
import io.jenkins.plugins.analysis.core.steps.Messages;
import io.jenkins.plugins.analysis.core.steps.ToolProxy;
import io.jenkins.plugins.analysis.core.steps.WarningChecksPublisher;
import io.jenkins.plugins.analysis.core.util.TrendChartType;
import io.jenkins.plugins.analysis.core.util.WarningsQualityGate;
import io.jenkins.plugins.checks.steps.ChecksInfo;
import io.jenkins.plugins.prism.SourceCodeDirectory;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.util.ResultHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.collections.impl.factory.Sets;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RecordIssuesStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private List<Tool> analysisTools = new ArrayList<Tool>();
    private String sourceCodeEncoding = "";
    private Set<SourceCodeDirectory> sourceDirectories = new HashSet<SourceCodeDirectory>();
    private SourceCodeRetention sourceCodeRetention = SourceCodeRetention.EVERY_BUILD;
    private boolean ignoreQualityGate;
    private int healthy;
    private int unhealthy;
    private Severity minimumSeverity = Severity.WARNING_LOW;
    private List<RegexpFilter> filters = new ArrayList<RegexpFilter>();
    private boolean isEnabledForFailure;
    private boolean isAggregatingResults;
    private boolean isBlameDisabled;
    private boolean skipPostProcessing;
    private boolean skipDeltaCalculation;
    private boolean skipPublishingChecks;
    private WarningChecksPublisher.ChecksAnnotationScope checksAnnotationScope = WarningChecksPublisher.ChecksAnnotationScope.NEW;
    private String id = "";
    private String name = "";
    private String icon = "";
    private List<WarningsQualityGate> qualityGates = new ArrayList<WarningsQualityGate>();
    private TrendChartType trendChartType = TrendChartType.AGGREGATION_TOOLS;
    private boolean failOnError;
    private String scm = "";
    private boolean quiet;

    @DataBoundConstructor
    public RecordIssuesStep() {
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    @DataBoundSetter
    public void setQualityGates(List<WarningsQualityGate> qualityGates) {
        this.qualityGates = qualityGates;
    }

    public List<WarningsQualityGate> getQualityGates() {
        return this.qualityGates;
    }

    @DataBoundSetter
    public void setId(String id) {
        VALIDATION_UTILITIES.ensureValidId(id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    @Deprecated
    @CheckForNull
    public List<ToolProxy> getToolProxies() {
        return this.analysisTools.stream().map(ToolProxy::new).collect(Collectors.toList());
    }

    @DataBoundSetter
    @Deprecated
    public void setToolProxies(List<ToolProxy> toolProxies) {
        this.analysisTools = toolProxies.stream().map(ToolProxy::getTool).collect(Collectors.toList());
    }

    @DataBoundSetter
    public void setTools(List<Tool> tools) {
        this.analysisTools = new ArrayList<Tool>(tools);
    }

    public void setTools(Tool tool, Tool ... additionalTools) {
        RecordIssuesStep.ensureThatToolIsValid(tool);
        for (Tool additionalTool : additionalTools) {
            RecordIssuesStep.ensureThatToolIsValid(additionalTool);
        }
        this.analysisTools = new ArrayList<Tool>();
        this.analysisTools.add(tool);
        Collections.addAll(this.analysisTools, additionalTools);
    }

    private static void ensureThatToolIsValid(Tool tool) {
        if (tool == null) {
            throw new IllegalArgumentException("No valid tool defined! You probably used a symbol in the tools definition that is also a symbol in another plugin. Additionally check if your step is called 'checkStyle' and not 'checkstyle', since 'checkstyle' is a reserved keyword in the CheckStyle plugin!If not please create a new bug report in Jenkins issue tracker.");
        }
    }

    public List<Tool> getTools() {
        return new ArrayList<Tool>(this.analysisTools);
    }

    @DataBoundSetter
    public void setTool(Tool tool) {
        RecordIssuesStep.ensureThatToolIsValid(tool);
        this.analysisTools = Collections.singletonList(tool);
    }

    @CheckForNull
    public Tool getTool() {
        return null;
    }

    @CheckForNull
    public String getSourceCodeEncoding() {
        return this.sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceCodeEncoding(String sourceCodeEncoding) {
        this.sourceCodeEncoding = sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceDirectories(List<SourceCodeDirectory> sourceDirectories) {
        this.sourceDirectories = new HashSet<SourceCodeDirectory>(sourceDirectories);
    }

    public List<SourceCodeDirectory> getSourceDirectories() {
        return new ArrayList<SourceCodeDirectory>(this.sourceDirectories);
    }

    private List<SourceCodeDirectory> getAllSourceDirectories() {
        return new ArrayList<SourceCodeDirectory>(new HashSet<SourceCodeDirectory>(this.getSourceDirectories()));
    }

    @DataBoundSetter
    public void setSourceCodeRetention(SourceCodeRetention sourceCodeRetention) {
        this.sourceCodeRetention = sourceCodeRetention;
    }

    public SourceCodeRetention getSourceCodeRetention() {
        return this.sourceCodeRetention;
    }

    public boolean getAggregatingResults() {
        return this.isAggregatingResults;
    }

    @DataBoundSetter
    public void setAggregatingResults(boolean aggregatingResults) {
        this.isAggregatingResults = aggregatingResults;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @DataBoundSetter
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isSkipBlames() {
        return this.isBlameDisabled;
    }

    @DataBoundSetter
    public void setSkipBlames(boolean skipBlames) {
        this.isBlameDisabled = skipBlames;
    }

    public boolean isSkipPostProcessing() {
        return this.skipPostProcessing;
    }

    @DataBoundSetter
    public void setSkipPostProcessing(boolean skipPostProcessing) {
        this.skipPostProcessing = skipPostProcessing;
    }

    public boolean isSkipDeltaCalculation() {
        return this.skipDeltaCalculation;
    }

    @DataBoundSetter
    public void setSkipDeltaCalculation(boolean skipDeltaCalculation) {
        this.skipDeltaCalculation = skipDeltaCalculation;
    }

    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    @DataBoundSetter
    public void setChecksAnnotationScope(WarningChecksPublisher.ChecksAnnotationScope checksAnnotationScope) {
        this.checksAnnotationScope = checksAnnotationScope;
    }

    public WarningChecksPublisher.ChecksAnnotationScope getChecksAnnotationScope() {
        return this.checksAnnotationScope;
    }

    @Deprecated
    public boolean isPublishAllIssues() {
        return this.getChecksAnnotationScope() == WarningChecksPublisher.ChecksAnnotationScope.ALL;
    }

    @Deprecated
    @DataBoundSetter
    public void setPublishAllIssues(boolean publishAllIssues) {
        this.checksAnnotationScope = publishAllIssues ? WarningChecksPublisher.ChecksAnnotationScope.ALL : WarningChecksPublisher.ChecksAnnotationScope.NEW;
    }

    public boolean getEnabledForFailure() {
        return this.isEnabledForFailure;
    }

    @DataBoundSetter
    public void setEnabledForFailure(boolean enabledForFailure) {
        this.isEnabledForFailure = enabledForFailure;
    }

    @DataBoundSetter
    public void setIgnoreQualityGate(boolean ignoreQualityGate) {
        this.ignoreQualityGate = ignoreQualityGate;
    }

    public boolean getIgnoreQualityGate() {
        return this.ignoreQualityGate;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public int getHealthy() {
        return this.healthy;
    }

    @DataBoundSetter
    public void setHealthy(int healthy) {
        this.healthy = healthy;
    }

    public int getUnhealthy() {
        return this.unhealthy;
    }

    @DataBoundSetter
    public void setUnhealthy(int unhealthy) {
        this.unhealthy = unhealthy;
    }

    @CheckForNull
    public String getMinimumSeverity() {
        return this.minimumSeverity.getName();
    }

    @DataBoundSetter
    public void setMinimumSeverity(String minimumSeverity) {
        this.minimumSeverity = Severity.valueOf((String)minimumSeverity, (Severity)Severity.WARNING_LOW);
    }

    @DataBoundSetter
    public void setTrendChartType(TrendChartType trendChartType) {
        this.trendChartType = trendChartType;
    }

    public TrendChartType getTrendChartType() {
        return this.trendChartType;
    }

    public List<RegexpFilter> getFilters() {
        return new ArrayList<RegexpFilter>(this.filters);
    }

    @DataBoundSetter
    public void setFilters(List<RegexpFilter> filters) {
        this.filters = new ArrayList<RegexpFilter>(filters);
    }

    public StepExecution start(StepContext context) {
        return new Execution(context, this);
    }

    @SuppressFBWarnings(value={"THROWS"}, justification="false positive")
    static class Execution
    extends AnalysisExecution<List<AnalysisResult>> {
        private static final long serialVersionUID = -2840020502160375407L;
        private final RecordIssuesStep step;

        Execution(@NonNull StepContext context, RecordIssuesStep step) {
            super(context);
            this.step = step;
        }

        protected List<AnalysisResult> run() throws IOException, InterruptedException {
            IssuesRecorder recorder = new IssuesRecorder();
            recorder.setTools(this.step.getTools());
            recorder.setSourceCodeRetention(this.step.getSourceCodeRetention());
            recorder.setSourceCodeEncoding(this.step.getSourceCodeEncoding());
            recorder.setIgnoreQualityGate(this.step.getIgnoreQualityGate());
            recorder.setHealthy(this.step.getHealthy());
            recorder.setUnhealthy(this.step.getUnhealthy());
            recorder.setMinimumSeverity(this.step.getMinimumSeverity());
            recorder.setFilters(this.step.getFilters());
            recorder.setEnabledForFailure(this.step.getEnabledForFailure());
            recorder.setAggregatingResults(this.step.getAggregatingResults());
            recorder.setBlameDisabled(this.step.isSkipBlames());
            recorder.setSkipPostProcessing(this.step.isSkipPostProcessing());
            recorder.setSkipDeltaCalculation(this.step.isSkipDeltaCalculation());
            recorder.setScm(this.step.getScm());
            recorder.setSkipPublishingChecks(this.step.isSkipPublishingChecks());
            recorder.setChecksAnnotationScope(this.step.getChecksAnnotationScope());
            recorder.setId(this.step.getId());
            recorder.setName(this.step.getName());
            recorder.setIcon(this.step.getIcon());
            recorder.setQualityGates(this.step.getQualityGates());
            recorder.setFailOnError(this.step.getFailOnError());
            recorder.setTrendChartType(this.step.getTrendChartType());
            recorder.setSourceDirectories(this.step.getAllSourceDirectories());
            recorder.setChecksInfo((ChecksInfo)this.getContext().get(ChecksInfo.class));
            recorder.setQuiet(this.step.isQuiet());
            FilePath workspace = this.getWorkspace();
            workspace.mkdirs();
            return recorder.perform(this.getRun(), workspace, this.getTaskListener(), (ResultHandler)this.createResultHandler());
        }
    }

    @Extension
    public static class Descriptor
    extends AnalysisStepDescriptor {
        public String getFunctionName() {
            return "recordIssues";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.ScanAndPublishIssues_DisplayName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Sets.immutable.of(FilePath.class, FlowNode.class, Run.class, TaskListener.class).castToSet();
        }
    }
}

