/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.hm.hafner.util.Ensure;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.util.PipelineResultHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

abstract class AnalysisExecution<T>
extends SynchronousNonBlockingStepExecution<T> {
    private static final long serialVersionUID = -127479018279069250L;

    AnalysisExecution(StepContext context) {
        super(context);
    }

    protected Run<?, ?> getRun() throws IOException, InterruptedException {
        Run run = (Run)this.getContext().get(Run.class);
        if (run == null) {
            throw new IOException("Can't resolve Run for " + String.valueOf((Object)this));
        }
        return run;
    }

    protected Optional<VirtualChannel> getChannel() throws IOException, InterruptedException {
        Computer computer = (Computer)this.getContext().get(Computer.class);
        if (computer == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(computer.getChannel());
    }

    protected FilePath getBuildFolder() throws IOException, InterruptedException {
        return new FilePath(this.getRun().getRootDir());
    }

    protected FilePath getWorkspace() throws IOException, InterruptedException {
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        if (workspace == null) {
            throw new IOException("No workspace available for " + String.valueOf((Object)this));
        }
        return workspace;
    }

    protected TaskListener getTaskListener() throws InterruptedException {
        try {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            if (listener != null) {
                return listener;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return TaskListener.NULL;
    }

    protected Charset getCharset(String charset) {
        return new ValidationUtilities().getCharset(charset);
    }

    protected PipelineResultHandler createResultHandler() throws IOException, InterruptedException {
        return new PipelineResultHandler(this.getRun(), this.getFlowNode());
    }

    private FlowNode getFlowNode() throws IOException, InterruptedException {
        FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
        Ensure.that((Object)flowNode, (Object[])new Object[0]).isNotNull("FlowNode is not defined in the context of " + String.valueOf((Object)this), new Object[0]);
        return flowNode;
    }
}

