/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.restapi;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.util.StaticAnalysisRun;
import io.jenkins.plugins.util.QualityGateResult;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class AnalysisResultApi {
    private final StaticAnalysisRun result;

    public AnalysisResultApi(StaticAnalysisRun result) {
        this.result = result;
    }

    @Exported
    public Run<?, ?> getOwner() {
        return this.result.getOwner();
    }

    @Exported
    public List<String> getErrorMessages() {
        return this.result.getErrorMessages().castToList();
    }

    @Exported
    public List<String> getInfoMessages() {
        return this.result.getInfoMessages().castToList();
    }

    @Exported
    public int getNoIssuesSinceBuild() {
        return this.result.getNoIssuesSinceBuild();
    }

    @Exported
    public int getSuccessfulSinceBuild() {
        return this.result.getSuccessfulSinceBuild();
    }

    @Exported(inline=true)
    public QualityGateResult.QualityGateResultApi getQualityGates() {
        return new QualityGateResult.QualityGateResultApi(this.result.getQualityGateResult());
    }

    @Exported
    @CheckForNull
    public Run<?, ?> getReferenceBuild() {
        return this.result.getReferenceBuild().orElse(null);
    }

    @Exported
    public int getTotalSize() {
        return this.result.getTotalSize();
    }

    @Exported
    public int getNewSize() {
        return this.result.getNewSize();
    }

    @Exported
    public int getFixedSize() {
        return this.result.getFixedSize();
    }
}

