/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.portlets;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.plugins.view.dashboard.DashboardPortlet;
import io.jenkins.plugins.analysis.core.charts.SeverityTrendChart;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.ToolSelection;
import io.jenkins.plugins.analysis.core.portlets.Messages;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class IssuesChartPortlet
extends DashboardPortlet {
    private boolean hideCleanJobs;
    private boolean selectTools;
    private List<ToolSelection> tools = new ArrayList<ToolSelection>();
    private List<Job<?, ?>> jobs = new ArrayList();
    private int height;

    @DataBoundConstructor
    public IssuesChartPortlet(String name) {
        super(name);
    }

    public boolean getHideCleanJobs() {
        return this.hideCleanJobs;
    }

    @DataBoundSetter
    public void setHideCleanJobs(boolean hideCleanJobs) {
        this.hideCleanJobs = hideCleanJobs;
    }

    public boolean getSelectTools() {
        return this.selectTools;
    }

    @DataBoundSetter
    public void setSelectTools(boolean selectTools) {
        this.selectTools = selectTools;
    }

    public List<ToolSelection> getTools() {
        return this.tools;
    }

    @DataBoundSetter
    public void setTools(List<ToolSelection> tools) {
        this.tools = tools;
    }

    public int getHeight() {
        return this.height;
    }

    @DataBoundSetter
    public void setHeight(int height) {
        this.height = height;
    }

    @JavaScriptMethod
    public String getBuildTrendModel() {
        SeverityTrendChart severityChart = new SeverityTrendChart();
        List<Iterable<? extends BuildResult<AnalysisBuildResult>>> histories = this.jobs.stream().filter(job -> job.getLastCompletedBuild() != null).map(Job::getLastCompletedBuild).flatMap(build -> build.getActions(ResultAction.class).stream().filter(ToolSelection.createToolFilter(this.selectTools, this.tools))).map(ResultAction::createBuildHistory).collect(Collectors.toList());
        return new JacksonFacade().toJson((Object)severityChart.aggregate(histories, new ChartModelConfiguration(ChartModelConfiguration.AxisType.DATE)));
    }

    public int register(List<Job<?, ?>> visibleJobs) {
        this.jobs = visibleJobs;
        return visibleJobs.size();
    }

    @Extension(optional=true)
    public static class IssuesChartPortletDescriptor
    extends Descriptor<DashboardPortlet> {
        @NonNull
        public String getDisplayName() {
            return Messages.IssuesChartPortlet_Name();
        }
    }
}

