/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Report;
import io.jenkins.plugins.analysis.core.model.Messages;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TabLabelProvider {
    private final Report report;

    public TabLabelProvider(Report report) {
        this.report = report;
    }

    public String getIssues() {
        return Messages.Tab_Issues();
    }

    public String getTools() {
        return Messages.Tab_Tools();
    }

    public String getToolName() {
        return Messages.Tab_Tool();
    }

    public String getModules() {
        return Messages.Tab_Modules();
    }

    public String getModuleName() {
        return Messages.Tab_Module();
    }

    public String getFiles() {
        return Messages.Tab_Files();
    }

    public String getFolders() {
        return Messages.Tab_Folders();
    }

    public String getFolderName() {
        return Messages.Tab_Folder();
    }

    public String getFolder() {
        return Messages.Tab_Folder();
    }

    public String getFileName() {
        return Messages.Tab_File();
    }

    public String getCategories() {
        return Messages.Tab_Categories();
    }

    public String getCategory() {
        return Messages.Tab_Category();
    }

    public String getTypes() {
        return Messages.Tab_Types();
    }

    public String getType() {
        return Messages.Tab_Type();
    }

    public String getDetails() {
        return Messages.Tab_Details();
    }

    public final String getPackageName() {
        return this.getPackageOrNamespace(Messages.Tab_Package(), Messages.Tab_Namespace(), Messages.Tab_Folder());
    }

    public final String getPackages() {
        return this.getPackageOrNamespace(Messages.Tab_Packages(), Messages.Tab_Namespaces(), Messages.Tab_Folders());
    }

    private String getPackageOrNamespace(String packageText, String nameSpaceText, String fallback) {
        if (this.report.isNotEmpty()) {
            Set fileTypes = this.report.getProperties(issue -> StringUtils.substringAfterLast((String)issue.getFileName(), (String)"."));
            if (fileTypes.contains("cs")) {
                return nameSpaceText;
            }
            if (fileTypes.contains("java") || fileTypes.contains("py")) {
                return packageText;
            }
        }
        return fallback;
    }
}

