/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.Generated;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AnalysisHistory;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ByIdResultSelector;
import io.jenkins.plugins.analysis.core.model.DetailsTableModel;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.HealthReportBuilder;
import io.jenkins.plugins.analysis.core.model.History;
import io.jenkins.plugins.analysis.core.model.IssuesDetail;
import io.jenkins.plugins.analysis.core.model.JobAction;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.SummaryModel;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import io.jenkins.plugins.analysis.core.util.TrendChartType;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.QualityGateResult;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@SuppressFBWarnings(value={"SE"}, justification="transient field owner ist restored using a Jenkins callback")
public class ResultAction
implements HealthReportingAction,
SimpleBuildStep.LastBuildAction,
RunAction2,
StaplerProxy,
Serializable {
    private static final long serialVersionUID = 6683647181785654908L;
    private transient Run<?, ?> owner;
    private final AnalysisResult result;
    private final HealthDescriptor healthDescriptor;
    private final String id;
    private final String name;
    private String icon;
    private final String charset;
    private TrendChartType trendChartType;

    public ResultAction(Run<?, ?> owner, AnalysisResult result, HealthDescriptor healthDescriptor, String id, String name, String icon, Charset charset, TrendChartType trendChartType) {
        this.owner = owner;
        this.result = result;
        this.healthDescriptor = healthDescriptor;
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.charset = charset.name();
        this.trendChartType = trendChartType;
    }

    protected Object readResolve() {
        if (this.trendChartType == null) {
            this.trendChartType = TrendChartType.TOOLS_ONLY;
        }
        if (this.icon == null) {
            this.icon = "";
        }
        return this;
    }

    @Whitelisted
    public String getId() {
        return this.id;
    }

    @Whitelisted
    public QualityGateResult getQualityGateResult() {
        return this.getResult().getQualityGateResult();
    }

    public String getName() {
        return this.name;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public History createBuildHistory() {
        return new AnalysisHistory(this.owner, new ByIdResultSelector(this.getId()));
    }

    public void onAttached(Run<?, ?> r) {
        this.owner = r;
        this.result.setOwner(r);
    }

    public void onLoad(Run<?, ?> r) {
        this.onAttached(r);
    }

    @Whitelisted
    public String getDisplayName() {
        return this.getLabelProvider().getLinkName();
    }

    public String getUrlName() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.id, (CharSequence)this.getLabelProvider().getId());
    }

    public String getRelativeUrl() {
        return this.getOwner().getUrl() + this.getUrlName();
    }

    public String getAbsoluteUrl() {
        return new JenkinsFacade().getAbsoluteUrl(new String[]{StringUtils.removeEnd((String)this.getOwner().getUrl(), (String)"/"), this.getUrlName()});
    }

    @CheckForNull
    public HealthReport getBuildHealth() {
        return new HealthReportBuilder().computeHealth(this.healthDescriptor, this.getLabelProvider(), this.getResult().getSizePerSeverity());
    }

    HealthDescriptor getHealthDescriptor() {
        return this.healthDescriptor;
    }

    public Collection<? extends Action> getProjectActions() {
        return Set.of(new JobAction(this.owner.getParent(), this.getLabelProvider(), this.result.getSizePerOrigin().size(), this.trendChartType, this.getUrlName()));
    }

    @Whitelisted
    public AnalysisResult getResult() {
        return this.result;
    }

    public String getIconFileName() {
        return this.getSmallImage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultAction that = (ResultAction)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean hasLargeImage() {
        return StringUtils.isNotBlank((CharSequence)this.getLargeImageName());
    }

    public String getLargeImageName() {
        return this.getLabelProvider().getLargeIconUrl();
    }

    public String getSmallImageName() {
        return this.getSmallImage();
    }

    public String getSmallImage() {
        return this.getLabelProvider().getSmallIconUrl();
    }

    public SummaryModel getSummaryModel() {
        return new SummaryModel(this.getLabelProvider(), this.getResult());
    }

    @Whitelisted
    public boolean isSuccessful() {
        return this.getResult().isSuccessful();
    }

    public String toString() {
        return "%s for %s".formatted(this.getClass().getName(), this.getLabelProvider().getName());
    }

    public StaticAnalysisLabelProvider getLabelProvider() {
        StaticAnalysisLabelProvider registeredLabelProvider = new LabelProviderFactory().create(this.getParserId(), this.name);
        if (StringUtils.isBlank((CharSequence)this.icon)) {
            return registeredLabelProvider;
        }
        return new CustomIconLabelProvider(registeredLabelProvider, this.icon);
    }

    private String getParserId() {
        String parserId = this.getResult().getParserId();
        if (this.isValidId(parserId)) {
            return parserId;
        }
        return this.id;
    }

    private boolean isValidId(String parserId) {
        return StringUtils.isNotBlank((CharSequence)parserId) && !"-".equals(parserId);
    }

    public IssuesDetail getTarget() {
        return new IssuesDetail(this.owner, this.result, this.getLabelProvider(), this.healthDescriptor, Charset.forName(this.charset));
    }

    @JavaScriptMethod
    public String resetReference() {
        return "{}";
    }

    private static class CustomIconLabelProvider
    extends StaticAnalysisLabelProvider {
        private final StaticAnalysisLabelProvider decorated;
        private final String icon;

        @Override
        public DetailsTableModel getIssuesModel(Run<?, ?> build, String url, Report report) {
            return this.decorated.getIssuesModel(build, url, report);
        }

        @Override
        public StaticAnalysisLabelProvider.DefaultAgeBuilder getAgeBuilder(Run<?, ?> owner, String url) {
            return this.decorated.getAgeBuilder(owner, url);
        }

        @Override
        public FileNameRenderer getFileNameRenderer(Run<?, ?> owner) {
            return this.decorated.getFileNameRenderer(owner);
        }

        @Override
        @VisibleForTesting
        public String getDefaultName() {
            return this.decorated.getDefaultName();
        }

        @Override
        public String getId() {
            return this.decorated.getId();
        }

        @Override
        public String getName() {
            return this.decorated.getName();
        }

        @Override
        public StaticAnalysisLabelProvider setName(@CheckForNull String name) {
            return this.decorated.setName(name);
        }

        @Override
        @Generated
        public String toString() {
            return this.decorated.toString();
        }

        @Override
        public String getLinkName() {
            return this.decorated.getLinkName();
        }

        @Override
        public String getTrendName() {
            return this.decorated.getTrendName();
        }

        @Override
        public String getToolTip(int numberOfItems) {
            return this.decorated.getToolTip(numberOfItems);
        }

        @Override
        public Localizable getToolTipLocalizable(int numberOfItems) {
            return this.decorated.getToolTipLocalizable(numberOfItems);
        }

        @Override
        public String getDescription(Issue issue) {
            return this.decorated.getDescription(issue);
        }

        @Override
        public String getSourceCodeDescription(Run<?, ?> build, Issue issue) {
            return this.decorated.getSourceCodeDescription(build, issue);
        }

        CustomIconLabelProvider(StaticAnalysisLabelProvider decorated, String icon) {
            super(decorated.getId(), decorated.getName());
            this.decorated = decorated;
            this.icon = icon;
        }

        @Override
        public String getSmallIconUrl() {
            return this.icon;
        }

        @Override
        public String getLargeIconUrl() {
            return this.icon;
        }
    }
}

