/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import edu.hm.hafner.analysis.DuplicationGroup;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.LineRangeList;
import edu.hm.hafner.util.TreeString;
import hudson.util.RobustCollectionConverter;
import hudson.util.RobustReflectionConverter;
import hudson.util.XStream2;
import io.jenkins.plugins.util.AbstractXmlStream;
import java.util.Collection;

class ReportXmlStream
extends AbstractXmlStream<Report> {
    ReportXmlStream() {
        super(Report.class);
    }

    public Report createDefaultValue() {
        return new Report();
    }

    protected void configureXStream(XStream2 xStream) {
        xStream.registerConverter((Converter)new ReportConverter(xStream.getMapper(), xStream.getReflectionProvider()));
        xStream.registerConverter((Converter)new LineRangeListConverter((XStream)xStream));
        xStream.registerConverter((Converter)new SeverityConverter());
        xStream.alias("lineRange", LineRange.class);
        xStream.alias("edu.hm.hafner.analysis.LineRangeList", LineRangeList.class);
        xStream.alias("edu.hm.hafner.analysis.LineRange", LineRange.class);
        xStream.alias("edu.hm.hafner.analysis.parser.dry.DuplicationGroup", DuplicationGroup.class);
        xStream.alias("treeString", TreeString.class);
        xStream.alias("issue", Issue.class);
        xStream.alias("analysisReport", Report.class);
    }

    private static class ReportConverter
    implements Converter {
        private final RobustReflectionConverter ref;

        ReportConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            this.ref = new RobustReflectionConverter(mapper, reflectionProvider);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            this.ref.marshal(source, writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return this.ref.unmarshal(reader, context);
        }

        public boolean canConvert(Class type) {
            return type == Report.class;
        }
    }

    private static final class LineRangeListConverter
    extends RobustCollectionConverter {
        LineRangeListConverter(XStream xs) {
            super(xs);
        }

        public boolean canConvert(Class type) {
            return type == LineRangeList.class;
        }

        protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection) {
            super.populateCollection(reader, context, collection);
            Ensure.that((Collection)collection).isInstanceOf(LineRangeList.class, new Class[0]);
            ((LineRangeList)collection).trim();
        }

        protected Object createCollection(Class type) {
            return new LineRangeList();
        }
    }

    private static final class SeverityConverter
    implements Converter {
        private SeverityConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            String string;
            if (source instanceof Severity) {
                Severity s = (Severity)source;
                string = s.getName();
            } else {
                string = null;
            }
            writer.setValue(string);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return Severity.valueOf((String)reader.getValue());
        }

        public boolean canConvert(Class type) {
            return type == Severity.class;
        }
    }
}

