/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.FileReaderFactory;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.FilteredLog;
import io.jenkins.plugins.util.AgentFileVisitor;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;

public class IssueReportScanner
extends AgentFileVisitor<Report> {
    private static final long serialVersionUID = 1743707071107346225L;
    private final IssueParser parser;

    public IssueReportScanner(String filePattern, String encoding, boolean followSymbolicLinks, IssueParser parser, boolean errorOnEmptyFiles) {
        super(filePattern, encoding, followSymbolicLinks, errorOnEmptyFiles);
        this.parser = parser;
    }

    protected Optional<Report> processFile(Path file, Charset charset, FilteredLog log) {
        try {
            Report fileReport = this.parser.parse((ReaderFactory)new FileReaderFactory(file, charset));
            log.logInfo("Successfully parsed file %s", new Object[]{file});
            log.logInfo("-> found %s (skipped %s)", new Object[]{this.plural(fileReport.getSize(), "issue"), this.plural(fileReport.getDuplicatesSize(), "duplicate")});
            return Optional.of(fileReport);
        }
        catch (ParsingException exception) {
            log.logException((Exception)((Object)exception), "Parsing of file '%s' failed due to an exception:", new Object[]{file});
        }
        catch (ParsingCanceledException ignored) {
            log.logInfo("Parsing of file %s has been canceled", new Object[]{file});
        }
        return Optional.empty();
    }
}

