/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.IssueDifference;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.analysis.core.util.IssuesStatisticsBuilder;

public class DeltaReport {
    private final Report allIssues;
    private final Report outstandingIssues;
    private final Report newIssues;
    private final Report fixedIssues;
    private final Report referenceIssues;
    private final String referenceBuildId;

    public DeltaReport(Report report, int currentBuildNumber) {
        Report empty;
        this.allIssues = report;
        this.outstandingIssues = report;
        this.referenceIssues = empty = report.copyEmptyInstance();
        this.newIssues = empty;
        this.fixedIssues = empty;
        this.referenceBuildId = "";
        report.logInfo("No valid reference build found", new Object[0]);
        report.logInfo("All reported issues will be considered outstanding", new Object[0]);
        report.setReference(String.valueOf(currentBuildNumber));
    }

    public DeltaReport(Report report, Run<?, ?> referenceBuild, int currentBuildNumber, Report referenceIssues) {
        report.logInfo("Using reference build '%s' to compute new, fixed, and outstanding issues", new Object[]{referenceBuild});
        this.allIssues = report;
        this.referenceIssues = referenceIssues;
        IssueDifference difference = new IssueDifference(report, String.valueOf(currentBuildNumber), referenceIssues);
        this.outstandingIssues = difference.getOutstandingIssues();
        this.newIssues = difference.getNewIssues();
        this.fixedIssues = difference.getFixedIssues();
        report.logInfo("Issues delta (vs. reference build): outstanding: %d, new: %d, fixed: %d", new Object[]{this.outstandingIssues.size(), this.newIssues.size(), this.fixedIssues.size()});
        this.referenceBuildId = referenceBuild.getExternalizableId();
    }

    public boolean isEmpty() {
        return this.allIssues.isEmpty();
    }

    public String getReferenceBuildId() {
        return this.referenceBuildId;
    }

    public Report getAllIssues() {
        return this.allIssues;
    }

    public Report getOutstandingIssues() {
        return this.outstandingIssues;
    }

    public Report getNewIssues() {
        return this.newIssues;
    }

    public Report getFixedIssues() {
        return this.fixedIssues;
    }

    public IssuesStatistics getStatistics() {
        IssuesStatisticsBuilder builder = new IssuesStatisticsBuilder();
        builder.setTotalErrorSize(this.allIssues.getSizeOf(Severity.ERROR)).setTotalHighSize(this.allIssues.getSizeOf(Severity.WARNING_HIGH)).setTotalNormalSize(this.allIssues.getSizeOf(Severity.WARNING_NORMAL)).setTotalLowSize(this.allIssues.getSizeOf(Severity.WARNING_LOW)).setTotalModifiedSize(this.allIssues.getInModifiedCode().size());
        builder.setNewErrorSize(this.newIssues.getSizeOf(Severity.ERROR)).setNewHighSize(this.newIssues.getSizeOf(Severity.WARNING_HIGH)).setNewNormalSize(this.newIssues.getSizeOf(Severity.WARNING_NORMAL)).setNewLowSize(this.newIssues.getSizeOf(Severity.WARNING_LOW)).setNewModifiedSize(this.newIssues.getInModifiedCode().size());
        builder.setFixedSize(this.fixedIssues.size());
        if (!this.referenceBuildId.isEmpty()) {
            builder.setDeltaErrorSize(this.allIssues.getSizeOf(Severity.ERROR) - this.referenceIssues.getSizeOf(Severity.ERROR)).setDeltaHighSize(this.allIssues.getSizeOf(Severity.WARNING_HIGH) - this.referenceIssues.getSizeOf(Severity.WARNING_HIGH)).setDeltaNormalSize(this.allIssues.getSizeOf(Severity.WARNING_NORMAL) - this.referenceIssues.getSizeOf(Severity.WARNING_NORMAL)).setDeltaLowSize(this.allIssues.getSizeOf(Severity.WARNING_LOW) - this.referenceIssues.getSizeOf(Severity.WARNING_LOW));
        }
        return builder.build();
    }
}

