/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.charts.JenkinsBuild;
import io.jenkins.plugins.analysis.core.model.DeltaReport;
import io.jenkins.plugins.analysis.core.model.ReportXmlStream;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.analysis.core.util.IssuesStatisticsBuilder;
import io.jenkins.plugins.analysis.core.util.StaticAnalysisRun;
import io.jenkins.plugins.forensics.blame.Blames;
import io.jenkins.plugins.forensics.blame.BlamesXmlStream;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.forensics.miner.RepositoryStatisticsXmlStream;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.QualityGateStatus;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

@SuppressFBWarnings(value={"SE, DESERIALIZATION_GADGET"}, justification="transient fields are restored using a Jenkins callback (or are checked for null)")
public class AnalysisResult
implements Serializable,
StaticAnalysisRun {
    private static final long serialVersionUID = 1110545450292087475L;
    private static final Pattern ISSUES_FILE_NAME = Pattern.compile("issues.xml", 16);
    private static final int NO_BUILD = -1;
    private static final String NO_REFERENCE = "";
    private final String id;
    private String parserId;
    private IssuesStatistics totals;
    private final Map<String, Integer> sizePerOrigin;
    private final List<String> errors;
    private final List<String> messages;
    private final String referenceBuildId;
    private transient ReentrantLock lock = new ReentrantLock();
    private transient Run<?, ?> owner;
    @CheckForNull
    private transient WeakReference<Report> outstandingIssuesReference;
    @CheckForNull
    private transient WeakReference<Report> newIssuesReference;
    @CheckForNull
    private transient WeakReference<Report> fixedIssuesReference;
    @CheckForNull
    private transient WeakReference<Blames> blamesReference;
    @CheckForNull
    private transient WeakReference<RepositoryStatistics> repositoryStatistics;
    private int noIssuesSinceBuild;
    private int successfulSinceBuild;
    private transient QualityGateStatus qualityGateStatus;
    private QualityGateResult qualityGateResult;

    public AnalysisResult(Run<?, ?> owner, String id, DeltaReport report, Blames blames, RepositoryStatistics totals, QualityGateResult qualityGateResult, Map<String, Integer> sizePerOrigin, AnalysisResult previousResult) {
        this(owner, id, report, blames, totals, qualityGateResult, sizePerOrigin, true);
        this.noIssuesSinceBuild = report.isEmpty() ? (previousResult.noIssuesSinceBuild == -1 ? owner.getNumber() : previousResult.noIssuesSinceBuild) : -1;
        QualityGateStatus overallStatus = qualityGateResult.getOverallStatus();
        this.successfulSinceBuild = overallStatus == QualityGateStatus.PASSED ? (previousResult.getQualityGateResult().getOverallStatus() == QualityGateStatus.PASSED ? previousResult.successfulSinceBuild : owner.getNumber()) : -1;
    }

    public AnalysisResult(Run<?, ?> owner, String id, DeltaReport report, Blames blames, RepositoryStatistics totals, QualityGateResult qualityGateResult, Map<String, Integer> sizePerOrigin) {
        this(owner, id, report, blames, totals, qualityGateResult, sizePerOrigin, true);
        this.noIssuesSinceBuild = report.isEmpty() ? owner.getNumber() : -1;
        this.successfulSinceBuild = qualityGateResult.getOverallStatus() == QualityGateStatus.PASSED ? owner.getNumber() : -1;
    }

    @VisibleForTesting
    protected AnalysisResult(Run<?, ?> owner, String id, DeltaReport report, Blames blames, RepositoryStatistics repositoryStatistics, QualityGateResult qualityGateResult, Map<String, Integer> sizePerOrigin, boolean canSerialize) {
        this.owner = owner;
        Report allIssues = report.getAllIssues();
        new ValidationUtilities().ensureValidId(id);
        this.id = id;
        this.parserId = allIssues.getParserId();
        this.totals = report.getStatistics();
        this.sizePerOrigin = new HashMap<String, Integer>(sizePerOrigin);
        this.referenceBuildId = report.getReferenceBuildId();
        Report outstandingIssues = report.getOutstandingIssues();
        this.outstandingIssuesReference = new WeakReference<Report>(outstandingIssues);
        Report newIssues = report.getNewIssues();
        this.newIssuesReference = new WeakReference<Report>(newIssues);
        Report fixedIssues = report.getFixedIssues();
        this.fixedIssuesReference = new WeakReference<Report>(fixedIssues);
        ArrayList aggregatedMessages = new ArrayList(allIssues.getInfoMessages());
        this.messages = new ArrayList<String>(aggregatedMessages);
        this.errors = new ArrayList<String>(allIssues.getErrorMessages());
        this.qualityGateResult = qualityGateResult;
        this.blamesReference = new WeakReference<Blames>(blames);
        this.repositoryStatistics = new WeakReference<RepositoryStatistics>(repositoryStatistics);
        if (canSerialize) {
            this.serializeIssues(outstandingIssues, newIssues, fixedIssues);
            this.serializeBlames(blames);
            this.serializeStatistics(repositoryStatistics);
        }
    }

    protected Object readResolve() {
        if (this.qualityGateResult == null && this.qualityGateStatus != null) {
            this.qualityGateResult = new QualityGateResult(this.qualityGateStatus);
        }
        if (this.totals == null) {
            this.totals = new IssuesStatisticsBuilder().build();
        }
        if (this.parserId == null) {
            this.parserId = this.id;
        }
        return this;
    }

    public Blames getBlames() {
        this.lock.lock();
        try {
            if (this.blamesReference == null) {
                Blames blames = this.readBlames();
                return blames;
            }
            Blames result = (Blames)this.blamesReference.get();
            if (result == null) {
                Blames blames = this.readBlames();
                return blames;
            }
            Blames blames = result;
            return blames;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RepositoryStatistics getForensics() {
        this.lock.lock();
        try {
            if (this.repositoryStatistics == null) {
                RepositoryStatistics repositoryStatistics = this.readStatistics();
                return repositoryStatistics;
            }
            RepositoryStatistics result = (RepositoryStatistics)this.repositoryStatistics.get();
            if (result == null) {
                RepositoryStatistics repositoryStatistics = this.readStatistics();
                return repositoryStatistics;
            }
            RepositoryStatistics repositoryStatistics = result;
            return repositoryStatistics;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void serializeBlames(Blames blames) {
        new BlamesXmlStream().write(this.getBlamesPath(), (Object)blames);
    }

    private Path getBlamesPath() {
        return this.getOwner().getRootDir().toPath().resolve(this.id + "-blames.xml");
    }

    private Blames readBlames() {
        Blames blames = (Blames)new BlamesXmlStream().read(this.getBlamesPath());
        this.blamesReference = new WeakReference<Blames>(blames);
        return blames;
    }

    private void serializeStatistics(RepositoryStatistics statistics) {
        new RepositoryStatisticsXmlStream().write(this.getStatisticsPath(), (Object)statistics);
    }

    private Path getStatisticsPath() {
        return this.getOwner().getRootDir().toPath().resolve(this.id + "-forensics.xml");
    }

    private RepositoryStatistics readStatistics() {
        RepositoryStatistics statistics = (RepositoryStatistics)new RepositoryStatisticsXmlStream().read(this.getStatisticsPath());
        this.repositoryStatistics = new WeakReference<RepositoryStatistics>(statistics);
        return statistics;
    }

    @Override
    @Whitelisted
    public String getId() {
        return this.id;
    }

    String getParserId() {
        return this.parserId;
    }

    @Override
    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Run<?, ?> owner) {
        this.owner = owner;
        this.lock = new ReentrantLock();
    }

    @Override
    @Whitelisted
    public ImmutableList<String> getErrorMessages() {
        return Lists.immutable.withAll(this.errors);
    }

    @Override
    @Whitelisted
    public ImmutableList<String> getInfoMessages() {
        return Lists.immutable.withAll(this.messages);
    }

    private String getSerializationFileName() {
        return this.id + "-issues.xml";
    }

    private void serializeIssues(Report outstandingIssues, Report newIssues, Report fixedIssues) {
        this.serializeIssues(outstandingIssues, "outstanding");
        this.serializeIssues(newIssues, "new");
        this.serializeIssues(fixedIssues, "fixed");
    }

    private void serializeIssues(Report report, String suffix) {
        new ReportXmlStream().write(this.getReportPath(suffix), report);
    }

    private Path getReportPath(String suffix) {
        return this.getOwner().getRootDir().toPath().resolve(ISSUES_FILE_NAME.matcher(this.getSerializationFileName()).replaceAll(Matcher.quoteReplacement(suffix + "-issues.xml")));
    }

    @Whitelisted
    public Report getIssues() {
        Report merged = new Report();
        merged.addAll(new Report[]{this.getNewIssues(), this.getOutstandingIssues()});
        return merged;
    }

    public boolean isEmpty() {
        return this.getTotals().getTotalSize() + this.getTotals().getFixedSize() == 0;
    }

    public boolean hasNoNewWarnings() {
        return this.getTotals().getNewSize() == 0;
    }

    @Whitelisted
    public Report getOutstandingIssues() {
        return this.getIssues(AnalysisResult::getOutstandingIssuesReference, AnalysisResult::setOutstandingIssuesReference, "outstanding");
    }

    @Whitelisted
    public Report getNewIssues() {
        return this.getIssues(AnalysisResult::getNewIssuesReference, AnalysisResult::setNewIssuesReference, "new");
    }

    @Whitelisted
    public Report getFixedIssues() {
        return this.getIssues(AnalysisResult::getFixedIssuesReference, AnalysisResult::setFixedIssuesReference, "fixed");
    }

    @CheckForNull
    private WeakReference<Report> getOutstandingIssuesReference() {
        return this.outstandingIssuesReference;
    }

    private void setOutstandingIssuesReference(WeakReference<Report> outstandingIssuesReference) {
        this.outstandingIssuesReference = outstandingIssuesReference;
    }

    @CheckForNull
    private WeakReference<Report> getNewIssuesReference() {
        return this.newIssuesReference;
    }

    private void setNewIssuesReference(WeakReference<Report> newIssuesReference) {
        this.newIssuesReference = newIssuesReference;
    }

    @CheckForNull
    private WeakReference<Report> getFixedIssuesReference() {
        return this.fixedIssuesReference;
    }

    private void setFixedIssuesReference(WeakReference<Report> fixedIssuesReference) {
        this.fixedIssuesReference = fixedIssuesReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Report getIssues(Function<AnalysisResult, WeakReference<Report>> getter, BiConsumer<AnalysisResult, WeakReference<Report>> setter, String suffix) {
        this.lock.lock();
        try {
            if (getter.apply(this) == null) {
                Report report = this.readIssues(setter, suffix);
                return report;
            }
            Report result = (Report)getter.apply(this).get();
            if (result == null) {
                Report report = this.readIssues(setter, suffix);
                return report;
            }
            Report report = result;
            return report;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Report readIssues(BiConsumer<AnalysisResult, WeakReference<Report>> setter, String suffix) {
        Report report = (Report)new ReportXmlStream().read(this.getReportPath(suffix));
        setter.accept(this, new WeakReference<Report>(report));
        return report;
    }

    @Override
    public int getNoIssuesSinceBuild() {
        return this.noIssuesSinceBuild;
    }

    @Override
    public int getSuccessfulSinceBuild() {
        return this.successfulSinceBuild;
    }

    public boolean isSuccessful() {
        return this.qualityGateResult.isSuccessful();
    }

    @Override
    @Whitelisted
    public QualityGateStatus getQualityGateStatus() {
        return this.qualityGateResult.getOverallStatus();
    }

    @Override
    @Whitelisted
    public QualityGateResult getQualityGateResult() {
        return this.qualityGateResult;
    }

    public String toString() {
        return this.getId() + " : " + this.getTotalSize() + " issues";
    }

    @Override
    @Whitelisted
    public Optional<Run<?, ?>> getReferenceBuild() {
        if (NO_REFERENCE.equals(this.referenceBuildId)) {
            return Optional.empty();
        }
        return new JenkinsFacade().getBuild(this.referenceBuildId);
    }

    @Override
    @Whitelisted
    public IssuesStatistics getTotals() {
        return this.totals;
    }

    @Override
    @Whitelisted
    public Map<String, Integer> getSizePerOrigin() {
        return Maps.immutable.ofAll(this.sizePerOrigin).toMap();
    }

    public Map<Severity, Integer> getSizePerSeverity() {
        return this.totals.getTotalSizePerSeverity().toMap();
    }

    public Map<Severity, Integer> getNewSizePerSeverity() {
        return this.totals.getTotalSizePerSeverity().toMap();
    }

    @Override
    @Whitelisted
    public int getTotalSize() {
        return this.totals.getTotalSize();
    }

    @Override
    @Whitelisted
    public int getTotalSizeOf(Severity severity) {
        return this.totals.getTotalSizeOf(severity);
    }

    public int getTotalErrorsSize() {
        return this.getTotalSizeOf(Severity.ERROR);
    }

    public int getTotalHighPrioritySize() {
        return this.getTotalSizeOf(Severity.WARNING_HIGH);
    }

    public int getTotalNormalPrioritySize() {
        return this.getTotalSizeOf(Severity.WARNING_NORMAL);
    }

    public int getTotalLowPrioritySize() {
        return this.getTotalSizeOf(Severity.WARNING_LOW);
    }

    @Override
    @Whitelisted
    public int getNewSize() {
        return this.totals.getNewSize();
    }

    @Override
    @Whitelisted
    public int getNewSizeOf(Severity severity) {
        return this.totals.getNewSizeOf(severity);
    }

    public int getNewErrorSize() {
        return this.getNewSizeOf(Severity.ERROR);
    }

    public int getNewHighPrioritySize() {
        return this.getNewSizeOf(Severity.WARNING_HIGH);
    }

    public int getNewNormalPrioritySize() {
        return this.getNewSizeOf(Severity.WARNING_NORMAL);
    }

    public int getNewLowPrioritySize() {
        return this.getNewSizeOf(Severity.WARNING_LOW);
    }

    @Override
    @Whitelisted
    public int getFixedSize() {
        return this.totals.getFixedSize();
    }

    public int getDeltaSize() {
        return this.totals.getDeltaSize();
    }

    public Build getBuild() {
        return new JenkinsBuild(this.getOwner());
    }

    static {
        Run.XSTREAM2.alias("item", QualityGateResult.QualityGateResultItem.class);
    }
}

