/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.analysis.registry.ParserRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.ReportScanningTool;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;

public abstract class AnalysisModelParser
extends ReportScanningTool {
    private static final long serialVersionUID = 3510579055771471269L;

    @Override
    public IssueParser createParser() {
        return this.getDescriptor().createParser(this.configureOptions());
    }

    protected ParserDescriptor.Option[] configureOptions() {
        return new ParserDescriptor.Option[0];
    }

    @Override
    @SuppressFBWarnings(value={"BC"})
    public AnalysisModelParserDescriptor getDescriptor() {
        return (AnalysisModelParserDescriptor)super.getDescriptor();
    }

    public static abstract class AnalysisModelParserDescriptor
    extends ReportScanningTool.ReportScanningToolDescriptor {
        private static final ParserRegistry REGISTRY = new ParserRegistry();
        private final RegistryIssueDescriptionProvider descriptionProvider;
        private final ParserDescriptor analysisModelDescriptor;

        protected AnalysisModelParserDescriptor(String id) {
            this(id, id);
        }

        protected AnalysisModelParserDescriptor(String id, String descriptionId) {
            super(id);
            this.analysisModelDescriptor = REGISTRY.get(descriptionId);
            this.descriptionProvider = new RegistryIssueDescriptionProvider(this.analysisModelDescriptor);
        }

        @Override
        public StaticAnalysisLabelProvider getLabelProvider() {
            return new StaticAnalysisLabelProvider(this.getId(), this.getDisplayName(), this.descriptionProvider, this.analysisModelDescriptor.getType());
        }

        protected DescriptionProvider getDescriptionProvider() {
            return this.descriptionProvider;
        }

        public IssueParser createParser(ParserDescriptor.Option ... options) {
            return this.analysisModelDescriptor.createParser(options);
        }

        @Override
        public String getPattern() {
            return this.analysisModelDescriptor.getPattern();
        }

        @Override
        public String getHelp() {
            return this.analysisModelDescriptor.getHelp();
        }

        @Override
        public String getUrl() {
            return this.analysisModelDescriptor.getUrl();
        }

        @NonNull
        public final String getDisplayName() {
            return this.analysisModelDescriptor.getName();
        }
    }

    private static class RegistryIssueDescriptionProvider
    implements DescriptionProvider {
        private final ParserDescriptor parserDescriptor;

        RegistryIssueDescriptionProvider(ParserDescriptor parserDescriptor) {
            this.parserDescriptor = parserDescriptor;
        }

        @Override
        public String getDescription(Issue issue) {
            return this.parserDescriptor.getDescription(issue);
        }
    }
}

