/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.charts.JenkinsBuild;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.History;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.ResultSelector;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;

public class AnalysisHistory
implements History {
    private static final int MIN_BUILDS = 2;
    private final Run<?, ?> baseline;
    private final ResultSelector selector;

    public AnalysisHistory(Run<?, ?> baseline, ResultSelector selector) {
        this.baseline = baseline;
        this.selector = selector;
    }

    @Override
    public Optional<ResultAction> getBaselineAction() {
        return this.selector.get(this.baseline);
    }

    @Override
    public Optional<AnalysisResult> getBaselineResult() {
        return this.getBaselineAction().map(ResultAction::getResult);
    }

    @Override
    public Optional<AnalysisResult> getResult() {
        return this.getPreviousAction().map(ResultAction::getResult);
    }

    @Override
    public Optional<Run<?, ?>> getBuild() {
        return this.getPreviousAction().map(ResultAction::getOwner);
    }

    @Override
    public Report getIssues() {
        return this.getResult().map(AnalysisResult::getIssues).orElseGet(Report::new);
    }

    private Optional<ResultAction> getPreviousAction() {
        Optional<Run<?, ?>> run = AnalysisHistory.getRunWithResult(this.baseline, this.selector);
        if (run.isPresent()) {
            return this.selector.get(run.get());
        }
        return Optional.empty();
    }

    private static Optional<Run<?, ?>> getRunWithResult(@CheckForNull Run<?, ?> start, ResultSelector selector) {
        for (Run run = start; run != null; run = run.getPreviousBuild()) {
            Optional<ResultAction> action = selector.get(run);
            if (!action.isPresent()) continue;
            return Optional.of(run);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasMultipleResults() {
        Iterator<BuildResult<AnalysisBuildResult>> iterator = this.iterator();
        int count = 1;
        while (iterator.hasNext()) {
            if (count >= 2) {
                return true;
            }
            iterator.next();
            ++count;
        }
        return false;
    }

    public String toString() {
        return "%s - %s".formatted(this.baseline.getFullDisplayName(), this.selector);
    }

    @Override
    @NonNull
    public Iterator<BuildResult<AnalysisBuildResult>> iterator() {
        return new AnalysisResultIterator(this.baseline, this.selector);
    }

    private static class AnalysisResultIterator
    implements Iterator<BuildResult<AnalysisBuildResult>> {
        private Optional<Run<?, ?>> cursor;
        private final ResultSelector selector;

        AnalysisResultIterator(Run<?, ?> baseline, ResultSelector selector) {
            this.cursor = AnalysisHistory.getRunWithResult(baseline, selector);
            this.selector = selector;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.isPresent();
        }

        @Override
        public BuildResult<AnalysisBuildResult> next() {
            if (this.cursor.isPresent()) {
                Run<?, ?> run = this.cursor.get();
                Optional<ResultAction> resultAction = this.selector.get(run);
                this.cursor = AnalysisHistory.getRunWithResult(run.getPreviousBuild(), this.selector);
                if (resultAction.isPresent()) {
                    return new BuildResult((Build)new JenkinsBuild(run), (Object)resultAction.get().getResult());
                }
            }
            throw new NoSuchElementException("No more runs with an analysis result available: " + String.valueOf(this.cursor));
        }
    }
}

