/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.filter;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import io.jenkins.plugins.analysis.core.filter.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class RegexpFilter
extends AbstractDescribableImpl<RegexpFilter>
implements Serializable {
    private static final long serialVersionUID = 1892735849628260157L;
    private final String pattern;

    RegexpFilter(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public abstract void apply(Report.IssueFilterBuilder var1);

    public static abstract class RegexpFilterDescriptor
    extends Descriptor<RegexpFilter> {
        private final JenkinsFacade jenkinsFacade;

        protected RegexpFilterDescriptor() {
            this(new JenkinsFacade());
        }

        @VisibleForTesting
        RegexpFilterDescriptor(JenkinsFacade jenkinsFacade) {
            this.jenkinsFacade = jenkinsFacade;
        }

        @POST
        public FormValidation doCheckPattern(@AncestorInPath BuildableItem project, @QueryParameter String pattern) {
            if (!this.jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            try {
                if (StringUtils.isBlank((CharSequence)pattern)) {
                    return FormValidation.ok((String)Messages.pattern_blank());
                }
                Pattern compiled = Pattern.compile(pattern);
                Ensure.that((Object)compiled, (Object[])new Object[0]).isNotNull();
                return FormValidation.ok();
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)Messages.pattern_error(exception.getLocalizedMessage()));
            }
        }
    }
}

