/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.charts;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.echarts.PieChartModel;
import edu.hm.hafner.echarts.PieData;
import io.jenkins.plugins.analysis.core.charts.Messages;
import io.jenkins.plugins.analysis.core.charts.SeverityPalette;
import io.jenkins.plugins.analysis.core.util.LocalizedSeverity;

public class SeverityPieChart {
    public PieChartModel create(Report report) {
        PieChartModel model = new PieChartModel(Messages.Severities_Name());
        for (Severity severity : Severity.getPredefinedValues()) {
            int total = report.getSizeOf(severity);
            if (total <= 0 && severity.equals((Object)Severity.ERROR)) continue;
            model.add(new PieData(LocalizedSeverity.getLocalizedString(severity), total), SeverityPalette.mapToColor(severity).normal());
        }
        return model;
    }
}

