/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl.post;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.dsl.post.VMGRPostLaunchStepImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class VMGRPostLaunchStep
extends Step {
    private String vAPIUrl;
    private boolean authRequired;
    private boolean advConfig;
    private String vAPIUser;
    private boolean dynamicUserId;
    private int connTimeout = 1;
    private int readTimeout = 30;
    private boolean advancedFunctions;
    private boolean retrieveSummaryReport;
    private boolean runReport;
    private boolean metricsReport;
    private boolean vPlanReport;
    private String testsViewName;
    private String metricsViewName;
    private String vplanViewName;
    private int testsDepth = 6;
    private int metricsDepth = 6;
    private int vPlanDepth = 6;
    private String metricsInputType;
    private String metricsAdvanceInput;
    private String vPlanInputType;
    private String vPlanAdvanceInput;
    private String vPlanxFileName;
    private String vAPIPassword;
    private String summaryType;
    private boolean ctxInput;
    private String ctxAdvanceInput;
    private String freeVAPISyntax;
    private boolean deleteReportSyntaxInputFile;
    private String vManagerVersion;
    private boolean sendEmail;
    private String emailList;
    private String emailType;
    private String emailInputFile;
    private boolean deleteEmailInputFile;
    private String summaryMode;
    private boolean ignoreSSLError;

    @DataBoundConstructor
    public VMGRPostLaunchStep(String vAPIUrl, String vAPIUser, String vAPIPassword, boolean authRequired, boolean advConfig, boolean dynamicUserId, int connTimeout, int readTimeout, boolean advancedFunctions, boolean retrieveSummaryReport, boolean runReport, boolean metricsReport, boolean vPlanReport, String testsViewName, String metricsViewName, String vplanViewName, int testsDepth, int metricsDepth, int vPlanDepth, String metricsInputType, String metricsAdvanceInput, String vPlanInputType, String vPlanAdvanceInput, String vPlanxFileName, String summaryType, boolean ctxInput, String ctxAdvanceInput, String freeVAPISyntax, boolean deleteReportSyntaxInputFile, String vManagerVersion, boolean sendEmail, String emailList, String emailType, String emailInputFile, boolean deleteEmailInputFile, String summaryMode, boolean ignoreSSLError) {
        this.vAPIUrl = vAPIUrl;
        this.authRequired = authRequired;
        this.advConfig = advConfig;
        this.vAPIUser = vAPIUser;
        this.vAPIPassword = vAPIPassword;
        this.dynamicUserId = dynamicUserId;
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.advancedFunctions = advancedFunctions;
        this.retrieveSummaryReport = retrieveSummaryReport;
        this.runReport = runReport;
        this.metricsReport = metricsReport;
        this.vPlanReport = vPlanReport;
        this.testsViewName = testsViewName;
        this.metricsViewName = metricsViewName;
        this.vplanViewName = vplanViewName;
        this.testsDepth = testsDepth;
        this.metricsDepth = metricsDepth;
        this.vPlanDepth = vPlanDepth;
        this.metricsInputType = metricsInputType;
        this.metricsAdvanceInput = metricsAdvanceInput;
        this.vPlanInputType = vPlanInputType;
        this.vPlanAdvanceInput = vPlanAdvanceInput;
        this.vPlanxFileName = vPlanxFileName;
        this.summaryType = summaryType;
        this.ctxInput = ctxInput;
        this.ctxAdvanceInput = ctxAdvanceInput;
        this.freeVAPISyntax = freeVAPISyntax;
        this.deleteReportSyntaxInputFile = deleteReportSyntaxInputFile;
        this.vManagerVersion = vManagerVersion;
        this.sendEmail = sendEmail;
        this.emailList = emailList;
        this.emailType = emailType;
        this.emailInputFile = emailInputFile;
        this.deleteEmailInputFile = deleteEmailInputFile;
        this.summaryMode = summaryMode;
        this.ignoreSSLError = ignoreSSLError;
    }

    public String getSummaryMode() {
        return this.summaryMode;
    }

    public String getEmailType() {
        return this.emailType;
    }

    public String getEmailInputFile() {
        return this.emailInputFile;
    }

    public boolean isDeleteEmailInputFile() {
        return this.deleteEmailInputFile;
    }

    public boolean isIgnoreSSLError() {
        return this.ignoreSSLError;
    }

    public String getVManagerVersion() {
        return this.vManagerVersion;
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public String getEmailList() {
        return this.emailList;
    }

    public boolean isDeleteReportSyntaxInputFile() {
        return this.deleteReportSyntaxInputFile;
    }

    public String getSummaryType() {
        return this.summaryType;
    }

    public boolean isCtxInput() {
        return this.ctxInput;
    }

    public String getCtxAdvanceInput() {
        return this.ctxAdvanceInput;
    }

    public String getFreeVAPISyntax() {
        return this.freeVAPISyntax;
    }

    public String getMetricsInputType() {
        return this.metricsInputType;
    }

    public String getMetricsAdvanceInput() {
        return this.metricsAdvanceInput;
    }

    public String getVPlanInputType() {
        return this.vPlanInputType;
    }

    public String getVPlanAdvanceInput() {
        return this.vPlanAdvanceInput;
    }

    public String getVPlanxFileName() {
        return this.vPlanxFileName;
    }

    public String getTestsViewName() {
        return this.testsViewName;
    }

    public String getMetricsViewName() {
        return this.metricsViewName;
    }

    public String getVplanViewName() {
        return this.vplanViewName;
    }

    public int getTestsDepth() {
        return this.testsDepth;
    }

    public int getMetricsDepth() {
        return this.metricsDepth;
    }

    public int getVPlanDepth() {
        return this.vPlanDepth;
    }

    public boolean isRunReport() {
        return this.runReport;
    }

    public boolean isMetricsReport() {
        return this.metricsReport;
    }

    public boolean isVPlanReport() {
        return this.vPlanReport;
    }

    public boolean isAdvancedFunctions() {
        return this.advancedFunctions;
    }

    public boolean isRetrieveSummaryReport() {
        return this.retrieveSummaryReport;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getVAPIPassword() {
        return this.vAPIPassword;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new VMGRPostLaunchStepImpl(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getFunctionName() {
            return "vmanagerPostBuildActions";
        }

        @Nonnull
        public String getDisplayName() {
            return "vManager Post Build Actions";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Run.class, Launcher.class, TaskListener.class, EnvVars.class);
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String vAPIUser, @QueryParameter(value="vAPIPassword") String vAPIPassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @QueryParameter(value="authRequired") boolean authRequired, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                Utils utils = new Utils();
                String output = utils.checkVAPIConnection(vAPIUrl, authRequired, vAPIUser, vAPIPassword);
                if (!output.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + output));
                }
                return FormValidation.error((String)output);
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        public ListBoxModel doFillVManagerVersionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("19.09 and above", "stream");
            items.add("Lower than 19.09", "html");
            return items;
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Verisium Manager vAPI HOST ");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }
    }
}

