/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl.post;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.vmanager.SummaryReportParams;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VAPIConnectionParam;
import org.jenkinsci.plugins.vmanager.dsl.post.DSLBuildAction;
import org.jenkinsci.plugins.vmanager.dsl.post.ReportBuildAction;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class DSLPublisher
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 4000009076155338047L;
    private transient Run<?, ?> build;
    private String vAPIUrl;
    private boolean authRequired;
    private boolean advConfig;
    private String vAPIUser;
    private Secret vAPIPassword;
    private boolean dynamicUserId;
    private int connTimeout = 1;
    private int readTimeout = 30;
    private boolean advancedFunctions = false;
    private boolean retrieveSummaryReport;
    private boolean runReport;
    private boolean metricsReport;
    private boolean vPlanReport;
    private String testsViewName;
    private String metricsViewName;
    private String vplanViewName;
    private int testsDepth = 6;
    private int metricsDepth = 6;
    private int vPlanDepth = 6;
    private String metricsInputType;
    private String metricsAdvanceInput;
    private String vPlanInputType;
    private String vPlanAdvanceInput;
    private String vPlanxFileName;
    private String summaryType;
    private boolean ctxInput;
    private String ctxAdvanceInput;
    private String freeVAPISyntax;
    private boolean deleteReportSyntaxInputFile;
    private String vManagerVersion;
    private boolean sendEmail;
    private String emailList;
    private String emailType;
    private String emailInputFile;
    private boolean deleteEmailInputFile;
    private String summaryMode;
    private boolean ignoreSSLError;
    private String credentialType;
    private String vAPICredentials;
    VAPIConnectionParam vAPIConnectionParam;
    SummaryReportParams summaryReportParams;

    @DataBoundConstructor
    public DSLPublisher(String vAPIUrl, String vAPIUser, Secret vAPIPassword, boolean authRequired, boolean advConfig, boolean dynamicUserId, int connTimeout, int readTimeout, boolean advancedFunctions, boolean retrieveSummaryReport, boolean runReport, boolean metricsReport, boolean vPlanReport, String testsViewName, String metricsViewName, String vplanViewName, int testsDepth, int metricsDepth, int vPlanDepth, String metricsInputType, String metricsAdvanceInput, String vPlanInputType, String vPlanAdvanceInput, String vPlanxFileName, String summaryType, boolean ctxInput, String ctxAdvanceInput, String freeVAPISyntax, boolean deleteReportSyntaxInputFile, String vManagerVersion, boolean sendEmail, String emailList, String emailType, String emailInputFile, boolean deleteEmailInputFile, String summaryMode, boolean ignoreSSLError, String vAPICredentials, String credentialType) {
        this.vAPIUrl = vAPIUrl;
        this.authRequired = authRequired;
        this.advConfig = advConfig;
        this.vAPIUser = vAPIUser;
        this.vAPIPassword = vAPIPassword;
        this.dynamicUserId = dynamicUserId;
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.advancedFunctions = advancedFunctions;
        this.retrieveSummaryReport = retrieveSummaryReport;
        this.runReport = runReport;
        this.metricsReport = metricsReport;
        this.vPlanReport = vPlanReport;
        this.testsViewName = testsViewName;
        this.metricsViewName = metricsViewName;
        this.vplanViewName = vplanViewName;
        this.testsDepth = testsDepth;
        this.metricsDepth = metricsDepth;
        this.vPlanDepth = vPlanDepth;
        this.metricsInputType = metricsInputType;
        this.metricsAdvanceInput = metricsAdvanceInput;
        this.vPlanInputType = vPlanInputType;
        this.vPlanAdvanceInput = vPlanAdvanceInput;
        this.vPlanxFileName = vPlanxFileName;
        this.summaryType = summaryType;
        this.ctxInput = ctxInput;
        this.ctxAdvanceInput = ctxAdvanceInput;
        this.freeVAPISyntax = freeVAPISyntax;
        this.deleteReportSyntaxInputFile = deleteReportSyntaxInputFile;
        this.vManagerVersion = vManagerVersion;
        this.sendEmail = sendEmail;
        this.emailList = emailList;
        this.emailType = emailType;
        this.emailInputFile = emailInputFile;
        this.deleteEmailInputFile = deleteEmailInputFile;
        this.summaryMode = summaryMode;
        this.ignoreSSLError = ignoreSSLError;
        this.vAPICredentials = vAPICredentials;
        this.credentialType = credentialType;
        this.vAPIConnectionParam = new VAPIConnectionParam();
        this.vAPIConnectionParam.vAPIUrl = vAPIUrl;
        this.vAPIConnectionParam.authRequired = authRequired;
        this.vAPIConnectionParam.advConfig = advConfig;
        this.vAPIConnectionParam.vAPIUser = vAPIUser;
        this.vAPIConnectionParam.connTimeout = connTimeout;
        this.vAPIConnectionParam.readTimeout = readTimeout;
        this.summaryReportParams = new SummaryReportParams();
        this.summaryReportParams.runReport = runReport;
        this.summaryReportParams.metricsReport = metricsReport;
        this.summaryReportParams.vPlanReport = vPlanReport;
        this.summaryReportParams.testsViewName = testsViewName;
        this.summaryReportParams.metricsViewName = metricsViewName;
        this.summaryReportParams.vplanViewName = vplanViewName;
        this.summaryReportParams.testsDepth = testsDepth;
        this.summaryReportParams.metricsDepth = metricsDepth;
        this.summaryReportParams.vPlanDepth = vPlanDepth;
        this.summaryReportParams.metricsInputType = metricsInputType;
        this.summaryReportParams.metricsAdvanceInput = metricsAdvanceInput;
        this.summaryReportParams.vPlanInputType = vPlanInputType;
        this.summaryReportParams.vPlanAdvanceInput = vPlanAdvanceInput;
        this.summaryReportParams.vPlanxFileName = vPlanxFileName;
        this.summaryReportParams.summaryType = summaryType;
        this.summaryReportParams.ctxInput = ctxInput;
        this.summaryReportParams.ctxAdvanceInput = ctxAdvanceInput;
        this.summaryReportParams.freeVAPISyntax = freeVAPISyntax;
        this.summaryReportParams.deleteReportSyntaxInputFile = deleteReportSyntaxInputFile;
        this.summaryReportParams.vManagerVersion = vManagerVersion;
        this.summaryReportParams.sendEmail = sendEmail;
        this.summaryReportParams.emailList = emailList;
        this.summaryReportParams.emailType = emailType;
        this.summaryReportParams.emailInputFile = emailInputFile;
        this.summaryReportParams.deleteEmailInputFile = deleteEmailInputFile;
        this.summaryReportParams.summaryMode = summaryMode;
        this.summaryReportParams.ignoreSSLError = ignoreSSLError;
    }

    public DSLPublisher() {
    }

    public String getSummaryMode() {
        return this.summaryMode;
    }

    public String getEmailType() {
        return this.emailType;
    }

    public String getEmailInputFile() {
        return this.emailInputFile;
    }

    public boolean isIgnoreSSLError() {
        return this.ignoreSSLError;
    }

    public boolean isDeleteEmailInputFile() {
        return this.deleteEmailInputFile;
    }

    public String getVManagerVersion() {
        return this.vManagerVersion;
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public String getEmailList() {
        return this.emailList;
    }

    public boolean isDeleteReportSyntaxInputFile() {
        return this.deleteReportSyntaxInputFile;
    }

    public String getSummaryType() {
        return this.summaryType;
    }

    public boolean isCtxInput() {
        return this.ctxInput;
    }

    public String getCtxAdvanceInput() {
        return this.ctxAdvanceInput;
    }

    public String getFreeVAPISyntax() {
        return this.freeVAPISyntax;
    }

    public String getMetricsInputType() {
        return this.metricsInputType;
    }

    public String getMetricsAdvanceInput() {
        return this.metricsAdvanceInput;
    }

    public String getVPlanInputType() {
        return this.vPlanInputType;
    }

    public String getVPlanAdvanceInput() {
        return this.vPlanAdvanceInput;
    }

    public String getVPlanxFileName() {
        return this.vPlanxFileName;
    }

    public String getTestsViewName() {
        return this.testsViewName;
    }

    public String getMetricsViewName() {
        return this.metricsViewName;
    }

    public String getVplanViewName() {
        return this.vplanViewName;
    }

    public int getTestsDepth() {
        return this.testsDepth;
    }

    public int getMetricsDepth() {
        return this.metricsDepth;
    }

    public int getVPlanDepth() {
        return this.vPlanDepth;
    }

    public boolean isRunReport() {
        return this.runReport;
    }

    public boolean isMetricsReport() {
        return this.metricsReport;
    }

    public boolean isVPlanReport() {
        return this.vPlanReport;
    }

    public boolean isAdvancedFunctions() {
        return this.advancedFunctions;
    }

    public boolean isRetrieveSummaryReport() {
        return this.retrieveSummaryReport;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getVAPICredentials() {
        return this.vAPICredentials;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public Secret getVAPIPassword() {
        return this.vAPIPassword;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath fp, @Nonnull Launcher launcher, @Nonnull TaskListener tl) throws InterruptedException, IOException {
        String vAPIPassword = this.getVAPIPassword().getPlainText();
        this.build = run;
        DSLBuildAction buildAction = new DSLBuildAction("NA", run);
        List buildActionList = run.getActions(DSLBuildAction.class);
        if (buildActionList.isEmpty()) {
            run.addAction((Action)buildAction);
        }
        if (this.advancedFunctions) {
            if ("credential".equals(this.credentialType)) {
                StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.vAPICredentials, StandardUsernamePasswordCredentials.class, run, Collections.emptyList());
                if (c != null) {
                    this.vAPIConnectionParam.vAPIUser = c.getUsername();
                    this.vAPIConnectionParam.vAPIPassword = c.getPassword().getPlainText();
                }
            } else {
                this.vAPIConnectionParam.vAPIPassword = vAPIPassword;
            }
            if (this.retrieveSummaryReport) {
                ReportBuildAction reportAction = new ReportBuildAction(run, this.summaryReportParams, this.vAPIConnectionParam, tl, fp, launcher);
                List reportActionList = run.getActions(ReportBuildAction.class);
                if (reportActionList.isEmpty()) {
                    run.addAction((Action)reportAction);
                }
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillVManagerVersionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("19.09 and above", "stream");
            items.add("Lower than 19.09", "html");
            return items;
        }

        public String getDisplayName() {
            return "vManager Post Build Actions";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String vAPIUser, @QueryParameter(value="vAPIPassword") Secret vAPIPassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @QueryParameter(value="authRequired") boolean authRequired, @QueryParameter(value="credentialType") String credentialType, @QueryParameter(value="vAPICredentials") String vAPICredentials, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                String tempUser = vAPIUser;
                String tempPassword = vAPIPassword.getPlainText();
                boolean foundMatchUserPassword = false;
                if ("credential".equals(credentialType)) {
                    List listOfC = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList());
                    Iterator cIterator = listOfC.iterator();
                    StandardUsernamePasswordCredentials tmpHolder = null;
                    while (cIterator.hasNext()) {
                        tmpHolder = (StandardUsernamePasswordCredentials)cIterator.next();
                        if (!vAPICredentials.equals(tmpHolder.getId())) continue;
                        tempUser = tmpHolder.getUsername();
                        tempPassword = tmpHolder.getPassword().getPlainText();
                        foundMatchUserPassword = true;
                        break;
                    }
                } else {
                    foundMatchUserPassword = true;
                }
                if (foundMatchUserPassword) {
                    Utils utils = new Utils();
                    String output = utils.checkVAPIConnection(vAPIUrl, authRequired, tempUser, tempPassword);
                    if (!output.startsWith("Failed")) {
                        return FormValidation.ok((String)("Success. " + output));
                    }
                    return FormValidation.error((String)output);
                }
                return FormValidation.error((String)"Could not extract the user/password from the supplied Credential object.  Object was not found within your Jenkins domain.");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the vManager vAPI HOST ");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillVAPICredentialsItems(@AncestorInPath Item item, @QueryParameter String vAPICredentials) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(vAPICredentials);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(vAPICredentials);
        }

        public FormValidation doCheckVAPICredentials(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            if (CredentialsProvider.listCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always()).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }
    }
}

