/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl.post;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.RunList;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.vmanager.PostActionBase;
import org.jenkinsci.plugins.vmanager.VMGRRun;

public class DSLProjectAction
extends PostActionBase
implements Serializable,
Action {
    private static final long serialVersionUID = 3000009076155338047L;
    private transient Job<?, ?> project;

    public String getIconFileName() {
        return "symbol-list-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return "Verisium Manager Jobs Overview";
    }

    public String getUrlName() {
        return "VMGRBuildView";
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public String getProjectName() {
        if (this.project == null) {
            return "Error - Project name was not set yet.  Please run build at least once after a Jenkins restart";
        }
        return this.project.getName();
    }

    public List<VMGRRun> getFinishedVMGRBuilds() {
        ArrayList<VMGRRun> recentBuilds = new ArrayList<VMGRRun>();
        if (this.project == null) {
            return recentBuilds;
        }
        RunList builds = this.project.getBuilds();
        VMGRRun tmpVMGRRun = null;
        Job job = null;
        String workingDir = null;
        int counter = 0;
        for (Run currentBuild : builds) {
            if (counter == 15) break;
            try {
                job = currentBuild.getParent();
                workingDir = job.getBuildDir().getAbsolutePath() + File.separator + currentBuild.getNumber();
                tmpVMGRRun = new VMGRRun(currentBuild, workingDir, job.getBuildDir().getAbsolutePath());
                recentBuilds.add(tmpVMGRRun);
                ++counter;
            }
            catch (Exception e) {
                System.out.println("Some old build don't have the action yet, hence can't get the list");
            }
        }
        return recentBuilds;
    }

    DSLProjectAction(Job<?, ?> project) {
        this.project = project;
    }
}

