/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl.post;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.vmanager.BuildStatusMap;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vmanager.PostActionBase;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRRun;
import org.jenkinsci.plugins.vmanager.dsl.post.DSLProjectAction;

public class DSLBuildAction
extends PostActionBase
implements Serializable,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private static final long serialVersionUID = 2000009076155338047L;
    private String message;
    private transient Run<?, ?> build;
    private final List projectActions;

    public String getIconFileName() {
        return "symbol-link-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return "Verisium Manager Session Links";
    }

    public String getUrlName() {
        return "vManagerSessionsView";
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getJobSessions() {
        Job job = this.build.getParent();
        String workingDir = String.valueOf(job.getBuildDir()) + File.separator + this.build.getNumber();
        this.vmgrRun = new VMGRRun(this.build, workingDir, job.getBuildDir().getAbsolutePath());
        String ids = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir(), "id", true);
        List<String> items = Arrays.asList(ids.split("\\s*,\\s*"));
        return items;
    }

    public String getvManagerLink(boolean buildLevel) {
        Object output = "#";
        if (this.build != null) {
            Job job = this.build.getParent();
            String workingDir = String.valueOf(job.getBuildDir()) + File.separator + this.build.getNumber();
            VMGRRun tmpVmgrRun = new VMGRRun(this.build, workingDir, job.getBuildDir().getAbsolutePath());
            String id = BuildStatusMap.getValue(tmpVmgrRun.getRun().getId(), tmpVmgrRun.getRun().getNumber(), tmpVmgrRun.getJobWorkingDir(), "id", true);
            if (id.indexOf(",") > 0) {
                output = buildLevel ? "vManagerSessionsView" : this.build.getNumber() + "/vManagerSessionsView";
            } else {
                String vAPIUrl = BuildStatusMap.getValue(tmpVmgrRun.getRun().getId(), tmpVmgrRun.getRun().getNumber(), tmpVmgrRun.getJobWorkingDir(), "url", false);
                output = Utils.getRegressionURLFromVAPIURL(vAPIUrl) + "?sessionid=" + id;
            }
        }
        return output;
    }

    public int getBuildNumber() {
        return this.build.number;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public DSLBuildAction(String message, Run<?, ?> build) {
        this.message = message;
        this.build = build;
        ArrayList<DSLProjectAction> tmpProjectActions = new ArrayList<DSLProjectAction>();
        tmpProjectActions.add(new DSLProjectAction(build.getParent()));
        this.projectActions = tmpProjectActions;
    }

    public Collection<? extends Action> getProjectActions() {
        return this.projectActions;
    }

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.build = run;
    }
}

