/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import org.jenkinsci.plugins.vmanager.JUnitRequestHolder;
import org.jenkinsci.plugins.vmanager.StepHolder;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRBuildArchiver;
import org.jenkinsci.plugins.vmanager.dsl.VMGRLaunchStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class VMGRLaunchStepImpl
extends SynchronousNonBlockingStepExecution {
    private static final long serialVersionUID = 1000009076155338047L;
    private final transient VMGRLaunchStep step;

    VMGRLaunchStepImpl(VMGRLaunchStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        File theWSDir;
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FilePath filePath = (FilePath)this.getContext().get(FilePath.class);
        String buildId = (String)envVars.get((Object)"BUILD_ID");
        int buildNumber = Integer.parseInt((String)envVars.get((Object)"BUILD_NUMBER"));
        Object workspace = (String)envVars.get((Object)"WORKSPACE");
        listener.getLogger().println("Setup is using nodes for job execution: " + this.step.isPipelineNodes());
        if (this.step.isPipelineNodes()) {
            String tmpJobName = (String)envVars.get((Object)"JOB_NAME");
            listener.getLogger().println("Master Job Name: " + tmpJobName);
            workspace = this.step.getMasterWorkspaceLocation() + File.separator + tmpJobName;
            listener.getLogger().println("Master worspace location: " + (String)workspace);
        }
        if (!(theWSDir = new File((String)workspace)).exists()) {
            listener.getLogger().println("creating workspace directory: " + theWSDir.getName());
            boolean result = false;
            try {
                result = theWSDir.mkdir();
            }
            catch (SecurityException se) {
                listener.getLogger().println("Failed to create workspace dir.  Permisisons issues");
                throw se;
            }
            if (result) {
                listener.getLogger().println("Workspace dir created");
            }
        }
        Run run = (Run)this.getContext().get(Run.class);
        String workingJobDir = run.getRootDir().getAbsolutePath();
        listener.getLogger().println("Root dir is: " + workingJobDir);
        listener.getLogger().println("Running Cadence vManager Session Launcher step");
        listener.getLogger().println("The HOST for vAPI is: " + this.step.getVAPIUrl());
        listener.getLogger().println("The vAPIUser for vAPI is: " + this.step.getVAPIUser());
        listener.getLogger().println("The vAPIPassword for vAPI is: *******");
        listener.getLogger().println("The authRequired for vAPI is: " + this.step.isAuthRequired());
        listener.getLogger().println("The id is: " + buildId);
        listener.getLogger().println("The number is: " + buildNumber);
        listener.getLogger().println("The workspace dir is: " + (String)workspace);
        listener.getLogger().println("The FilePath dir is: " + String.valueOf(filePath));
        if (this.step.isAdvConfig()) {
            listener.getLogger().println("The connection timeout is: " + this.step.getConnTimeout() + " minutes");
            listener.getLogger().println("The read api timeout is: " + this.step.getReadTimeout() + " minutes");
        } else {
            listener.getLogger().println("The connection timeout is: 1 minutes");
            listener.getLogger().println("The read api timeout is: 30 minutes");
        }
        listener.getLogger().println("In case build is interrupted, sesssion will get paused: " + this.step.isPauseSessionOnBuildInterruption());
        listener.getLogger().println("The execution type set is " + this.step.getExecutionType());
        if ("batch".equals(this.step.getExecutionType())) {
            listener.getLogger().println("The session input file name is: " + this.step.getSessionsInputFile());
            listener.getLogger().println("The deleteSessionInputFile : " + this.step.isDeleteSessionInputFile());
        }
        if ("hybrid".equals(this.step.getExecutionType())) {
            listener.getLogger().println("Hybrid batch model with script: " + this.step.getExecutionScript());
            listener.getLogger().println("Hybrid batch model with shell: " + this.step.getExecutionShellLocation());
            listener.getLogger().println("Hybrid batch model with vsif: " + this.step.getExecutionVsifFile());
        } else {
            listener.getLogger().println("The vsif to be executed is for vAPI is " + this.step.getVsifType());
            listener.getLogger().println("The vSIFName for vAPI is: " + this.step.getVSIFName());
            listener.getLogger().println("The vSIFPathForExternalVSIF Input for vAPI is: " + this.step.getVSIFInputFile());
            listener.getLogger().println("The deleteInputFile for vAPI is: " + this.step.isDeleteInputFile());
            if (this.step.isEnvVarible()) {
                listener.getLogger().println("An environment varible file was selected.");
            }
            if (this.step.isAttrValues()) {
                listener.getLogger().println("An attribute values file was selected.");
            }
            if (this.step.isDefineVarible()) {
                listener.getLogger().println("A define varible file was selected.");
            }
            if (this.step.isUseUserOnFarm()) {
                listener.getLogger().println("An User's Credential use was selected.");
                listener.getLogger().println("The User's Credential type is: " + this.step.getUserFarmType());
                listener.getLogger().println("User is using private stored SSH key: " + this.step.isUserPrivateSSHKey());
                if ("dynamic".equals(this.step.getUserFarmType())) {
                    listener.getLogger().println("The credential file is: " + this.step.getCredentialInputFile());
                    listener.getLogger().println("The credential file was set to be deleted after use: " + this.step.isDeleteCredentialInputFile());
                }
                if (this.step.getEnvSourceInputFile() != null && !"".equals(this.step.getEnvSourceInputFile().trim())) {
                    listener.getLogger().println("The User's source file is: " + this.step.getEnvSourceInputFile());
                    listener.getLogger().println("The User's source file type is: " + this.step.getEnvSourceInputFileType());
                } else {
                    listener.getLogger().println("The User's source file wasn't set");
                }
            }
        }
        StepHolder stepHolder = null;
        JUnitRequestHolder jUnitRequestHolder = null;
        if (this.step.isWaitTillSessionEnds()) {
            listener.getLogger().println("Build set to finish only when session finish to run");
            listener.getLogger().println("In case session is at state 'inaccessible' the build will " + this.step.getInaccessibleResolver());
            listener.getLogger().println("In case session is at state 'failed' the build will " + this.step.getFailedResolver());
            listener.getLogger().println("In case session is at state 'stopped' the build will " + this.step.getStoppedResolver());
            listener.getLogger().println("In case session is at state 'suspended' the build will " + this.step.getSuspendedResolver());
            listener.getLogger().println("In case session is at state 'done' the build will " + this.step.getDoneResolver());
            listener.getLogger().println("Timeout for entire step is " + this.step.getStepSessionTimeout() + " minutes");
            listener.getLogger().println("User choosed to mark regression as Failed in case all runs are failing: " + this.step.isMarkBuildAsFailedIfAllRunFailed());
            listener.getLogger().println("User choosed to fail the job in case all runs are failing: " + this.step.isFailJobIfAllRunFailed());
            listener.getLogger().println("User choosed to mark regression as Passed in case all runs are passed: " + this.step.isMarkBuildAsPassedIfAllRunPassed());
            listener.getLogger().println("User choosed to fail the job unless all runs are passed: " + this.step.isFailJobUnlessAllRunPassed());
            listener.getLogger().println("Generate XML Report XML output: " + this.step.isGenerateJUnitXML());
            if (this.step.isGenerateJUnitXML()) {
                listener.getLogger().println("Do not append seed to test names: " + this.step.isNoAppendSeed());
                jUnitRequestHolder = new JUnitRequestHolder(this.step.isGenerateJUnitXML(), this.step.isExtraAttributesForFailures(), this.step.getStaticAttributeList(), this.step.isNoAppendSeed());
                listener.getLogger().println("Extra Attributes in JUnit Report: " + this.step.isExtraAttributesForFailures());
                if (this.step.isExtraAttributesForFailures()) {
                    listener.getLogger().println("Extra Attributes list in JUnit Report is: " + this.step.getStaticAttributeList());
                }
            }
            stepHolder = new StepHolder(this.step.getInaccessibleResolver(), this.step.getStoppedResolver(), this.step.getFailedResolver(), this.step.getDoneResolver(), this.step.getSuspendedResolver(), this.step.isWaitTillSessionEnds(), this.step.getStepSessionTimeout(), jUnitRequestHolder, this.step.isMarkBuildAsFailedIfAllRunFailed(), this.step.isFailJobIfAllRunFailed(), this.step.isMarkBuildAsPassedIfAllRunPassed(), this.step.isFailJobUnlessAllRunPassed(), this.step.isPauseSessionOnBuildInterruption());
        }
        VMGRBuildArchiver vMGRBuildArchiver = null;
        if (this.step.isVMGRBuildArchive()) {
            listener.getLogger().println("Session was set to get deleted when build is deleted");
            listener.getLogger().println("Delete also session directory on disk: " + this.step.isDeleteAlsoSessionDirectory());
            listener.getLogger().println("Use dedicated credentials for deleting the session: " + this.step.isGenericCredentialForSessionDelete());
            listener.getLogger().println("Use FAM Mode: " + this.step.getFamMode());
            if ("true".equals(this.step.getFamMode())) {
                listener.getLogger().println("FAM Mode Location: " + this.step.getFamModeLocation());
            }
            if (this.step.isGenericCredentialForSessionDelete()) {
                listener.getLogger().println("Dedicated User for session delete: " + this.step.getArchiveUser());
                listener.getLogger().println("Dedicated password for session delete: *******");
            }
            vMGRBuildArchiver = new VMGRBuildArchiver(this.step.isVMGRBuildArchive(), this.step.isGenericCredentialForSessionDelete(), this.step.isGenericCredentialForSessionDelete(), this.step.getArchiveUser(), this.step.getArchivePassword(), this.step.getFamMode(), this.step.getFamModeLocation());
        }
        try {
            String output;
            Utils utils = new Utils(run, listener, filePath);
            String[] vsifFileNames = null;
            String[] sessionNames = null;
            String jsonEnvInput = null;
            String jsonDefineInput = null;
            String jsonAttrValuesInput = null;
            String[] farmUserPassword = null;
            String tempUser = this.step.getVAPIUser();
            String tempPassword = this.step.getVAPIPassword();
            String tmpExecutionType = this.step.getExecutionType();
            if ("batch".equals(this.step.getExecutionType())) {
                if (this.step.getSessionsInputFile() == null || this.step.getSessionsInputFile().trim().equals("")) {
                    listener.getLogger().println("The session input file chosen is dynamic. Dynamic workspace directory: '" + (String)workspace + "'");
                } else {
                    listener.getLogger().println("The session input file chosen is static. Sessions input file name is: '" + this.step.getSessionsInputFile().trim() + "'");
                }
                sessionNames = utils.loadDataFromInputFiles(buildId, buildNumber, (String)workspace, this.step.getSessionsInputFile(), listener, this.step.isDeleteSessionInputFile(), "session names", "sessions.input");
                if (sessionNames.length == 0) {
                    listener.getLogger().println("No session were found within sessions.input file.  Exit Job.\n");
                    throw new Exception("No session were found within sessions.input file.  Exit Job.\n");
                }
            } else if ("hybrid".equals(this.step.getExecutionType())) {
                tmpExecutionType = "batch";
                utils.batchExecManager(listener, this.step.getExecutionScript(), this.step.getExecutionShellLocation(), this.step.getExecutionVsifFile(), buildId, buildNumber, launcher);
                sessionNames = utils.loadDataFromInputFiles(buildId, buildNumber, (String)workspace, "", listener, false, "session names", "sessions.input");
                if (sessionNames.length == 0) {
                    listener.getLogger().println("No session were found within sessions.input file.  Exit Job.\n");
                    throw new Exception("Failed to launch sessions for build " + buildId + " " + buildNumber + "\n");
                }
            } else {
                if ("static".equals(this.step.getVsifType())) {
                    listener.getLogger().println("The VSIF file chosen is static. VSIF file static location is: '" + this.step.getVSIFName() + "'");
                    vsifFileNames = new String[]{this.step.getVSIFName()};
                } else {
                    if (this.step.getVSIFInputFile() != null && !this.step.getVSIFInputFile().trim().equals("")) {
                        listener.getLogger().println("The VSIF file chosen is static. VSIF file name is: '" + this.step.getVSIFInputFile().trim() + "'");
                    }
                    vsifFileNames = utils.loadDataFromInputFiles(buildId, buildNumber, (String)workspace, this.step.getVSIFInputFile(), listener, this.step.isDeleteInputFile(), "VSIF", "vsif.input");
                }
                if (this.step.isEnvVarible()) {
                    if (this.step.getEnvVaribleFile() == null || this.step.getEnvVaribleFile().trim().equals("")) {
                        listener.getLogger().println("The environment varible file chosen is dynamic. Env File directory dynamic workspace directory: '" + (String)workspace + "'");
                    } else {
                        listener.getLogger().println("The environment varible file chosen is static. Environment file name is: '" + this.step.getEnvVaribleFile().trim() + "'");
                    }
                    jsonEnvInput = utils.loadJSONEnvInput(buildId, buildNumber, (String)workspace, this.step.getEnvVaribleFile(), listener);
                    listener.getLogger().println("Found the following environment for the vsif: " + jsonEnvInput);
                }
                if (this.step.isAttrValues()) {
                    if (this.step.getAttrValuesFile() == null || this.step.getAttrValuesFile().trim().equals("")) {
                        listener.getLogger().println("The attribute values file chosen is dynamic. Attribute values File directory dynamic workspace directory: '" + (String)workspace + "'");
                    } else {
                        listener.getLogger().println("The attribute values file chosen is static. Attribute values file name is: '" + this.step.getAttrValuesFile().trim() + "'");
                    }
                    jsonAttrValuesInput = utils.loadJSONAttrValuesInput(buildId, buildNumber, (String)workspace, this.step.getAttrValuesFile(), listener);
                    listener.getLogger().println("Found the following attribute values for the vsif: " + jsonAttrValuesInput);
                }
                if (this.step.isDefineVarible()) {
                    if (this.step.getDefineVaribleFile() == null || this.step.getDefineVaribleFile().trim().equals("")) {
                        listener.getLogger().println("The define values file chosen is dynamic. Define values File directory dynamic workspace directory: '" + (String)workspace + "'");
                    } else {
                        listener.getLogger().println("The define values file chosen is static. Define values file name is: '" + this.step.getDefineVaribleFile().trim() + "'");
                    }
                    jsonDefineInput = utils.loadJSONDefineInput(buildId, buildNumber, (String)workspace, this.step.getDefineVaribleFile(), listener);
                    listener.getLogger().println("Found the following define values for the vsif: " + jsonDefineInput);
                }
                if ("dynamic".equals(this.step.getUserFarmType())) {
                    if (this.step.getCredentialInputFile() == null || this.step.getCredentialInputFile().trim().equals("")) {
                        listener.getLogger().println("The credential file chosen is dynamic. Credential directory dynamic workspace directory: '" + (String)workspace + "'");
                    } else {
                        listener.getLogger().println("The credential file chosen is static. Credential file name is: '" + this.step.getCredentialInputFile().trim() + "'");
                    }
                    farmUserPassword = utils.loadFileCredentials(buildId, buildNumber, (String)workspace, this.step.getCredentialInputFile(), listener, this.step.isDeleteCredentialInputFile());
                    if (this.step.isUserPrivateSSHKey()) {
                        tempUser = farmUserPassword[0];
                        tempPassword = farmUserPassword[1];
                    }
                }
            }
            if (!"success".equals(output = utils.executeVSIFLaunch(vsifFileNames, this.step.getVAPIUrl(), this.step.isAuthRequired(), tempUser, tempPassword, listener, this.step.isDynamicUserId(), buildId, buildNumber, (String)workspace, this.step.getConnTimeout(), this.step.getReadTimeout(), this.step.isAdvConfig(), jsonEnvInput, this.step.isUseUserOnFarm(), this.step.getUserFarmType(), farmUserPassword, stepHolder, this.step.getEnvSourceInputFile(), workingJobDir, vMGRBuildArchiver, this.step.isUserPrivateSSHKey(), jsonAttrValuesInput, tmpExecutionType, sessionNames, this.step.getEnvSourceInputFileType(), launcher, jsonDefineInput))) {
                listener.getLogger().println("Failed to launch vsifs for build " + buildId + " " + buildNumber + "\n");
                listener.getLogger().println(output + "\n");
                throw new Exception("Failed to launch vsifs for build " + buildId + " " + buildNumber + "\n");
            }
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            for (StackTraceElement ste : e.getStackTrace()) {
                listener.getLogger().println(" " + String.valueOf(ste));
            }
            throw e;
        }
        return null;
    }
}

