/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.dsl.VMGRLaunchStepImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class VMGRLaunchStep
extends Step {
    private final String vAPIUrl;
    private boolean authRequired;
    private boolean advConfig;
    private final String vAPIUser;
    private final String vAPIPassword;
    private final String vSIFName;
    private final String vSIFInputFile;
    private String credentialInputFile;
    private boolean deleteInputFile;
    private boolean deleteCredentialInputFile;
    private boolean useUserOnFarm;
    private boolean dynamicUserId;
    private String vsifType;
    private String userFarmType;
    private String envSourceInputFile;
    private int connTimeout = 1;
    private int readTimeout = 30;
    private boolean envVarible;
    private String envVaribleFile;
    private boolean attrValues;
    private String attrValuesFile;
    private boolean pipelineNodes;
    private String masterWorkspaceLocation;
    private String envSourceInputFileType = "BSH";
    private String inaccessibleResolver = "fail";
    private String stoppedResolver = "fail";
    private String failedResolver = "fail";
    private String doneResolver = "ignore";
    private String suspendedResolver = "ignore";
    private boolean waitTillSessionEnds;
    private int stepSessionTimeout = 30;
    private boolean generateJUnitXML;
    private boolean extraAttributesForFailures;
    private String staticAttributeList;
    private boolean markBuildAsFailedIfAllRunFailed;
    private boolean failJobIfAllRunFailed;
    private boolean markBuildAsPassedIfAllRunPassed;
    private boolean failJobUnlessAllRunPassed;
    private boolean userPrivateSSHKey;
    private final boolean vMGRBuildArchive;
    private boolean deleteAlsoSessionDirectory;
    private boolean genericCredentialForSessionDelete;
    private String archiveUser;
    private String archivePassword;
    private String famMode;
    private String famModeLocation;
    private boolean noAppendSeed;
    private final String executionType;
    private String sessionsInputFile;
    private boolean deleteSessionInputFile;
    private boolean pauseSessionOnBuildInterruption;
    private String executionScript;
    private String executionShellLocation;
    private String executionVsifFile;
    private String defineVaribleFile;
    private boolean defineVarible;
    private String defineVariableType;
    private String defineVariableText;

    @DataBoundConstructor
    public VMGRLaunchStep(String vAPIUrl, String vAPIUser, String vAPIPassword, String executionType, boolean vMGRBuildArchive, String vSIFName, String vSIFInputFile) {
        this.vAPIUrl = vAPIUrl;
        this.vAPIUser = vAPIUser;
        this.vAPIPassword = vAPIPassword;
        this.executionType = executionType;
        this.vMGRBuildArchive = vMGRBuildArchive;
        this.vSIFName = vSIFName;
        this.vSIFInputFile = vSIFInputFile;
    }

    @Deprecated
    public VMGRLaunchStep(String vAPIUrl, String vAPIUser, String vAPIPassword, String vSIFName, String vSIFInputFile, String credentialInputFile, boolean deleteInputFile, boolean deleteCredentialInputFile, boolean useUserOnFarm, boolean authRequired, String vsifType, String userFarmType, boolean dynamicUserId, boolean advConfig, int connTimeout, int readTimeout, boolean envVarible, String envVaribleFile, String inaccessibleResolver, String stoppedResolver, String failedResolver, String doneResolver, String suspendedResolver, boolean waitTillSessionEnds, int stepSessionTimeout, boolean generateJUnitXML, boolean extraAttributesForFailures, String staticAttributeList, boolean markBuildAsFailedIfAllRunFailed, boolean failJobIfAllRunFailed, String envSourceInputFile, boolean vMGRBuildArchive, boolean deleteAlsoSessionDirectory, boolean genericCredentialForSessionDelete, String archiveUser, String archivePassword, String famMode, String famModeLocation, boolean noAppendSeed, boolean pipelineNodes, String masterWorkspaceLocation, boolean markBuildAsPassedIfAllRunPassed, boolean failJobUnlessAllRunPassed, boolean userPrivateSSHKey, boolean attrValues, String attrValuesFile, String executionType, String sessionsInputFile, boolean deleteSessionInputFile, boolean pauseSessionOnBuildInterruption, String envSourceInputFileType, String executionScript, String executionShellLocation, String executionVsifFile, String defineVaribleFile, boolean defineVarible, String defineVariableType, String defineVariableText) {
        this.vAPIUrl = vAPIUrl;
        this.vAPIUser = vAPIUser;
        this.vAPIPassword = vAPIPassword;
        this.vSIFName = vSIFName;
        this.vSIFInputFile = vSIFInputFile;
        this.credentialInputFile = credentialInputFile;
        this.authRequired = authRequired;
        this.advConfig = advConfig;
        this.envVarible = envVarible;
        this.attrValues = attrValues;
        this.deleteInputFile = deleteInputFile;
        this.deleteCredentialInputFile = deleteCredentialInputFile;
        this.useUserOnFarm = useUserOnFarm;
        this.vsifType = vsifType;
        this.userFarmType = userFarmType;
        this.dynamicUserId = dynamicUserId;
        this.envVaribleFile = envVaribleFile;
        this.attrValuesFile = attrValuesFile;
        this.pipelineNodes = pipelineNodes;
        this.masterWorkspaceLocation = masterWorkspaceLocation;
        this.envSourceInputFile = envSourceInputFile;
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.envSourceInputFileType = envSourceInputFileType;
        this.inaccessibleResolver = inaccessibleResolver;
        this.stoppedResolver = stoppedResolver;
        this.failedResolver = failedResolver;
        this.doneResolver = doneResolver;
        this.suspendedResolver = suspendedResolver;
        this.waitTillSessionEnds = waitTillSessionEnds;
        this.stepSessionTimeout = stepSessionTimeout;
        this.generateJUnitXML = generateJUnitXML;
        this.extraAttributesForFailures = extraAttributesForFailures;
        this.markBuildAsFailedIfAllRunFailed = markBuildAsFailedIfAllRunFailed;
        this.failJobIfAllRunFailed = failJobIfAllRunFailed;
        this.markBuildAsPassedIfAllRunPassed = markBuildAsPassedIfAllRunPassed;
        this.failJobUnlessAllRunPassed = failJobUnlessAllRunPassed;
        this.userPrivateSSHKey = userPrivateSSHKey;
        this.staticAttributeList = staticAttributeList;
        this.vMGRBuildArchive = vMGRBuildArchive;
        this.deleteAlsoSessionDirectory = deleteAlsoSessionDirectory;
        this.genericCredentialForSessionDelete = genericCredentialForSessionDelete;
        this.archiveUser = archiveUser;
        this.archivePassword = archivePassword;
        this.famMode = famMode;
        this.famModeLocation = famModeLocation;
        this.noAppendSeed = noAppendSeed;
        this.executionType = executionType;
        this.sessionsInputFile = sessionsInputFile;
        this.deleteSessionInputFile = deleteSessionInputFile;
        this.pauseSessionOnBuildInterruption = pauseSessionOnBuildInterruption;
        this.executionScript = executionScript;
        this.executionShellLocation = executionShellLocation;
        this.executionVsifFile = executionVsifFile;
        this.defineVaribleFile = defineVaribleFile;
        this.defineVarible = defineVarible;
        this.defineVariableType = defineVariableType;
        this.defineVariableText = defineVariableText;
    }

    @DataBoundSetter
    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    @DataBoundSetter
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @DataBoundSetter
    public void setStepSessionTimeout(int stepSessionTimeout) {
        this.stepSessionTimeout = stepSessionTimeout;
    }

    @DataBoundSetter
    public void setVsifType(@CheckForNull String vsifType) {
        this.vsifType = Util.fixEmpty((String)vsifType);
    }

    @DataBoundSetter
    public void setDefineVariableType(@CheckForNull String defineVariableType) {
        this.defineVariableType = Util.fixEmpty((String)defineVariableType);
    }

    @DataBoundSetter
    public void setUserFarmType(@CheckForNull String userFarmType) {
        this.userFarmType = Util.fixEmpty((String)userFarmType);
    }

    @DataBoundSetter
    public void setFamMode(@CheckForNull String famMode) {
        this.famMode = Util.fixEmpty((String)famMode);
    }

    @DataBoundSetter
    public void setMasterWorkspaceLocation(@CheckForNull String masterWorkspaceLocation) {
        this.masterWorkspaceLocation = Util.fixEmpty((String)masterWorkspaceLocation);
    }

    @DataBoundSetter
    public void setDefineVariableText(@CheckForNull String defineVariableText) {
        this.defineVariableText = Util.fixEmpty((String)defineVariableText);
    }

    @DataBoundSetter
    public void setDeleteAlsoSessionDirectory(boolean deleteAlsoSessionDirectory) {
        this.deleteAlsoSessionDirectory = deleteAlsoSessionDirectory;
    }

    @DataBoundSetter
    public void setDeleteInputFile(boolean deleteInputFile) {
        this.deleteInputFile = deleteInputFile;
    }

    @DataBoundSetter
    public void setDeleteCredentialInputFile(boolean deleteCredentialInputFile) {
        this.deleteCredentialInputFile = deleteCredentialInputFile;
    }

    @DataBoundSetter
    public void setUseUserOnFarm(boolean useUserOnFarm) {
        this.useUserOnFarm = useUserOnFarm;
    }

    @DataBoundSetter
    public void setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
    }

    @DataBoundSetter
    public void setDynamicUserId(boolean dynamicUserId) {
        this.dynamicUserId = dynamicUserId;
    }

    @DataBoundSetter
    public void setAdvConfig(boolean advConfig) {
        this.advConfig = advConfig;
    }

    @DataBoundSetter
    public void setDefineVarible(boolean defineVarible) {
        this.defineVarible = defineVarible;
    }

    @DataBoundSetter
    public void setExecutionScript(@CheckForNull String executionScript) {
        this.executionScript = Util.fixEmpty((String)executionScript);
    }

    @DataBoundSetter
    public void setDefineVaribleFile(@CheckForNull String defineVaribleFile) {
        this.defineVaribleFile = Util.fixEmpty((String)defineVaribleFile);
    }

    @DataBoundSetter
    public void setExecutionShellLocation(@CheckForNull String executionShellLocation) {
        this.executionShellLocation = Util.fixEmpty((String)executionShellLocation);
    }

    @DataBoundSetter
    public void setExecutionVsifFile(@CheckForNull String executionVsifFile) {
        this.executionVsifFile = Util.fixEmpty((String)executionVsifFile);
    }

    @DataBoundSetter
    public void setMarkBuildAsFailedIfAllRunFailed(boolean markBuildAsFailedIfAllRunFailed) {
        this.markBuildAsFailedIfAllRunFailed = markBuildAsFailedIfAllRunFailed;
    }

    @DataBoundSetter
    public void setFailJobIfAllRunFailed(boolean failJobIfAllRunFailed) {
        this.failJobIfAllRunFailed = failJobIfAllRunFailed;
    }

    @DataBoundSetter
    public void setGenericCredentialForSessionDelete(boolean genericCredentialForSessionDelete) {
        this.genericCredentialForSessionDelete = genericCredentialForSessionDelete;
    }

    @DataBoundSetter
    public void setnoAppendSeed(boolean noAppendSeed) {
        this.noAppendSeed = noAppendSeed;
    }

    @DataBoundSetter
    public void setPipelineNodes(boolean pipelineNodes) {
        this.pipelineNodes = pipelineNodes;
    }

    @DataBoundSetter
    public void setMarkBuildAsPassedIfAllRunPassed(boolean markBuildAsPassedIfAllRunPassed) {
        this.markBuildAsPassedIfAllRunPassed = markBuildAsPassedIfAllRunPassed;
    }

    @DataBoundSetter
    public void setFailJobUnlessAllRunPassed(boolean failJobUnlessAllRunPassed) {
        this.failJobUnlessAllRunPassed = failJobUnlessAllRunPassed;
    }

    @DataBoundSetter
    public void setUserPrivateSSHKey(boolean userPrivateSSHKey) {
        this.userPrivateSSHKey = userPrivateSSHKey;
    }

    @DataBoundSetter
    public void setAttrValues(boolean attrValues) {
        this.attrValues = attrValues;
    }

    @DataBoundSetter
    public void setEnvVarible(boolean envVarible) {
        this.envVarible = envVarible;
    }

    @DataBoundSetter
    public void setWaitTillSessionEnds(boolean waitTillSessionEnds) {
        this.waitTillSessionEnds = waitTillSessionEnds;
    }

    @DataBoundSetter
    public void setGenerateJUnitXML(boolean generateJUnitXML) {
        this.generateJUnitXML = generateJUnitXML;
    }

    @DataBoundSetter
    public void setDeleteSessionInputFile(boolean deleteSessionInputFile) {
        this.deleteSessionInputFile = deleteSessionInputFile;
    }

    @DataBoundSetter
    public void setPauseSessionOnBuildInterruption(boolean pauseSessionOnBuildInterruption) {
        this.pauseSessionOnBuildInterruption = pauseSessionOnBuildInterruption;
    }

    @DataBoundSetter
    public void setExtraAttributesForFailures(boolean extraAttributesForFailures) {
        this.extraAttributesForFailures = extraAttributesForFailures;
    }

    @DataBoundSetter
    public void setCredentialInputFile(@CheckForNull String credentialInputFile) {
        this.credentialInputFile = Util.fixEmpty((String)credentialInputFile);
    }

    @DataBoundSetter
    public void setEnvVaribleFile(@CheckForNull String envVaribleFile) {
        this.envVaribleFile = Util.fixEmpty((String)envVaribleFile);
    }

    @DataBoundSetter
    public void setStaticAttributeList(@CheckForNull String staticAttributeList) {
        this.staticAttributeList = Util.fixEmpty((String)staticAttributeList);
    }

    @DataBoundSetter
    public void setAttrValuesFile(@CheckForNull String attrValuesFile) {
        this.attrValuesFile = Util.fixEmpty((String)attrValuesFile);
    }

    @DataBoundSetter
    public void setSessionsInputFile(@CheckForNull String sessionsInputFile) {
        this.sessionsInputFile = Util.fixEmpty((String)sessionsInputFile);
    }

    @DataBoundSetter
    public void setInaccessibleResolver(@CheckForNull String inaccessibleResolver) {
        this.inaccessibleResolver = Util.fixEmpty((String)inaccessibleResolver);
    }

    @DataBoundSetter
    public void setStoppedResolver(@CheckForNull String stoppedResolver) {
        this.stoppedResolver = Util.fixEmpty((String)stoppedResolver);
    }

    @DataBoundSetter
    public void setFailedResolver(@CheckForNull String failedResolver) {
        this.failedResolver = Util.fixEmpty((String)failedResolver);
    }

    @DataBoundSetter
    public void setDoneResolver(@CheckForNull String doneResolver) {
        this.doneResolver = Util.fixEmpty((String)doneResolver);
    }

    @DataBoundSetter
    public void setSuspendedResolver(@CheckForNull String suspendedResolver) {
        this.suspendedResolver = Util.fixEmpty((String)suspendedResolver);
    }

    @DataBoundSetter
    public void setEnvSourceInputFileType(@CheckForNull String envSourceInputFileType) {
        this.envSourceInputFileType = Util.fixEmpty((String)envSourceInputFileType);
    }

    @DataBoundSetter
    public void setEnvSourceInputFile(@CheckForNull String envSourceInputFile) {
        this.envSourceInputFile = Util.fixEmpty((String)envSourceInputFile);
    }

    @DataBoundSetter
    public void setArchiveUser(@CheckForNull String archiveUser) {
        this.archiveUser = Util.fixEmpty((String)archiveUser);
    }

    @DataBoundSetter
    public void setArchivePassword(@CheckForNull String archivePassword) {
        this.archivePassword = Util.fixEmpty((String)archivePassword);
    }

    @DataBoundSetter
    public void setFamModeLocation(@CheckForNull String famModeLocation) {
        this.famModeLocation = Util.fixEmpty((String)famModeLocation);
    }

    public String getExecutionScript() {
        return this.executionScript;
    }

    public String getExecutionShellLocation() {
        return this.executionShellLocation;
    }

    public String getExecutionVsifFile() {
        return this.executionVsifFile;
    }

    public String getSessionsInputFile() {
        return this.sessionsInputFile;
    }

    public boolean isDeleteSessionInputFile() {
        return this.deleteSessionInputFile;
    }

    public String getExecutionType() {
        return this.executionType;
    }

    public boolean isExtraAttributesForFailures() {
        return this.extraAttributesForFailures;
    }

    public boolean isNoAppendSeed() {
        return this.noAppendSeed;
    }

    public boolean isPauseSessionOnBuildInterruption() {
        return this.pauseSessionOnBuildInterruption;
    }

    public boolean isMarkBuildAsFailedIfAllRunFailed() {
        return this.markBuildAsFailedIfAllRunFailed;
    }

    public boolean isFailJobIfAllRunFailed() {
        return this.failJobIfAllRunFailed;
    }

    public boolean isMarkBuildAsPassedIfAllRunPassed() {
        return this.markBuildAsPassedIfAllRunPassed;
    }

    public boolean isFailJobUnlessAllRunPassed() {
        return this.failJobUnlessAllRunPassed;
    }

    public boolean isUserPrivateSSHKey() {
        return this.userPrivateSSHKey;
    }

    public String getStaticAttributeList() {
        return this.staticAttributeList;
    }

    public boolean isGenerateJUnitXML() {
        return this.generateJUnitXML;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public String getVAPIPassword() {
        return this.vAPIPassword;
    }

    public String getVSIFName() {
        return this.vSIFName;
    }

    public String getEnvVaribleFile() {
        return this.envVaribleFile;
    }

    public String getAttrValuesFile() {
        return this.attrValuesFile;
    }

    public String getMasterWorkspaceLocation() {
        return this.masterWorkspaceLocation;
    }

    public String getEnvSourceInputFile() {
        return this.envSourceInputFile;
    }

    public String getVSIFInputFile() {
        return this.vSIFInputFile;
    }

    public String getCredentialInputFile() {
        return this.credentialInputFile;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public boolean isDeleteCredentialInputFile() {
        return this.deleteCredentialInputFile;
    }

    public boolean isUseUserOnFarm() {
        return this.useUserOnFarm;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public String getVsifType() {
        return this.vsifType;
    }

    public String getUserFarmType() {
        return this.userFarmType;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public boolean isEnvVarible() {
        return this.envVarible;
    }

    public boolean isAttrValues() {
        return this.attrValues;
    }

    public boolean isPipelineNodes() {
        return this.pipelineNodes;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getStepSessionTimeout() {
        return this.stepSessionTimeout;
    }

    public String getInaccessibleResolver() {
        return this.inaccessibleResolver;
    }

    public String getEnvSourceInputFileType() {
        return this.envSourceInputFileType;
    }

    public String getStoppedResolver() {
        return this.stoppedResolver;
    }

    public String getFailedResolver() {
        return this.failedResolver;
    }

    public String getDoneResolver() {
        return this.doneResolver;
    }

    public String getSuspendedResolver() {
        return this.suspendedResolver;
    }

    public boolean isWaitTillSessionEnds() {
        return this.waitTillSessionEnds;
    }

    public boolean isVMGRBuildArchive() {
        return this.vMGRBuildArchive;
    }

    public boolean isDeleteAlsoSessionDirectory() {
        return this.deleteAlsoSessionDirectory;
    }

    public boolean isGenericCredentialForSessionDelete() {
        return this.genericCredentialForSessionDelete;
    }

    public String getArchiveUser() {
        return this.archiveUser;
    }

    public String getArchivePassword() {
        return this.archivePassword;
    }

    public String getFamMode() {
        return this.famMode;
    }

    public String getFamModeLocation() {
        return this.famModeLocation;
    }

    public String getDefineVaribleFile() {
        return this.defineVaribleFile;
    }

    public boolean isDefineVarible() {
        return this.defineVarible;
    }

    public String getDefineVariableType() {
        return this.defineVariableType;
    }

    public String getDefineVariableText() {
        return this.defineVariableText;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new VMGRLaunchStepImpl(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getFunctionName() {
            return "vmanagerLaunch";
        }

        @Nonnull
        public String getDisplayName() {
            return "Cadence vManager Session Launcher";
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Verisium Manager vAPI HOST ");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckStaticAttributeList(@QueryParameter String value) throws IOException, ServletException {
            if (value != null) {
                if (value.indexOf(";") > 0) {
                    return FormValidation.error((String)"(;) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (value.indexOf("|") > 0) {
                    return FormValidation.error((String)"(|) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (value.indexOf(".") > 0) {
                    return FormValidation.error((String)"(.) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                List<String> items = Arrays.asList(value.split("\\s*,\\s*"));
                Iterator<String> iter = items.iterator();
                String tmpAttr = null;
                while (iter.hasNext()) {
                    tmpAttr = iter.next();
                    if (tmpAttr.indexOf(" ") > 0) {
                        return FormValidation.error((String)("'" + tmpAttr + "' is not a valid option for Verisium Manager attribute code name. Attribute code names can't have space.  Try using underscore instaed."));
                    }
                    if (tmpAttr.equals("first_failure_name")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (tmpAttr.equals("first_failure_description")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (tmpAttr.equals("computed_seed")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (tmpAttr.equals("test_group")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (!tmpAttr.equals("test_name")) continue;
                    return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                }
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillInaccessibleResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Mark the build as failed", "fail");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Ignore, and continue to wait", "ignore");
            return items;
        }

        public ListBoxModel doFillEnvSourceInputFileTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("bash", "BSH");
            items.add("csh", "CSH");
            return items;
        }

        public ListBoxModel doFillStoppedResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Mark the build as failed", "fail");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Ignore, and continue to wait", "ignore");
            return items;
        }

        public ListBoxModel doFillFailedResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Mark the build as failed", "fail");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Ignore, and continue to wait", "ignore");
            return items;
        }

        public ListBoxModel doFillDoneResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Ignore, and continue to wait", "ignore");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Mark the build as failed", "fail");
            return items;
        }

        public ListBoxModel doFillSuspendedResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Ignore, and continue to wait", "ignore");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Mark the build as failed", "fail");
            return items;
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String vAPIUser, @QueryParameter(value="vAPIPassword") String vAPIPassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @QueryParameter(value="authRequired") boolean authRequired, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                Utils utils = new Utils();
                String output = utils.checkVAPIConnection(vAPIUrl, authRequired, vAPIUser, vAPIPassword);
                if (!output.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + output));
                }
                return FormValidation.error((String)output);
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        @POST
        public FormValidation doTestArchiveUser(@QueryParameter(value="archiveUser") String archiveUser, @QueryParameter(value="archivePassword") String archivePassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                Utils utils = new Utils();
                String output = utils.checkVAPIConnection(vAPIUrl, true, archiveUser, archivePassword);
                if (!output.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + output));
                }
                return FormValidation.error((String)output);
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        @POST
        public FormValidation doTestExtraStaticAttr(@QueryParameter(value="vAPIUser") String vAPIUser, @QueryParameter(value="vAPIPassword") String vAPIPassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @QueryParameter(value="authRequired") boolean authRequired, @QueryParameter(value="staticAttributeList") String staticAttributeList, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                Utils utils = new Utils();
                String output = utils.checkExtraStaticAttr(vAPIUrl, authRequired, vAPIUser, vAPIPassword, staticAttributeList);
                if (!output.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + output));
                }
                return FormValidation.error((String)output);
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Run.class, Launcher.class, TaskListener.class, EnvVars.class);
        }
    }
}

