/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Executor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.plugins.vmanager.LaunchHolder;
import org.jenkinsci.plugins.vmanager.SessionNameIdHolder;
import org.jenkinsci.plugins.vmanager.StepHolder;
import org.jenkinsci.plugins.vmanager.VMGRBuildArchiver;

public class Utils {
    private String UserUsedForLogin = null;
    private String PasswordUsedForLogin = null;
    private FilePath filePath = null;
    private TaskListener jobListener = null;
    private Run build = null;

    public Utils(Run run, TaskListener listener) {
        Executor executor = run.getExecutor();
        if (executor != null) {
            this.filePath = executor.getCurrentWorkspace();
        }
        this.jobListener = listener;
        this.build = run;
    }

    public Utils(Run run, TaskListener listener, FilePath filePath) {
        this.filePath = filePath;
        this.jobListener = listener;
        this.build = run;
    }

    public Utils() {
    }

    public FilePath getFilePath() {
        return this.filePath;
    }

    public BufferedReader loadFileFromWorkSpace(String buildID, int buildNumber, String workPlacePath, String inputFile, TaskListener listener, boolean deleteInputFile, String fileTypeEndingName) throws Exception {
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        try {
            if ("".equals(inputFile) || inputFile == null) {
                fileName = buildNumber + "." + buildID + "." + fileTypeEndingName;
                if (notInTestMode) {
                    listener.getLogger().print("Loading input file '" + (String)fileName + "\n");
                }
                reader = this.readFileOnDisk((String)fileName);
            } else {
                fileName = inputFile;
                if (notInTestMode) {
                    listener.getLogger().print("Loading input file '" + (String)fileName + "\n");
                }
                reader = this.readFileOnDisk((String)fileName);
            }
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to open input file.  Failed to load file '" + (String)fileName + "'\n");
            } else {
                System.out.println("Failed to open the input file .  Failed to load file '" + fileName + "'");
            }
            throw e;
        }
        return reader;
    }

    public String[] loadDataFromInputFiles(String buildID, int buildNumber, String workPlacePath, String inputFile, TaskListener listener, boolean deleteInputFile, String type, String fileEnding) throws Exception {
        String[] output = null;
        LinkedList<String> listOfNames = new LinkedList<String>();
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        if (notInTestMode) {
            listener.getLogger().print("Looking for " + type + " input:\n");
        }
        fileName = "".equals(inputFile) || inputFile == null ? buildNumber + "." + buildID + "." + fileEnding : inputFile;
        try {
            reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, inputFile, listener, deleteInputFile, fileEnding);
            String line = null;
            while ((line = reader.readLine()) != null) {
                listOfNames.add(line);
            }
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to read input file for the " + type + " targets.  Failed to load file '" + (String)fileName + "'\n");
            } else {
                System.out.println("Failed to open the read file for the " + type + " targets.  Failed to load file '" + (String)fileName + "'");
            }
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Iterator iter = listOfNames.iterator();
        output = new String[listOfNames.size()];
        int i = 0;
        if (notInTestMode) {
            listener.getLogger().print("Found the following " + type + " files for Verisium Manager plugin:\n");
        }
        String theFileName = null;
        while (iter.hasNext()) {
            theFileName = (String)iter.next();
            output[i++] = theFileName;
            if (notInTestMode) {
                listener.getLogger().print(i + " '" + theFileName + "'\n");
                continue;
            }
            System.out.println(i + " '" + theFileName + "'");
        }
        if (deleteInputFile) {
            if (notInTestMode) {
                listener.getLogger().print("Job set to delete the input file.  Deleting " + (String)fileName + "\n");
            }
            try {
                File fileToDelete = new File((String)fileName);
                boolean renamed = fileToDelete.renameTo(new File(String.valueOf(fileToDelete) + ".delete"));
                if (!renamed) {
                    listener.getLogger().print("Failed to rename input file from workspace.  Failed to rename file '" + (String)fileName + "'\n");
                }
            }
            catch (Exception e) {
                if (notInTestMode) {
                    listener.getLogger().print("Failed to delete input file from workspace.  Failed to delete file '" + (String)fileName + "'\n");
                } else {
                    System.out.println("Failed to delete the input file from the workspace.  Failed to delete file '" + (String)fileName + "'");
                }
                throw e;
            }
        }
        return output;
    }

    public String loadUserSyntaxForSummaryReport(String buildID, int buildNumber, String workPlacePath, String inputFile, TaskListener listener, boolean deleteInputFile) throws Exception {
        String output = null;
        StringBuffer jsonInput = new StringBuffer();
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        fileName = "".equals(inputFile) || inputFile == null ? buildNumber + "." + buildID + ".summary_report.input" : inputFile;
        try {
            reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, inputFile, listener, deleteInputFile, "summary_report.input");
            String line = null;
            while ((line = reader.readLine()) != null) {
                jsonInput.append(line);
            }
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to read input file for the summary report.  Failed to load file '" + (String)fileName + "'\n");
            } else {
                System.out.println("Failed to read input file for the summary report.  Failed to load file '" + (String)fileName + "'");
            }
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (deleteInputFile) {
            if (notInTestMode) {
                listener.getLogger().print("Job set to delete the input file.  Deleting " + (String)fileName + "\n");
            }
            try {
                File fileToDelete = new File((String)fileName);
                boolean renamed = fileToDelete.renameTo(new File(String.valueOf(fileToDelete) + ".delete"));
                if (!renamed) {
                    listener.getLogger().print("Failed to rename input file from workspace.  Failed to rename file '" + (String)fileName + "'\n");
                }
            }
            catch (Exception e) {
                if (notInTestMode) {
                    listener.getLogger().print("Failed to rename input file from workspace.  Failed to rename file '" + (String)fileName + "'\n");
                } else {
                    System.out.println("Failed to delete the input file from the workspace.  Failed to delete file '" + (String)fileName + "'");
                }
                throw e;
            }
        }
        output = jsonInput.toString();
        return output;
    }

    public String[] loadFileCredentials(String buildID, int buildNumber, String workPlacePath, String credentialInputFile, TaskListener listener, boolean deleteInputFile) throws Exception {
        String[] output = null;
        LinkedList<String> listOfNames = new LinkedList<String>();
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        fileName = "".equals(credentialInputFile) || credentialInputFile == null ? buildNumber + "." + buildID + ".credential.input" : credentialInputFile;
        try {
            reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, credentialInputFile, listener, deleteInputFile, "credential.input");
            String line = null;
            while ((line = reader.readLine()) != null) {
                listOfNames.add(line);
            }
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to read input file for the credentials.  Failed to load file '" + (String)fileName + "'\n");
            } else {
                System.out.println("Failed to open the read file for the credentials.  Failed to load file '" + (String)fileName + "'");
            }
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Iterator iter = listOfNames.iterator();
        output = new String[listOfNames.size()];
        int i = 0;
        String stringValue = null;
        while (iter.hasNext()) {
            stringValue = (String)iter.next();
            output[i++] = stringValue;
        }
        if (deleteInputFile) {
            if (notInTestMode) {
                listener.getLogger().print("Job set to delete the credential file.  Deleting " + (String)fileName + "\n");
            }
            try {
                File fileToDelete = new File((String)fileName);
                boolean renamed = fileToDelete.delete();
                if (!renamed) {
                    listener.getLogger().print("Failed to delete input file from workspace.  Failed to delete file '" + (String)fileName + "'\n");
                }
            }
            catch (Exception e) {
                if (notInTestMode) {
                    listener.getLogger().print("Failed to delete input file from workspace.  Failed to delete file '" + (String)fileName + "'\n");
                } else {
                    System.out.println("Failed to delete the input file from the workspace.  Failed to delete file '" + (String)fileName + "'");
                }
                throw e;
            }
        }
        return output;
    }

    public String loadJSONEnvInput(String buildID, int buildNumber, String workPlacePath, String envInputFile, TaskListener listener) throws Exception {
        Object output = null;
        StringBuffer listOfEnvs = new StringBuffer();
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        fileName = "".equals(envInputFile) || envInputFile == null ? buildNumber + "." + buildID + ".environment.input" : envInputFile;
        try {
            reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, (String)fileName, listener, false, "environment.input");
            String line = null;
            while ((line = reader.readLine()) != null) {
                listOfEnvs.append(line);
            }
            output = listOfEnvs.toString();
            output = "\"environment\":{  " + (String)output + "}";
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to read input file for the environment varibles.  Failed to load file '" + (String)fileName + "'\n");
            } else {
                System.out.println("Failed to open the read file for the environment varibles.  Failed to load file '" + (String)fileName + "'");
            }
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return output;
    }

    public static String getRegressionURLFromVAPIURL(String vAPIUrl) {
        String output;
        try {
            String strWorker = vAPIUrl.substring(vAPIUrl.indexOf("https://") + 8, vAPIUrl.length());
            String hostAndPort = strWorker.substring(0, strWorker.indexOf("/"));
            strWorker = strWorker.substring(strWorker.indexOf("/") + 1, strWorker.length());
            String projectCode = strWorker.substring(0, strWorker.indexOf("/"));
            if (projectCode.indexOf(",") > 0) {
                projectCode = projectCode.substring(0, projectCode.indexOf(44));
            }
            output = "https://" + hostAndPort + "/web/" + projectCode + "/regression/index.html";
        }
        catch (Exception e) {
            return "#";
        }
        return output;
    }

    public String loadJSONAttrValuesInput(String buildID, int buildNumber, String workPlacePath, String attrValuesFile, TaskListener listener) throws Exception {
        Object output = null;
        StringBuffer listOfAttrValues = new StringBuffer();
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        fileName = "".equals(attrValuesFile) || attrValuesFile == null ? buildNumber + "." + buildID + ".attr.values.input" : attrValuesFile;
        try {
            reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, (String)fileName, listener, false, "attr.values.input");
            String line = null;
            boolean foundOneAttr = false;
            while ((line = reader.readLine()) != null) {
                Object tmpLineResult = "";
                StringTokenizer tokenizer = new StringTokenizer(line, ",");
                tmpLineResult = (String)tmpLineResult + "{\"name\":\"" + tokenizer.nextToken().trim() + "\",";
                tmpLineResult = (String)tmpLineResult + "\"value\":\"" + tokenizer.nextToken().trim() + "\",";
                tmpLineResult = (String)tmpLineResult + "\"type\":\"" + tokenizer.nextToken().trim() + "\"},";
                listOfAttrValues.append((String)tmpLineResult);
                foundOneAttr = true;
            }
            output = listOfAttrValues.toString();
            if (foundOneAttr) {
                output = ((String)output).substring(0, ((String)output).length() - 1);
            }
            output = "\"attributes\":[" + (String)output + "]";
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to read input file for the attribute values.  Failed to load file '" + (String)fileName + "'\n " + e.getMessage());
            } else {
                System.out.println("Failed to open the read file for the attribute values.  Failed to load file '" + (String)fileName + "'");
            }
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return output;
    }

    public String loadJSONDefineInput(String buildID, int buildNumber, String workPlacePath, String envInputFile, TaskListener listener) throws Exception {
        Object output = null;
        StringBuffer listOfDefineValues = new StringBuffer();
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        fileName = "".equals(envInputFile) || envInputFile == null ? buildNumber + "." + buildID + ".define.input" : envInputFile;
        try {
            reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, (String)fileName, listener, false, "define.input");
            String line = null;
            boolean foundOneAttr = false;
            while ((line = reader.readLine()) != null) {
                Object tmpLineResult = "";
                StringTokenizer tokenizer = new StringTokenizer(line, ",");
                tmpLineResult = (String)tmpLineResult + "{\"name\":\"" + tokenizer.nextToken().trim() + "\",";
                tmpLineResult = (String)tmpLineResult + "\"value\":\"=" + tokenizer.nextToken().trim() + "\"},";
                listOfDefineValues.append((String)tmpLineResult);
                foundOneAttr = true;
            }
            output = listOfDefineValues.toString();
            if (foundOneAttr) {
                output = ((String)output).substring(0, ((String)output).length() - 1);
            }
            output = "\"params\":[" + (String)output + "]";
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to read input file for the define values.  Failed to load file '" + (String)fileName + "'\n " + e.getMessage());
            } else {
                System.out.println("Failed to open the read file for the define values.  Failed to load file '" + (String)fileName + "'");
            }
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return output;
    }

    public String loadJSONAttrValuesFromTextArea(String buildID, int buildNumber, String workPlacePath, TaskListener listener, String textarea) throws Exception {
        Object output = null;
        StringBuffer listOfAttrValues = new StringBuffer();
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        try {
            Object line = null;
            boolean foundOneAttr = false;
            String[] lines = StringUtils.split((String)textarea, (String)System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                Object tmpLineResult = "";
                StringTokenizer tokenizer = new StringTokenizer(lines[i], ",");
                tmpLineResult = (String)tmpLineResult + "{\"name\":\"" + tokenizer.nextToken().trim() + "\",";
                tmpLineResult = (String)tmpLineResult + "\"value\":\"" + tokenizer.nextToken().trim() + "\",";
                tmpLineResult = (String)tmpLineResult + "\"type\":\"" + tokenizer.nextToken().trim() + "\"},";
                listOfAttrValues.append((String)tmpLineResult);
                foundOneAttr = true;
            }
            output = listOfAttrValues.toString();
            if (foundOneAttr) {
                output = ((String)output).substring(0, ((String)output).length() - 1);
            }
            output = "\"attributes\":[" + (String)output + "]";
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to parse attributes for vsif.\n " + e.getMessage());
            } else {
                System.out.println("Failed to parse attributes for vsif.\n ");
            }
            throw e;
        }
        return output;
    }

    public String loadJSONDefineValuesFromTextArea(String buildID, int buildNumber, String workPlacePath, TaskListener listener, String textarea) throws Exception {
        Object output = null;
        StringBuffer listOfAttrValues = new StringBuffer();
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        try {
            Object line = null;
            boolean foundOneAttr = false;
            String[] lines = StringUtils.split((String)textarea, (String)System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                Object tmpLineResult = "";
                StringTokenizer tokenizer = new StringTokenizer(lines[i], ",");
                tmpLineResult = (String)tmpLineResult + "{\"name\":\"" + tokenizer.nextToken().trim() + "\",";
                tmpLineResult = (String)tmpLineResult + "\"value\":\"=" + tokenizer.nextToken().trim() + "\"},";
                listOfAttrValues.append((String)tmpLineResult);
                foundOneAttr = true;
            }
            output = listOfAttrValues.toString();
            if (foundOneAttr) {
                output = ((String)output).substring(0, ((String)output).length() - 1);
            }
            output = "\"params\":[" + (String)output + "]";
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to parse define for vsif.\n " + e.getMessage());
            } else {
                System.out.println("Failed to parse define for vsif.\n ");
            }
            throw e;
        }
        return output;
    }

    public String loadJSONFromFile(String buildID, int buildNumber, String workPlacePath, String vInputFile, TaskListener listener, boolean deleteInputFile) throws Exception {
        String output = null;
        StringBuffer listOfNames = new StringBuffer();
        BufferedReader reader = null;
        Object fileName = null;
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        fileName = "".equals(vInputFile) || vInputFile == null ? buildNumber + "." + buildID + ".vapi.input" : vInputFile;
        try {
            reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, vInputFile, listener, deleteInputFile, "vapi.input");
            String line = null;
            while ((line = reader.readLine()) != null) {
                listOfNames.append(line);
            }
        }
        catch (Exception e) {
            if (notInTestMode) {
                listener.getLogger().print("Failed to read json input file for the vAPI input.  Failed to load file '" + (String)fileName + "'\n");
            } else {
                System.out.println("Failed to open the read file for the vAPI input.  Failed to load file '" + (String)fileName + "'");
            }
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        output = listOfNames.toString();
        if (notInTestMode) {
            listener.getLogger().print("Input jSON for vAPI is:\n");
            listener.getLogger().print(output + "\n");
        }
        if (deleteInputFile) {
            if (notInTestMode) {
                listener.getLogger().print("Job set to delete the input file.  Deleting " + (String)fileName + "\n");
            }
            try {
                File fileToDelete = new File((String)fileName);
                boolean renamed = fileToDelete.renameTo(new File(String.valueOf(fileToDelete) + ".delete"));
                if (!renamed) {
                    listener.getLogger().print("Failed to rename input file from workspace.  Failed to rename file '" + (String)fileName + "'\n");
                }
            }
            catch (Exception e) {
                if (notInTestMode) {
                    listener.getLogger().print("Failed to rename input file from workspace.  Failed to rename file '" + (String)fileName + "'\n");
                } else {
                    System.out.println("Failed to delete the input file from the workspace.  Failed to delete file '" + (String)fileName + "'");
                }
                throw e;
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkVAPIConnection(String url, boolean requireAuth, String user, String password) throws Exception {
        String textOut = null;
        HttpURLConnection conn = null;
        OutputStream os = null;
        BufferedReader br = null;
        try {
            String output;
            System.out.println("Trying to connect with Verisium Manager vAPI " + url);
            String input = "{}";
            String apiURL = url + "/rest/sessions/count";
            conn = this.getVAPIConnection(apiURL, requireAuth, user, password, "POST", false, "", 0, null, null, 0, 0, false);
            os = null;
            try {
                os = conn.getOutputStream();
            }
            catch (UnknownHostException e) {
                throw new Exception("Failed to connect to host " + e.getMessage() + ".  Host is unknown.");
            }
            os.write(input.getBytes(Charset.forName("UTF-8")));
            os.flush();
            if (conn.getResponseCode() != 200) {
                String errorMessage;
                String reason = "";
                if (conn.getResponseCode() == 503) {
                    reason = "vAPI process failed to connect to remote Verisium Manager server.";
                }
                if (conn.getResponseCode() == 401) {
                    reason = "Authentication Error";
                }
                if (conn.getResponseCode() == 412) {
                    reason = "vAPI requires Verisium Manager 'Integration Server' license.";
                }
                String string = errorMessage = this.processErrorFromRespone(conn, null, false);
                return string;
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }
            JSONObject tmp = JSONObject.fromObject((Object)result.toString());
            textOut = " The current number of sessions held on this Verisium Manager server are: " + tmp.getString("count");
        }
        catch (Exception e) {
            String errorMessage = "Failed : HTTP error: " + e.getMessage();
            if (e.getMessage().indexOf("Unexpected end of file from server") > -1) {
                errorMessage = errorMessage + " (from Incisive 14.2 onward the connection is secured.  Verify your url is https://)";
            }
            System.out.println(errorMessage);
            textOut = errorMessage;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (os != null) {
                os.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return textOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkExtraStaticAttr(String url, boolean requireAuth, String user, String password, String listOfAttr) throws Exception {
        String textOut = null;
        BufferedReader br = null;
        HttpURLConnection conn = null;
        try {
            String output;
            List<String> items = Arrays.asList(listOfAttr.split("\\s*,\\s*"));
            String apiURL = url + "/rest/$schema/response?action=list&component=runs&extended=true";
            conn = this.getVAPIConnection(apiURL, requireAuth, user, password, "GET", false, "", 0, null, null, 0, 0, false);
            if (conn.getResponseCode() != 200) {
                String errorMessage;
                String reason = "";
                if (conn.getResponseCode() == 503) {
                    reason = "vAPI process failed to connect to remote Verisium Manager server.";
                }
                if (conn.getResponseCode() == 401) {
                    reason = "Authentication Error";
                }
                String string = errorMessage = this.processErrorFromRespone(conn, null, false);
                return string;
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }
            JSONObject tmp = JSONObject.fromObject((Object)result.toString());
            JSONObject responseItems = JSONObject.fromObject((Object)tmp.getString("items"));
            JSONObject properties = JSONObject.fromObject((Object)responseItems.getString("properties"));
            Iterator<String> iter = items.iterator();
            String attr = null;
            JSONObject attrObject = null;
            Object attrOutputString = "";
            int i = 1;
            boolean isSuccess = true;
            while (iter.hasNext()) {
                attr = iter.next();
                if (properties.has(attr)) {
                    attrObject = JSONObject.fromObject((Object)properties.getString(attr));
                    String attrTitle = attrObject.getString("title");
                    attrOutputString = (String)attrOutputString + "(" + i + ") " + attr + " (" + attrTitle + ")\n";
                    ++i;
                    continue;
                }
                isSuccess = false;
                textOut = "Failed : '" + attr + "' doesn't exist for runs entities in the Verisium Manager server you are pointing at.\n";
                break;
            }
            if (isSuccess) {
                textOut = " All attributes were found on server:\n" + (String)attrOutputString;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = "Failed : HTTP error: " + e.getMessage();
            if (e.getMessage().indexOf("Unexpected end of file from server") > -1) {
                errorMessage = errorMessage + " (from Incisive 14.2 onward the connection is secured.  Verify your url is https://)";
            }
            System.out.println(errorMessage);
            textOut = errorMessage;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return textOut;
    }

    public HttpURLConnection getVAPIConnection(String apiUrl, boolean requireAuth, String user, String password, String requestMethod, boolean dynamicUserId, String buildID, int buildNumber, String workPlacePath, TaskListener listener, int connConnTimeOut, int connReadTimeout, boolean advConfig) throws Exception {
        boolean notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        URL url = new URL(apiUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (apiUrl.indexOf("https://") > -1) {
            Utils.configureAllowAll((HttpsURLConnection)conn);
        }
        conn.setDoOutput(true);
        conn.setRequestMethod(requestMethod);
        if ("PUT".equals(requestMethod) || "POST".equals(requestMethod)) {
            conn.setRequestProperty("Content-Type", "application/json");
        }
        if (advConfig) {
            conn.setConnectTimeout(connConnTimeOut * 60 * 1000);
        } else {
            conn.setConnectTimeout(60000);
        }
        if (advConfig) {
            conn.setReadTimeout(connReadTimeout * 60 * 1000);
        } else {
            conn.setReadTimeout(1800000);
        }
        if (requireAuth) {
            if (dynamicUserId) {
                try (BufferedReader reader = null;){
                    reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, null, listener, false, "user.input");
                    String line = null;
                    line = reader.readLine();
                    if (line != null) {
                        user = line;
                    }
                }
            }
            String authString = user + ":" + password;
            this.UserUsedForLogin = user;
            this.PasswordUsedForLogin = password;
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes(Charset.forName("UTF-8")));
            String authStringEnc = new String(authEncBytes, Charset.forName("UTF-8"));
            conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String executeVSIFLaunch(String[] vsifs, String url, boolean requireAuth, String user, String password, TaskListener listener, boolean dynamicUserId, String buildID, int buildNumber, String workPlacePath, int connConnTimeOut, int connReadTimeout, boolean advConfig, String jsonEnvInput, boolean useUserOnFarm, String userFarmType, String[] farmUserPassword, StepHolder stepHolder, String envSourceInputFile, String workingJobDir, VMGRBuildArchiver vMGRBuildArchiver, boolean userPrivateSSHKey, String jsonAttrValuesInput, String executionType, String[] sessionNames, String envSourceInputFileType, Launcher launcher, String jsonDefineInput) throws Exception {
        notInTestMode = true;
        if (listener == null) {
            notInTestMode = false;
        }
        apiURL = url + "/rest/sessions/launch";
        listOfSessions = new ArrayList<String>();
        if ("batch".equals(executionType)) {
            sessionNameIdHolder = new SessionNameIdHolder();
            listOfSessions = sessionNameIdHolder.getSessionNames(sessionNames, url, requireAuth, user, password, listener, dynamicUserId, buildID, buildNumber, workPlacePath, connConnTimeOut, connReadTimeout, advConfig, this);
            if (listOfSessions.size() == 0) {
                listener.getLogger().print("Couldn't find any data for the given project and the supplied session names.\n");
                return "Please check the input file that lists the session names and make sure you have the full session names as listed in Verisium Manager.";
            }
        } else {
            for (i = 0; i < vsifs.length; ++i) {
                if (notInTestMode) {
                    listener.getLogger().print("Verisium Manager vAPI - Trying to launch vsif file: '" + vsifs[i] + "'\n");
                }
                input = "{\"vsif\":\"" + vsifs[i] + "\"";
                if (jsonEnvInput != null) {
                    input = input + "," + jsonEnvInput;
                }
                if (jsonAttrValuesInput != null) {
                    input = input + "," + jsonAttrValuesInput;
                }
                if (jsonDefineInput != null) {
                    input = input + "," + jsonDefineInput;
                }
                if (useUserOnFarm) {
                    userFarm = null;
                    passwordFarm = null;
                    if ("static".equals(userFarmType)) {
                        userFarm = user;
                        passwordFarm = password;
                        if (dynamicUserId) {
                            reader = null;
                            try {
                                reader = this.loadFileFromWorkSpace(buildID, buildNumber, workPlacePath, null, listener, false, "user.input");
                                line = null;
                                line = reader.readLine();
                                if (line == null) ** GOTO lbl52
                                userFarm = line;
                            }
                            catch (Exception e) {
                                if (notInTestMode) {
                                    listener.getLogger().print("Failed to read input file for the dynamic users. \n");
                                } else {
                                    System.out.println("Failed to read input file for the dynamic users. \n");
                                }
                                throw e;
                            }
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                        }
                    } else if (!userPrivateSSHKey) {
                        userFarm = farmUserPassword[0];
                        passwordFarm = farmUserPassword[1];
                    }
lbl52:
                    // 6 sources

                    input = userPrivateSSHKey == false ? input + ",\"credentials\":{\"username\":\"" + userFarm + "\",\"password\":\"" + passwordFarm + "\"}" : input + ",\"credentials\":{\"connectType\":\"PUBLIC_KEY\"}";
                    if (envSourceInputFile != null && !"".equals(envSourceInputFile.trim())) {
                        scriptShell = envSourceInputFileType;
                        input = input + ",\"preliminaryStage\":{\"sourceFilePath\":\"" + envSourceInputFile + "\",\"shell\":\"" + scriptShell + "\"}";
                    }
                }
                input = input + "}";
                conn = null;
                os = null;
                br = null;
                try {
                    conn = this.getVAPIConnection(apiURL, requireAuth, user, password, "POST", dynamicUserId, buildID, buildNumber, workPlacePath, listener, connConnTimeOut, connReadTimeout, advConfig);
                    os = conn.getOutputStream();
                    os.write(input.getBytes(Charset.forName("UTF-8")));
                    os.flush();
                    if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205) {
                        reason = "";
                        if (conn.getResponseCode() == 503) {
                            reason = "vAPI process failed to connect to remote Verisium Manager server.";
                        }
                        if (conn.getResponseCode() == 401) {
                            reason = "Authentication Error";
                        }
                        if (conn.getResponseCode() == 412) {
                            reason = "vAPI requires Verisium Manager 'Integration Server' license.";
                        }
                        if (conn.getResponseCode() == 406) {
                            reason = "VSIF file '" + vsifs[i] + "' was not found on file system, or is not accessed by the vAPI process.\n";
                        }
                        var39_43 = errorMessage = this.processErrorFromRespone(conn, listener, notInTestMode);
                        return var39_43;
                    }
                    br = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
                    result = new StringBuilder();
                    while ((output = br.readLine()) != null) {
                        result.append(output);
                    }
                    tmp = JSONObject.fromObject((Object)result.toString());
                    textOut = "Session Launch Success: Session ID: " + tmp.getString("value") + "\n";
                    listOfSessions.add(tmp.getString("value"));
                    if (notInTestMode) {
                        listener.getLogger().print(textOut);
                        continue;
                    }
                    System.out.println(textOut);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
            }
        }
        if (vMGRBuildArchiver != null && vMGRBuildArchiver.isVMGRBuildArchive()) {
            vMGRBuildArchiver.markBuildForArchive(listOfSessions, apiURL, requireAuth, this.UserUsedForLogin, this.PasswordUsedForLogin, workingJobDir, listener, launcher, this);
        }
        fileOutput = buildNumber + "." + buildID + ".session_launch.output";
        if (this.filePath == null) {
            fileOutput = workPlacePath + File.separator + fileOutput;
        }
        writer = new StringBuffer();
        iter = listOfSessions.iterator();
        while (iter.hasNext()) {
            writer.append((String)iter.next() + "\n");
        }
        this.saveFileOnDisk(fileOutput, writer.toString());
        if (stepHolder != null) {
            this.waitTillSessionEnds(url, requireAuth, user, password, listener, dynamicUserId, buildID, buildNumber, workPlacePath, connConnTimeOut, connReadTimeout, advConfig, stepHolder, listOfSessions, notInTestMode, workingJobDir, launcher);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeAPI(String jSON, String apiUrl, String url, boolean requireAuth, String user, String password, String requestMethod, TaskListener listener, boolean dynamicUserId, String buildID, int buildNumber, String workPlacePath, int connConnTimeOut, int connReadTimeout, boolean advConfig) throws Exception {
        HttpURLConnection conn = null;
        BufferedReader br = null;
        OutputStream os = null;
        try {
            String output;
            boolean notInTestMode = true;
            if (listener == null) {
                notInTestMode = false;
            }
            String apiURL = url + "/rest" + apiUrl;
            if (notInTestMode) {
                listener.getLogger().print("Verisium Manager vAPI - Trying to call vAPI '/rest" + apiUrl + "'\n");
            }
            String input = jSON;
            conn = this.getVAPIConnection(apiURL, requireAuth, user, password, requestMethod, dynamicUserId, buildID, buildNumber, workPlacePath, listener, connConnTimeOut, connReadTimeout, advConfig);
            if ("PUT".equals(requestMethod) || "POST".equals(requestMethod)) {
                os = conn.getOutputStream();
                os.write(input.getBytes(Charset.forName("UTF-8")));
                os.flush();
            }
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205) {
                String reason = "";
                if (conn.getResponseCode() == 503) {
                    reason = "vAPI process failed to connect to remote Verisium Manager server.";
                }
                if (conn.getResponseCode() == 401) {
                    reason = "Authentication Error";
                }
                if (conn.getResponseCode() == 415) {
                    reason = "The server is refusing to service the request because the entity of the request is in a format not supported by the requested resource for the requested method.  Check if you selected the right request method (GET/POST/DELETE/PUT).";
                }
                if (conn.getResponseCode() == 405) {
                    reason = "The method specified in the Request-Line is not allowed for the resource identified by the Request-URI. The response MUST include an Allow header containing a list of valid methods for the requested resource.  Check if you selected the right request method (GET/POST/DELETE/PUT).";
                }
                if (conn.getResponseCode() == 412) {
                    reason = "vAPI requires Verisium Manager 'Integration Server' license.";
                }
                String errorMessage = this.processErrorFromRespone(conn, listener, notInTestMode);
                if (notInTestMode) {
                    listener.getLogger().print(errorMessage);
                } else {
                    System.out.println(errorMessage);
                }
                String string = errorMessage;
                return string;
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }
            String fileOutput = buildNumber + "." + buildID + ".vapi.output";
            if (this.filePath == null) {
                fileOutput = workPlacePath + File.separator + fileOutput;
            }
            this.saveFileOnDisk(fileOutput, result.toString());
            String textOut = "API Call Success: Output was saved into: " + fileOutput + "\n";
            if (notInTestMode) {
                listener.getLogger().print(textOut);
            } else {
                System.out.println(textOut);
            }
            String string = "success";
            return string;
        }
        catch (Exception e) {
            listener.getLogger().print("Filed: Error: " + e.getMessage());
            String string = e.getMessage();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (os != null) {
                os.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public void waitTillSessionEnds(String url, boolean requireAuth, String user, String password, TaskListener listener, boolean dynamicUserId, String buildID, int buildNumber, String workPlacePath, int connConnTimeOut, int connReadTimeout, boolean advConfig, StepHolder stepHolder, List listOfSessions, boolean notInTestMode, String workingJobDir, Launcher launcher) throws Exception {
        LaunchHolder launchHolder = new LaunchHolder(stepHolder, listOfSessions, this);
        launchHolder.performWaiting(url, requireAuth, user, password, listener, dynamicUserId, buildID, buildNumber, workPlacePath, connConnTimeOut, connReadTimeout, advConfig, notInTestMode, workingJobDir, launcher);
    }

    public static void configureAllowAll(HttpsURLConnection connection) {
        connection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        try {
            connection.setSSLSocketFactory(Utils.getSocketFactory());
        }
        catch (Exception e) {
            throw new RuntimeException("XTrust Failed to set SSL Socket factory", e);
        }
    }

    private static SSLSocketFactory getSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{tm}, null);
        return sslContext.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processErrorFromRespone(HttpURLConnection conn, TaskListener listener, boolean notInTestMode) throws IOException {
        Object errorMessage = "";
        StringBuilder resultFromError = null;
        int responseCode = 0;
        BufferedReader br = null;
        try {
            String output;
            resultFromError = new StringBuilder(conn.getResponseMessage());
            responseCode = conn.getResponseCode();
            br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.forName("UTF-8")));
            while ((output = br.readLine()) != null) {
                resultFromError.append(output);
            }
        }
        catch (Exception exception) {}
        finally {
            if (br != null) {
                br.close();
            }
            errorMessage = "Failed : HTTP error code : " + responseCode + " (" + String.valueOf(resultFromError) + ")\n";
            if (notInTestMode) {
                listener.getLogger().print((String)errorMessage);
            } else {
                System.out.println((String)errorMessage);
            }
            return errorMessage;
        }
    }

    public void saveFileOnDisk(String fileOnDiskPath, String output) throws IOException {
        if (this.filePath != null) {
            try {
                FilePath newFile = this.filePath.child(fileOnDiskPath);
                newFile.write(output, StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.standardWriteToDisk(fileOnDiskPath, output);
            }
        } else {
            this.standardWriteToDisk(fileOnDiskPath, output);
        }
    }

    public OutputStream getRemoteDiskOutoutStream(String fileOnDiskPath) throws Exception {
        FilePath newFile = this.filePath.child(fileOnDiskPath);
        return newFile.write();
    }

    public BufferedReader readFileOnDisk(String fileOnDiskPath) throws IOException {
        if (this.filePath != null) {
            try {
                FilePath newFile = this.filePath.child(fileOnDiskPath);
                return new BufferedReader(new InputStreamReader(newFile.read(), StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.standardReadFromDisk(fileOnDiskPath);
            }
        }
        return this.standardReadFromDisk(fileOnDiskPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void standardWriteToDisk(String fileOnDiskPath, String output) throws IOException {
        try (OutputStreamWriter writer = null;){
            writer = new FileWriter(fileOnDiskPath, Charset.forName("UTF-8"));
            writer.append(output);
            writer.flush();
            writer.close();
        }
    }

    public BufferedReader standardReadFromDisk(String fileOnDiskPath) throws IOException {
        return new BufferedReader(new FileReader(fileOnDiskPath, Charset.forName("UTF-8")));
    }

    public void moveFromNodeToMaster(String fileName) throws IOException, InterruptedException {
        FilePath masterDirectory = new FilePath(this.build.getRootDir()).child(fileName);
        this.filePath.child(fileName).copyTo(masterDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchExecManager(TaskListener listener, String executionScript, String executionShellLocation, String executionVsifFile, String buildId, int buildNumber, Launcher launcher) throws IOException {
        String sessionNameToMonitor = null;
        String[] command = new String[]{executionShellLocation, executionScript, executionVsifFile};
        this.jobListener.getLogger().print("\nTrying to launch a session using batch on this agent workspace:\n");
        this.jobListener.getLogger().print("Select script for this execution is " + executionScript + "\n");
        this.jobListener.getLogger().print("Select shell type for this execution is " + executionShellLocation + "\n");
        this.jobListener.getLogger().print("Select vsif for this execution is " + executionVsifFile + "\n");
        boolean foundGoodVSIF = false;
        BufferedReader in = null;
        BufferedReader inError = null;
        try {
            Launcher.ProcStarter ps = new Launcher.ProcStarter(launcher);
            ps.cmds(command);
            ps.readStdout();
            ps.readStderr();
            Proc proc = launcher.launch(ps);
            InputStream procInputStream = proc.getStdout();
            if (procInputStream != null) {
                in = new BufferedReader(new InputStreamReader(procInputStream, Charset.forName("UTF-8")));
                inError = new BufferedReader(new InputStreamReader(procInputStream, Charset.forName("UTF-8")));
            }
            String s = null;
            if (in != null) {
                while ((s = in.readLine()) != null) {
                    this.jobListener.getLogger().print(s + "\n");
                    if (s.indexOf("*I,runner.sessionStarted: Session") <= -1) continue;
                    foundGoodVSIF = true;
                    sessionNameToMonitor = s.substring(34, s.indexOf(" started."));
                    String fileOutput = buildNumber + "." + buildId + ".sessions.input";
                    StringBuffer writer = new StringBuffer();
                    writer.append(sessionNameToMonitor);
                    FilePath newFile = this.filePath.child(fileOutput);
                    newFile.write(writer.toString(), StandardCharsets.UTF_8.name());
                }
            }
            String sError = null;
            if (inError != null) {
                while ((sError = inError.readLine()) != null) {
                    this.jobListener.getLogger().print(sError + "\n");
                }
            }
        }
        catch (IOException e) {
            this.jobListener.getLogger().println(e.getMessage());
            for (StackTraceElement ste : e.getStackTrace()) {
                this.jobListener.getLogger().println(" " + String.valueOf(ste));
            }
            this.jobListener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        catch (InterruptedException ex) {
            this.jobListener.getLogger().println(ex.getMessage());
            for (StackTraceElement ste : ex.getStackTrace()) {
                this.jobListener.getLogger().println(" " + String.valueOf(ste));
            }
            this.jobListener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
        finally {
            if (inError != null) {
                inError.close();
            }
            if (in != null) {
                in.close();
            }
        }
        if (!foundGoodVSIF) {
            throw new IOException("Failed to launch vsif using batch.  Job stopped.");
        }
        this.jobListener.getLogger().print("Found session name to monitor: " + sessionNameToMonitor + "\n");
    }
}

