/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.SessionState;
import org.jenkinsci.plugins.vmanager.Utils;

public class SessionStatusHolder {
    String url;
    boolean requireAuth;
    String user;
    String password;
    TaskListener listener;
    boolean dynamicUserId;
    private int buildNumber = 0;
    private String workPlacePath = null;
    private String workingJobDir = null;
    private String buildId = null;
    int connConnTimeOut;
    int connReadTimeout;
    boolean advConfig;
    boolean markBuildAsFailedIfAllRunFailed = false;
    boolean failJobIfAllRunFailed = false;
    boolean markBuildAsPassedIfAllRunPassed = false;
    boolean failJobUnlessAllRunPassed = false;
    List<String> listOfSessions = null;
    private String postDataSessions;
    private String postSessionData = "{\"filter\":{\"@c\":\".ChainedFilter\",\"condition\":\"OR\",\"chain\":[######]},\"grouping\":[\"owner\"],\"settings\":{\"write-hidden\":true,\"stream-mode\":false},\"projection\":{\"type\": \"SELECTION_ONLY\",\"selection\":[\"session_status\",\"name\",\"total_runs_in_session\",\"passed_runs\",\"failed_runs\",\"running\",\"waiting\",\"other_runs\",\"owner\",\"number_of_entities\",\"id\"]}}";

    public SessionStatusHolder(int buildNumber, String workspace, String buildId, String workingJobDir) {
        this.buildNumber = buildNumber;
        this.workPlacePath = workspace;
        this.workingJobDir = workingJobDir;
        this.buildId = buildId;
    }

    public SessionStatusHolder(int buildNumber, String workingJobDir, String buildId) {
        this.buildNumber = buildNumber;
        this.workingJobDir = workingJobDir;
        this.buildId = buildId;
    }

    private void buildPostDataSessionPart(List<String> listOfSessions) {
        Iterator<String> iter = listOfSessions.iterator();
        Object result = "";
        int commaCounter = listOfSessions.size() - 1;
        while (iter.hasNext()) {
            result = (String)result + "{\"attName\":\"id\",\"operand\":\"EQUALS\",\"@c\":\".AttValueFilter\",\"attValue\":\"" + iter.next() + "\"}";
            if (commaCounter > 0) {
                result = (String)result + ",";
            }
            --commaCounter;
        }
        this.postDataSessions = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSessionStatus(boolean postSession, Map<String, String> sessionIdName, Utils utils, Launcher launcher) throws Exception {
        HttpURLConnection conn = null;
        String apiURL = this.url + "/rest/sessions/list";
        BufferedReader br = null;
        try {
            conn = utils.getVAPIConnection(apiURL, this.requireAuth, this.user, this.password, "POST", this.dynamicUserId, this.buildId, this.buildNumber, this.workPlacePath, this.listener, this.connConnTimeOut, this.connReadTimeout, this.advConfig);
            OutputStream os = conn.getOutputStream();
            os.write(this.postSessionData.getBytes(Charset.forName("UTF-8")));
            os.flush();
            if (this.checkResponseCode(conn)) {
                String output;
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
                StringBuilder result = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    result.append(output);
                }
                JSONArray tmpArray = JSONArray.fromObject((Object)result.toString());
                Iterator iterator = tmpArray.iterator();
                JSONObject sessionObject = null;
                if (iterator.hasNext()) {
                    sessionObject = (JSONObject)iterator.next();
                }
                if (sessionObject != null) {
                    this.writeSessionIntoFile(sessionObject, postSession, sessionIdName, utils, launcher);
                }
            }
        }
        catch (Exception e) {
            if ("ALL_RUNS_FAILED".equals(e.getMessage())) {
                throw new Exception("All runs failed in the regression - marking job as a failed job.\n");
            }
            if ("NOT_ALL_RUNS_PASSED".equals(e.getMessage())) {
                throw new Exception("Not all runs passed the regression - marking job as a failed job.\n");
            }
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    private void writeSessionIntoFile(JSONObject session, boolean postSession, Map<String, String> sessionIdName, Utils utils, Launcher launcher) throws IOException, Exception {
        SessionState sessionData = new SessionState();
        if (session.has("session_status")) {
            if ("MIXED_GROUP_VALUE".equals(session.getString("session_status"))) {
                sessionData.setStatus("Mixed");
            } else {
                sessionData.setStatus(session.getString("session_status"));
            }
        }
        if (session.has("name")) {
            if ("ZZZZZZZZZZZZZZZZ".equals(session.getString("name"))) {
                sessionData.setName("Mixed");
            } else {
                try {
                    sessionData.setName(this.cutSessionNameDate(session.getString("name")));
                    sessionData.setSessionCode(this.cutSessionCodeDate(session.getString("name")));
                }
                catch (Exception e) {
                    sessionData.setName(session.getString("name"));
                    sessionData.setSessionCode("");
                    e.printStackTrace();
                }
            }
        }
        if (session.has("total_runs_in_session")) {
            sessionData.setTotalRuns(session.getString("total_runs_in_session"));
        }
        if (session.has("passed_runs")) {
            sessionData.setPassed(session.getString("passed_runs"));
        }
        if (session.has("failed_runs")) {
            sessionData.setFailed(session.getString("failed_runs"));
        }
        if (session.has("running")) {
            sessionData.setRunning(session.getString("running"));
        }
        if (session.has("waiting")) {
            sessionData.setWaiting(session.getString("waiting"));
        }
        if (session.has("other_runs")) {
            sessionData.setOther(session.getString("other_runs"));
        }
        if (session.has("owner")) {
            if ("ZZZZZZZZZZZZZZZZ".equals(session.getString("name"))) {
                sessionData.setOwner("Mixed");
            } else {
                sessionData.setOwner(session.getString("owner"));
            }
        }
        if (session.has("number_of_entities")) {
            sessionData.setNumOfSession(session.getString("number_of_entities"));
        }
        if (session.has("id")) {
            sessionData.setId(session.getString("id"));
        }
        sessionData.setServerUrl(this.url);
        if (postSession) {
            if (this.markBuildAsFailedIfAllRunFailed && sessionData.getTotalRuns().trim().equals(sessionData.getFailed().trim())) {
                sessionData.setStatus("failed");
            }
            if (this.markBuildAsPassedIfAllRunPassed && !sessionData.getTotalRuns().trim().equals(sessionData.getPassed().trim())) {
                sessionData.setStatus("failed");
            }
        }
        StringBuffer writer = new StringBuffer();
        writer.append("status=" + sessionData.getStatus() + "\n");
        writer.append("name=" + sessionData.getName() + "\n");
        writer.append("session_code=" + sessionData.getSessionCode() + "\n");
        writer.append("total_runs_in_session=" + sessionData.getTotalRuns() + "\n");
        writer.append("passed_runs=" + sessionData.getPassed() + "\n");
        writer.append("failed_runs=" + sessionData.getFailed() + "\n");
        writer.append("running=" + sessionData.getRunning() + "\n");
        writer.append("waiting=" + sessionData.getWaiting() + "\n");
        writer.append("other_runs=" + sessionData.getOther() + "\n");
        writer.append("owner=" + sessionData.getOwner() + "\n");
        writer.append("number_of_entities=" + sessionData.getNumOfSession() + "\n");
        Iterator<String> iter = this.listOfSessions.iterator();
        Object result = "";
        Object idNameResult = "";
        String tmpIdHolder = null;
        int commaCounter = this.listOfSessions.size() - 1;
        while (iter.hasNext()) {
            tmpIdHolder = iter.next();
            result = (String)result + tmpIdHolder;
            idNameResult = (String)idNameResult + tmpIdHolder + "$@$" + sessionIdName.get(tmpIdHolder);
            if (commaCounter > 0) {
                result = (String)result + ",";
                idNameResult = (String)idNameResult + ",";
            }
            --commaCounter;
        }
        writer.append("id=" + (String)result + "\n");
        writer.append("url=" + sessionData.getServerUrl() + "\n");
        writer.append("idNames=" + (String)idNameResult + "\n");
        String fileOutput = this.buildNumber + "." + this.buildId + ".session_status.properties";
        if (utils.getFilePath() == null) {
            fileOutput = this.workPlacePath + File.separator + fileOutput;
        }
        utils.saveFileOnDisk(fileOutput, writer.toString());
        utils.moveFromNodeToMaster(this.buildNumber + "." + this.buildId + ".session_status.properties");
        if (postSession) {
            if (this.failJobIfAllRunFailed && sessionData.getTotalRuns().trim().equals(sessionData.getFailed().trim())) {
                throw new Exception("ALL_RUNS_FAILED");
            }
            if (this.failJobUnlessAllRunPassed && !sessionData.getTotalRuns().trim().equals(sessionData.getPassed().trim())) {
                throw new Exception("NOT_ALL_RUNS_PASSED");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionState loadSessionFromFile() {
        SessionState sessionData = new SessionState();
        String fileInput = this.workingJobDir + File.separator + this.buildNumber + "." + this.buildId + ".session_status.properties";
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(fileInput);
            prop.load(input);
            sessionData.setStatus(prop.getProperty("status") != null ? prop.getProperty("status") : "NA");
            sessionData.setName(prop.getProperty("name") != null ? prop.getProperty("name") : "NA");
            sessionData.setSessionCode(prop.getProperty("session_code") != null ? prop.getProperty("session_code") : "NA");
            sessionData.setTotalRuns(prop.getProperty("total_runs_in_session") != null ? prop.getProperty("total_runs_in_session") : "NA");
            sessionData.setPassed(prop.getProperty("passed_runs") != null ? prop.getProperty("passed_runs") : "NA");
            sessionData.setFailed(prop.getProperty("failed_runs") != null ? prop.getProperty("failed_runs") : "NA");
            sessionData.setRunning(prop.getProperty("running") != null ? prop.getProperty("running") : "NA");
            sessionData.setWaiting(prop.getProperty("waiting") != null ? prop.getProperty("waiting") : "NA");
            sessionData.setOther(prop.getProperty("other_runs") != null ? prop.getProperty("other_runs") : "NA");
            sessionData.setOwner(prop.getProperty("owner") != null ? prop.getProperty("owner") : "NA");
            sessionData.setNumOfSession(prop.getProperty("number_of_entities") != null ? prop.getProperty("number_of_entities") : "NA");
            sessionData.setId(prop.getProperty("id") != null ? prop.getProperty("id") : "NA");
            sessionData.setServerUrl(prop.getProperty("url") != null ? prop.getProperty("url") : "NA");
            sessionData.setIdNames(prop.getProperty("idNames") != null ? prop.getProperty("idNames") : "NA");
        }
        catch (IOException ex) {
            System.out.println("Verisium Manager Dashboard - Can't find file " + fileInput);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sessionData;
    }

    private boolean checkResponseCode(HttpURLConnection conn) {
        try {
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205 && conn.getResponseCode() != 406) {
                System.out.println("Error - Got wrong response from /session/list request for session status - " + conn.getResponseCode());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String cutSessionNameDate(String sessionName) {
        for (int i = 0; i < 6; ++i) {
            sessionName = sessionName.substring(0, sessionName.lastIndexOf("_"));
        }
        sessionName = sessionName.substring(0, sessionName.lastIndexOf("."));
        sessionName = sessionName.substring(0, sessionName.lastIndexOf("."));
        return sessionName;
    }

    private String cutSessionCodeDate(String sessionName) {
        String sessionCode = "NA";
        try {
            sessionCode = sessionName.substring(sessionName.lastIndexOf("_") + 1, sessionName.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sessionCode;
    }

    public SessionStatusHolder(String url, boolean requireAuth, String user, String password, TaskListener listener, boolean dynamicUserId, int buildNumber, String workPlacePath, String buildId, int connConnTimeOut, int connReadTimeout, boolean advConfig, List<String> listOfSessions, boolean markBuildAsFailedIfAllRunFailed, boolean failJobIfAllRunFailed, String workingJobDir, boolean markBuildAsPassedIfAllRunPassed, boolean failJobUnlessAllRunPassed) {
        this.url = url;
        this.requireAuth = requireAuth;
        this.user = user;
        this.password = password;
        this.listener = listener;
        this.dynamicUserId = dynamicUserId;
        this.buildNumber = buildNumber;
        this.workPlacePath = workPlacePath;
        this.buildId = buildId;
        this.connConnTimeOut = connConnTimeOut;
        this.connReadTimeout = connReadTimeout;
        this.advConfig = advConfig;
        this.listOfSessions = listOfSessions;
        this.markBuildAsFailedIfAllRunFailed = markBuildAsFailedIfAllRunFailed;
        this.failJobIfAllRunFailed = failJobIfAllRunFailed;
        this.workingJobDir = workingJobDir;
        this.markBuildAsPassedIfAllRunPassed = markBuildAsPassedIfAllRunPassed;
        this.failJobUnlessAllRunPassed = failJobUnlessAllRunPassed;
        this.buildPostDataSessionPart(listOfSessions);
        this.postSessionData = this.postSessionData.replaceAll("######", this.postDataSessions);
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getWorkspace() {
        return this.workPlacePath;
    }

    public void setWorkPlacePath(String workspace) {
        this.workPlacePath = workspace;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getWorkingJobDir() {
        return this.workingJobDir;
    }

    public void setWorkingJobDir(String workingJobDir) {
        this.workingJobDir = workingJobDir;
    }
}

