/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.SessionState;
import org.jenkinsci.plugins.vmanager.Utils;

public class SessionNameIdHolder {
    private String postSessionData = "{\"filter\":{\"@c\":\".ChainedFilter\",\"condition\":\"OR\",\"chain\":[######]},\"pageLength\":10000,\"settings\":{\"write-hidden\":true,\"stream-mode\":false},\"projection\":{\"type\": \"SELECTION_ONLY\",\"selection\":[\"name\",\"id\"]}}";

    private String buildPostDataSessionPart(String[] listOfSessions) {
        Object result = "";
        int commaCounter = listOfSessions.length - 1;
        for (int i = 0; i < listOfSessions.length; ++i) {
            result = (String)result + "{\"attName\":\"name\",\"operand\":\"EQUALS\",\"@c\":\".AttValueFilter\",\"attValue\":\"" + listOfSessions[i].trim() + "\"}";
            if (commaCounter > 0) {
                result = (String)result + ",";
            }
            --commaCounter;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSessionNames(String[] sessionNames, String url, boolean requireAuth, String user, String password, TaskListener listener, boolean dynamicUserId, String buildID, int buildNumber, String workPlacePath, int connConnTimeOut, int connReadTimeout, boolean advConfig, Utils utils) throws Exception {
        HttpURLConnection conn = null;
        listener.getLogger().print("Trying to get session ID for the session names supplied:\n");
        String apiURL = url + "/rest/sessions/list";
        ArrayList<String> sessionList = new ArrayList<String>();
        BufferedReader br = null;
        try {
            conn = utils.getVAPIConnection(apiURL, requireAuth, user, password, "POST", dynamicUserId, buildID, buildNumber, workPlacePath, listener, connConnTimeOut, connReadTimeout, advConfig);
            OutputStream os = conn.getOutputStream();
            String postData = this.postSessionData.replaceAll("######", this.buildPostDataSessionPart(sessionNames));
            os.write(postData.getBytes(Charset.forName("UTF-8")));
            os.flush();
            if (this.checkResponseCode(conn)) {
                String output;
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
                StringBuilder result = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    result.append(output);
                }
                JSONArray tmpArray = JSONArray.fromObject((Object)result.toString());
                Iterator iterator = tmpArray.iterator();
                JSONObject sessionObject = null;
                while (iterator.hasNext()) {
                    sessionObject = (JSONObject)iterator.next();
                    SessionState st = this.extractSessionIDFromResponse(sessionObject);
                    if (st == null) continue;
                    listener.getLogger().print("Found ID: " + st.getId() + " for session name: " + st.getName() + "\n");
                    sessionList.add(st.getId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (br != null) {
                br.close();
            }
        }
        return sessionList;
    }

    private SessionState extractSessionIDFromResponse(JSONObject session) throws IOException, Exception {
        SessionState st = null;
        if (session.has("id")) {
            st = new SessionState();
            st.setId(session.getString("id"));
            st.setName(session.getString("name"));
        }
        return st;
    }

    private boolean checkResponseCode(HttpURLConnection conn) {
        try {
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205 && conn.getResponseCode() != 406) {
                System.out.println("Error - Got wrong response from /session/list request for session id - " + conn.getResponseCode());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

