/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.vmanager.BuildStatusMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.vmanager.SummaryReportParams;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VAPIConnectionParam;
import org.jenkinsci.plugins.vmanager.VMGRRun;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ReportManager {
    private static final String runsFilter = "{\"filter\":{\"@c\":\".RelationFilter\",\"relationName\":\"session\",\"filter\":{\"@c\":\".ChainedFilter\",\"condition\":\"OR\",\"chain\":[######]}}}";
    private Run<?, ?> build;
    private SummaryReportParams summaryReportParams;
    private VAPIConnectionParam vAPIConnectionParam;
    private VMGRRun vmgrRun;
    private TaskListener listener;
    private boolean testMode = false;
    private Utils utils;

    public ReportManager(Run<?, ?> build, SummaryReportParams summaryReportParams, VAPIConnectionParam vAPIConnectionParam, TaskListener listener, FilePath filePath) {
        this.build = build;
        this.summaryReportParams = summaryReportParams;
        this.vAPIConnectionParam = vAPIConnectionParam;
        this.listener = listener;
        if (vAPIConnectionParam != null) {
            try {
                this.vAPIConnectionParam.vAPIUrl = TokenMacro.expandAll(build, (FilePath)filePath, (TaskListener)listener, (String)vAPIConnectionParam.vAPIUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                listener.getLogger().println("Failed to extract out macro from the input of vAPIUrl: " + vAPIConnectionParam.vAPIUrl);
            }
        }
        Job job = build.getParent();
        String workingDir = String.valueOf(job.getBuildDir()) + File.separator + build.getNumber();
        this.vmgrRun = new VMGRRun(build, workingDir, job.getBuildDir().getAbsolutePath());
        this.utils = new Utils(build, listener, filePath);
    }

    public ReportManager(SummaryReportParams summaryReportParams, VAPIConnectionParam vAPIConnectionParam, boolean testMode) {
        this.testMode = testMode;
        this.summaryReportParams = summaryReportParams;
        this.vAPIConnectionParam = vAPIConnectionParam;
    }

    private String buildPostDataSessionFilter() {
        String[] listOfSessions;
        if (this.testMode) {
            listOfSessions = new String[]{"1"};
        } else {
            String sessionIdFromBuild = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir(), "id", true);
            listOfSessions = sessionIdFromBuild.split("\\s*,\\s*");
        }
        Object result = "";
        int commaCounter = listOfSessions.length - 1;
        for (String listOfSession : listOfSessions) {
            result = (String)result + "{\"attName\":\"id\",\"operand\":\"EQUALS\",\"@c\":\".AttValueFilter\",\"attValue\":\"" + listOfSession.trim() + "\"}";
            if (commaCounter > 0) {
                result = (String)result + ",";
            }
            --commaCounter;
        }
        return result;
    }

    private String getReportEmailAddresses() {
        StringBuilder output = null;
        String result = null;
        if ("static".equals(this.summaryReportParams.emailType)) {
            String[] values = this.summaryReportParams.emailList.split(",");
            output = new StringBuilder("");
            for (String email : values) {
                output.append("\"").append(email.trim()).append("\",");
            }
            if (output.length() > 2) {
                result = output.toString().substring(0, output.toString().length() - 1);
            }
        } else {
            try {
                String[] emails = this.utils.loadDataFromInputFiles(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir(), this.summaryReportParams.emailInputFile, this.listener, this.summaryReportParams.deleteEmailInputFile, "emails", "emails.input");
                output = new StringBuilder("");
                for (String email : emails) {
                    output.append("\"").append(email.trim()).append("\",");
                }
                if (output.length() > 2) {
                    result = output.toString().substring(0, output.toString().length() - 1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.listener.getLogger().println("Failed to find the email input file " + this.summaryReportParams.emailInputFile + " or any email file within the workspace for this build.\n " + e.getMessage());
            }
        }
        return result;
    }

    public String buildPostParamForSummaryReport(boolean email) throws Exception {
        if (email) {
            if (!this.testMode) {
                this.listener.getLogger().println("Starting to build the POST API part for sending the report email.");
            }
        } else if (!this.testMode) {
            this.listener.getLogger().println("Starting to build the POST API part for creating summary report.");
        }
        JSONParser jsonParser = new JSONParser();
        Object postData = "";
        if (this.summaryReportParams.summaryType.equals("wizard")) {
            FilePath filePath;
            Executor exceutor;
            if (!this.testMode) {
                this.listener.getLogger().println("ReportManager - Using wizrd based json to bring the report...");
            }
            JSONObject ctxData = null;
            Object staticParams = "$jenkins_mode\"override\":true,\"sessionsViewName\":\"All_Sessions\",\"linkOutput\":$link_output,\"title\":\"Summary report\",\"includeSessions\":true,\"includeAll\":false$test_view_name$metrics_view_name$vplan_view_name$test_depth";
            if (this.summaryReportParams.runReport) {
                this.summaryReportParams.includeTests = true;
                String testsDepth = ",\"testsDepth\":" + this.summaryReportParams.testsDepth;
                String testsViewName = ",\"testsViewName\":\"" + this.summaryReportParams.testsViewName.trim() + "\"";
                staticParams = ((String)staticParams).replace("$test_depth", testsDepth);
                staticParams = ((String)staticParams).replace("$test_view_name", testsViewName);
            } else {
                this.summaryReportParams.includeTests = false;
                staticParams = ((String)staticParams).replace("$test_depth", "");
                staticParams = ((String)staticParams).replace("$test_view_name", "");
            }
            if (this.summaryReportParams.metricsReport) {
                String metricsViewName = ",\"metricsViewName\":\"" + this.summaryReportParams.metricsViewName.trim() + "\"";
                staticParams = ((String)staticParams).replace("$metrics_view_name", metricsViewName);
            } else {
                staticParams = ((String)staticParams).replace("$metrics_view_name", "");
            }
            if (this.summaryReportParams.vPlanReport) {
                String vplanViewName = ",\"vplanViewName\":\"" + this.summaryReportParams.vplanViewName.trim() + "\"";
                staticParams = ((String)staticParams).replace("$vplan_view_name", vplanViewName);
            } else {
                staticParams = ((String)staticParams).replace("$vplan_view_name", "");
            }
            if (email) {
                staticParams = ((String)staticParams).replace("$link_output", "false");
                staticParams = ((String)staticParams).replace("$jenkins_mode", "");
                staticParams = "\"emails\":[" + this.getReportEmailAddresses() + "]," + (String)staticParams;
            } else {
                staticParams = ((String)staticParams).replace("$link_output", "true");
            }
            staticParams = "stream".equals(this.summaryReportParams.vManagerVersion) ? ((String)staticParams).replace("$jenkins_mode", "\"jenkins\":true,") : ((String)staticParams).replace("$jenkins_mode", "");
            postData = (String)postData + "{" + (String)staticParams + ",\"includeTests\":" + this.summaryReportParams.includeTests;
            if (this.summaryReportParams.metricsReport) {
                JSONObject metricsData;
                block56: {
                    String tmpDataHolder = null;
                    try {
                        if (this.summaryReportParams.metricsInputType.equals("basic")) {
                            tmpDataHolder = "{\"scope\":\"default\",\"extended\":false,\"instances\":true,\"types\":true,\"depth\":6}";
                            metricsData = (JSONObject)jsonParser.parse(tmpDataHolder);
                            metricsData.replace((Object)"depth", (Object)this.summaryReportParams.metricsDepth);
                            break block56;
                        }
                        try {
                            Executor exceutor2 = this.build.getExecutor();
                            FilePath filePath2 = null;
                            if (exceutor2 == null) {
                                throw new Exception("Failed to find Executor");
                            }
                            filePath2 = exceutor2.getCurrentWorkspace();
                            tmpDataHolder = TokenMacro.expandAll(this.build, (FilePath)filePath2, (TaskListener)this.listener, (String)this.summaryReportParams.metricsAdvanceInput.trim());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.listener.getLogger().println("Failed to extract out macro from the input of report metricsAdvanceInput: " + this.summaryReportParams.metricsAdvanceInput);
                            tmpDataHolder = this.summaryReportParams.metricsAdvanceInput.trim();
                        }
                        metricsData = (JSONObject)jsonParser.parse(tmpDataHolder);
                    }
                    catch (Exception e) {
                        this.listener.getLogger().println("ReportManager - fail to parse metricsData json input: " + tmpDataHolder);
                        throw e;
                    }
                }
                postData = (String)postData + ",\"metricsData\":[" + metricsData.toJSONString() + "]";
            }
            String parsedVPlanFileName = null;
            if (this.summaryReportParams.vPlanReport) {
                JSONObject vplanData;
                block57: {
                    String tmpDataHolder = null;
                    try {
                        if (this.summaryReportParams.vPlanInputType.equals("basic")) {
                            tmpDataHolder = "{\"extended\":true,\"instances\":true,\"types\":true,\"depth\":6}";
                            vplanData = (JSONObject)jsonParser.parse(tmpDataHolder);
                            vplanData.replace((Object)"depth", (Object)this.summaryReportParams.vPlanDepth);
                            break block57;
                        }
                        try {
                            exceutor = this.build.getExecutor();
                            filePath = null;
                            if (exceutor == null) {
                                throw new Exception("Failed to find Executor");
                            }
                            filePath = exceutor.getCurrentWorkspace();
                            tmpDataHolder = TokenMacro.expandAll(this.build, (FilePath)filePath, (TaskListener)this.listener, (String)this.summaryReportParams.vPlanAdvanceInput.trim());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.listener.getLogger().println("Failed to extract out macro from the input of report vPlanAdvanceInput: " + this.summaryReportParams.vPlanAdvanceInput);
                            tmpDataHolder = this.summaryReportParams.vPlanAdvanceInput.trim();
                        }
                        vplanData = (JSONObject)jsonParser.parse(tmpDataHolder);
                    }
                    catch (Exception e) {
                        this.listener.getLogger().println("ReportManager - fail to parse vplanData json input: " + tmpDataHolder);
                        throw e;
                    }
                }
                try {
                    ctxData = (JSONObject)jsonParser.parse("{}");
                    if (this.summaryReportParams.vPlanxFileName.trim().indexOf("(DB)") > -1) {
                        ctxData.put((Object)"db-vplan", (Object)true);
                        this.summaryReportParams.vPlanxFileName = this.summaryReportParams.vPlanxFileName.substring(0, this.summaryReportParams.vPlanxFileName.trim().indexOf("(DB)")).trim();
                    }
                    try {
                        exceutor = this.build.getExecutor();
                        filePath = null;
                        if (exceutor == null) {
                            throw new Exception("Failed to find Executor");
                        }
                        filePath = exceutor.getCurrentWorkspace();
                        parsedVPlanFileName = TokenMacro.expandAll(this.build, (FilePath)filePath, (TaskListener)this.listener, (String)this.summaryReportParams.vPlanxFileName.trim());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.listener.getLogger().println("Failed to extract out macro from the input of report vPlanxFileName: " + this.summaryReportParams.vPlanxFileName);
                        parsedVPlanFileName = this.summaryReportParams.vPlanxFileName.trim();
                    }
                    ctxData.put((Object)"vplanFile", (Object)parsedVPlanFileName);
                }
                catch (Exception e) {
                    this.listener.getLogger().println("ReportManager - fail to parse ctxData json input for vPlan name: " + this.summaryReportParams.vPlanxFileName);
                    throw e;
                }
                postData = (String)postData + ",\"vplanData\":[" + vplanData.toJSONString() + "]";
            }
            if (this.summaryReportParams.ctxInput) {
                try {
                    String ctxDataStringForEvaluating = null;
                    try {
                        exceutor = this.build.getExecutor();
                        filePath = null;
                        if (exceutor == null) {
                            throw new Exception("Failed to find Executor");
                        }
                        filePath = exceutor.getCurrentWorkspace();
                        ctxDataStringForEvaluating = TokenMacro.expandAll(this.build, (FilePath)filePath, (TaskListener)this.listener, (String)this.summaryReportParams.ctxAdvanceInput);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.listener.getLogger().println("Failed to extract out macro from the input of report ctxData: " + this.summaryReportParams.ctxAdvanceInput);
                        ctxDataStringForEvaluating = this.summaryReportParams.ctxAdvanceInput;
                    }
                    ctxData = (JSONObject)jsonParser.parse(ctxDataStringForEvaluating);
                    if (this.summaryReportParams.vPlanReport && !this.summaryReportParams.vPlanxFileName.trim().equals("") && !ctxData.containsKey((Object)"vplanFile")) {
                        ctxData.put((Object)"vplanFile", parsedVPlanFileName);
                    }
                }
                catch (Exception e) {
                    this.listener.getLogger().println("ReportManager - fail to parse ctxData json input for vPlan name: " + this.summaryReportParams.vPlanxFileName);
                    throw e;
                }
                postData = (String)postData + ",\"ctxData\":" + ctxData.toJSONString();
            } else if (this.summaryReportParams.vPlanReport) {
                postData = (String)postData + ",\"ctxData\":" + ctxData.toJSONString();
            }
            postData = (String)postData + ",\"rs\":" + runsFilter.replace("######", this.buildPostDataSessionFilter()) + "}";
        } else {
            JSONObject rsData;
            JSONObject userSyntaxData;
            if (!this.testMode) {
                this.listener.getLogger().println("ReportManager - Using user freestyle json to bring the report...");
            }
            String freeVAPISyntax = this.testMode ? this.utils.loadUserSyntaxForSummaryReport("20", 20, "c://temp", this.summaryReportParams.freeVAPISyntax, null, this.summaryReportParams.deleteReportSyntaxInputFile) : this.utils.loadUserSyntaxForSummaryReport(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir(), this.summaryReportParams.freeVAPISyntax, this.listener, this.summaryReportParams.deleteReportSyntaxInputFile);
            if (!this.testMode) {
                this.listener.getLogger().println("ReportManager - User freestyle syntax is:\n" + freeVAPISyntax + "\n");
            }
            try {
                userSyntaxData = (JSONObject)jsonParser.parse(freeVAPISyntax);
            }
            catch (Exception e) {
                this.listener.getLogger().println("ReportManager - fail to parse user free syntax json input for summary report: " + this.summaryReportParams.vPlanxFileName);
                throw e;
            }
            try {
                rsData = (JSONObject)jsonParser.parse(runsFilter.replace("######", this.buildPostDataSessionFilter()));
            }
            catch (Exception e) {
                this.listener.getLogger().println("ReportManager - fail to parse rsData for sessions list: " + this.buildPostDataSessionFilter());
                throw e;
            }
            userSyntaxData.put((Object)"rs", (Object)rsData);
            if (userSyntaxData.containsKey((Object)"jenkins")) {
                userSyntaxData.remove((Object)"jenkins");
            }
            if ("stream".equals(this.summaryReportParams.vManagerVersion)) {
                userSyntaxData.put((Object)"jenkins", (Object)true);
            }
            if (email) {
                if (!userSyntaxData.containsKey((Object)"emails")) {
                    JSONArray jsonArray = (JSONArray)jsonParser.parse("[" + this.getReportEmailAddresses() + "]");
                    userSyntaxData.put((Object)"emails", (Object)jsonArray);
                }
                if (userSyntaxData.containsKey((Object)"jenkins")) {
                    userSyntaxData.remove((Object)"jenkins");
                }
                if (userSyntaxData.containsKey((Object)"linkOutput")) {
                    userSyntaxData.remove((Object)"linkOutput");
                }
            }
            postData = userSyntaxData.toJSONString();
        }
        return postData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchFromRemoteURL(String reportUrl) throws Exception {
        CloseableHttpResponse httpResponse;
        StatusLine statusLine;
        JSONObject urlObject;
        JSONParser jsonParser = new JSONParser();
        try {
            urlObject = (JSONObject)jsonParser.parse(reportUrl);
        }
        catch (Exception e) {
            this.listener.getLogger().println("ReportManager - fail to parse url from /reports/generate-summary-report: " + reportUrl);
            throw e;
        }
        int buildNumber = 20;
        String buildId = "20";
        String jobWorkingDir = "c://temp";
        if (!this.testMode) {
            buildNumber = this.vmgrRun.getRun().getNumber();
            buildId = this.vmgrRun.getRun().getId();
            jobWorkingDir = this.vmgrRun.getJobWorkingDir();
        }
        CloseableHttpClient httpClient = null;
        httpClient = this.summaryReportParams.ignoreSSLError ? this.fixUntrustCertificate() : HttpClients.createDefault();
        String username = this.vAPIConnectionParam.vAPIUser;
        String thePath = this.vAPIConnectionParam.vAPIUrl + "/rest/reports" + String.valueOf(urlObject.get((Object)"path"));
        HttpGet httpGet = new HttpGet(thePath);
        if (this.vAPIConnectionParam.authRequired) {
            if (this.vAPIConnectionParam.dynamicUserId) {
                try (BufferedReader reader = null;){
                    reader = this.utils.loadFileFromWorkSpace(buildId, buildNumber, jobWorkingDir, null, this.listener, false, "user.input");
                    String line = null;
                    line = reader.readLine();
                    if (line != null) {
                        username = line;
                    }
                }
            }
            String userpass = username + ":" + this.vAPIConnectionParam.vAPIPassword;
            String basicAuth = "Basic " + Base64.getUrlEncoder().encodeToString(userpass.getBytes(Charset.forName("UTF-8")));
            httpGet.setHeader("Authorization", basicAuth);
        }
        if ((statusLine = (httpResponse = httpClient.execute((HttpUriRequest)httpGet)).getStatusLine()).getStatusCode() == 200) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                HttpEntity entity = httpResponse.getEntity();
                entity.writeTo((OutputStream)outputStream);
                EntityUtils.consume((HttpEntity)entity);
                Object output = outputStream.toString(Charset.forName("UTF-8"));
                int start = ((String)output).indexOf("<head>");
                int end = ((String)output).indexOf("</head>") + 7;
                output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
                start = ((String)output).indexOf("<style>");
                end = ((String)output).indexOf("</style>") + 8;
                output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
                start = ((String)output).indexOf("<script>");
                end = ((String)output).indexOf("</script>") + 9;
                output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
                start = ((String)output).indexOf("<script>");
                end = ((String)output).indexOf("</script>") + 9;
                output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
                output = ((String)output).replace("<html>", "");
                output = ((String)output).replace("</html>", "");
                output = ((String)output).replace("<body>", "");
                output = ((String)output).replace("</body>", "");
                String fileOutput = buildNumber + "." + buildId + ".summary.report";
                if (this.utils.getFilePath() == null) {
                    fileOutput = jobWorkingDir + File.separator + fileOutput;
                }
                StringBuffer writer = new StringBuffer();
                writer.append((String)output);
                this.utils.saveFileOnDisk(fileOutput, writer.toString());
                this.utils.moveFromNodeToMaster(buildNumber + "." + buildId + ".summary.report");
                if (!this.testMode) {
                    this.listener.getLogger().println("Report Summary was created succesfully.");
                }
            }
            finally {
                httpResponse.close();
            }
        }
    }

    private void convertBYORToJenkinsType(int buildNumber, String buildId, String jobWorkingDir) throws Exception {
        try {
            Object output = this.utils.getFilePath().child(buildNumber + "." + buildId + ".user.summary.report").readToString();
            int start = ((String)output).indexOf("<head>");
            int end = ((String)output).indexOf("</head>") + 7;
            output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
            start = ((String)output).indexOf("<style>");
            end = ((String)output).indexOf("</style>") + 8;
            output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
            start = ((String)output).indexOf("<script>");
            end = ((String)output).indexOf("</script>") + 9;
            output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
            start = ((String)output).indexOf("<script>");
            end = ((String)output).indexOf("</script>") + 9;
            output = ((String)output).substring(0, start) + ((String)output).substring(end, ((String)output).length());
            output = ((String)output).replace("<html>", "");
            output = ((String)output).replace("</html>", "");
            output = ((String)output).replace("<body>", "");
            output = ((String)output).replace("</body>", "");
            FilePath outFile = this.utils.getFilePath().child(buildNumber + "." + buildId + ".summary.report");
            outFile.write((String)output, "UTF-8");
        }
        catch (IOException e) {
            this.listener.getLogger().println("Failed to find the user provided summary report file: " + this.utils.getFilePath().child(buildNumber + "." + buildId + ".user.summary.report").getRemote());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrievReportFromServer(boolean isStreamingOn, Launcher launcher) throws Exception {
        block44: {
            int buildNumber = 20;
            String buildId = "20";
            String jobWorkingDir = "c://temp";
            String jobRootDir = "c://temp";
            if (!this.testMode) {
                buildNumber = this.vmgrRun.getRun().getNumber();
                buildId = this.vmgrRun.getRun().getId();
                jobWorkingDir = this.vmgrRun.getJobWorkingDir();
                jobRootDir = this.build.getRootDir().getAbsolutePath();
            }
            if (this.summaryReportParams.summaryMode.equals("selfmade")) {
                this.listener.getLogger().println("User choose to bring the report manually.  Skipping automatic retrieval...");
                this.listener.getLogger().println("Converting Users Report Summary into Jenkins format....");
                this.convertBYORToJenkinsType(buildNumber, buildId, jobWorkingDir);
                this.listener.getLogger().println("Copying over user report summary into Jenkins job location at master....");
                this.utils.moveFromNodeToMaster(buildNumber + "." + buildId + ".summary.report");
                this.listener.getLogger().println("Report Summary was copied succesfully.");
                return;
            }
            HttpURLConnection conn = null;
            String apiURL = this.vAPIConnectionParam.vAPIUrl + "/rest/reports/generate-summary-report";
            if (isStreamingOn) {
                apiURL = this.vAPIConnectionParam.vAPIUrl + "/rest/reports/stream-summary-report";
            }
            BufferedReader br = null;
            try {
                String output;
                conn = this.utils.getVAPIConnection(apiURL, this.vAPIConnectionParam.authRequired, this.vAPIConnectionParam.vAPIUser, this.vAPIConnectionParam.vAPIPassword, "POST", this.vAPIConnectionParam.dynamicUserId, buildId, buildNumber, jobRootDir, this.listener, this.vAPIConnectionParam.connTimeout, this.vAPIConnectionParam.readTimeout, this.vAPIConnectionParam.advConfig);
                OutputStream os = conn.getOutputStream();
                String postData = this.buildPostParamForSummaryReport(false);
                if (!this.testMode) {
                    this.listener.getLogger().println("ReportManager is using the following POST data for getting the summary report:\n" + postData);
                } else {
                    System.out.println(postData);
                }
                os.write(postData.getBytes(Charset.forName("UTF-8")));
                os.flush();
                if (this.checkResponseCode(conn)) {
                    String output2;
                    if (isStreamingOn) {
                        InputStream inputStream = conn.getInputStream();
                        Object fileOutput = buildNumber + "." + buildId + ".summary.report";
                        if (this.utils.getFilePath() == null) {
                            fileOutput = jobWorkingDir + File.separator + (String)fileOutput;
                        } else {
                            FilePath newFile = this.utils.getFilePath().child((String)fileOutput);
                            fileOutput = newFile.getRemote();
                        }
                        this.listener.getLogger().println("Full Path of temporary remote report is: " + (String)fileOutput);
                        try (OutputStream outputStream = this.utils.getRemoteDiskOutoutStream((String)fileOutput);){
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, bytesRead);
                            }
                            outputStream.flush();
                            this.utils.moveFromNodeToMaster(buildNumber + "." + buildId + ".summary.report");
                            if (!this.testMode) {
                                this.listener.getLogger().println("Report Summary was created succesfully.");
                            }
                            break block44;
                        }
                        catch (IOException e) {
                            this.listener.getLogger().println("Failed to stream the report from the server.");
                            e.printStackTrace();
                            break block44;
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                    StringBuffer sb = new StringBuffer();
                    while ((output2 = br.readLine()) != null) {
                        sb.append(output2);
                    }
                    this.fetchFromRemoteURL(sb.toString());
                    break block44;
                }
                br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), "UTF-8"));
                String fileOutput = buildNumber + "." + buildId + ".summary.report";
                if (this.utils.getFilePath() == null) {
                    fileOutput = jobWorkingDir + File.separator + fileOutput;
                }
                StringBuffer writer = new StringBuffer();
                writer.append("<div class=\"microAgentWaiting\"><div class=\"spinnerMicroAgentMessage\"><p><img src=\"/plugin/vmanager-plugin/img/support-icon.png\"></img></p><p>");
                writer.append("Failure to retrieve the report from the Verisium Manager server for this build.  Check your parameters.<br>Below you can find the exception that was thrown during the retrieval process:<br><br><strong>");
                while ((output = br.readLine()) != null) {
                    writer.append(output + "<br>");
                }
                if (conn.getResponseCode() == 500 && "stream".equals(this.summaryReportParams.vManagerVersion)) {
                    writer.append("<br><br>");
                    writer.append("Hint: This error usually indicates that you choosed the wrong Verisium Manager version at the plugin configuration section for Verisium Manager Version.<br>");
                    writer.append("If that's the case, and if your Verisium Manager server version is below 19.09 - set Verisium Manager Version as \"html\" (if pipeline dsl is used), or \"Lower than 19.09\" for regular post configuration mode.<br>");
                }
                writer.append("</strong></p></div></div>");
                this.utils.saveFileOnDisk(fileOutput, writer.toString());
                this.utils.moveFromNodeToMaster(buildNumber + "." + buildId + ".summary.report");
            }
            catch (Exception e) {
                if (this.testMode) {
                    e.printStackTrace();
                } else {
                    e.printStackTrace();
                    if (!this.testMode) {
                        this.listener.getLogger().println("Failed to retrieve report from the Verisium Manager server.");
                        String fileOutput = buildNumber + "." + buildId + ".summary.report";
                        if (this.utils.getFilePath() == null) {
                            fileOutput = jobWorkingDir + File.separator + fileOutput;
                        }
                        StringBuffer writer = new StringBuffer();
                        writer.append("<div class=\"microAgentWaiting\"><div class=\"spinnerMicroAgentMessage\"><p><img src=\"/plugin/vmanager-plugin/img/support-icon.png\"></img></p><p>");
                        writer.append("Failure to retrieve the report from the Verisium Manager server for this build.  Check your parameters.<br>Below you can find the exception that was thrown during the retrieval process:<br><br><strong>");
                        writer.append(e.getMessage());
                        writer.append("</strong></p></div></div>");
                        this.utils.saveFileOnDisk(fileOutput, writer.toString());
                        this.utils.moveFromNodeToMaster(buildNumber + "." + buildId + ".summary.report");
                    }
                }
                throw e;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
                if (br != null) {
                    br.close();
                }
            }
        }
    }

    public void emailSummaryReport() throws Exception {
        if (!this.summaryReportParams.sendEmail) {
            return;
        }
        if (this.summaryReportParams.summaryMode.equals("selfmade")) {
            return;
        }
        HttpURLConnection conn = null;
        String apiURL = this.vAPIConnectionParam.vAPIUrl + "/rest/reports/generate-summary-report";
        int buildNumber = 20;
        String buildId = "20";
        String jobRootDir = "c://temp";
        if (!this.testMode) {
            buildNumber = this.vmgrRun.getRun().getNumber();
            buildId = this.vmgrRun.getRun().getId();
            jobRootDir = this.build.getRootDir().getAbsolutePath();
        }
        BufferedReader br = null;
        try {
            conn = this.utils.getVAPIConnection(apiURL, this.vAPIConnectionParam.authRequired, this.vAPIConnectionParam.vAPIUser, this.vAPIConnectionParam.vAPIPassword, "POST", this.vAPIConnectionParam.dynamicUserId, buildId, buildNumber, jobRootDir, this.listener, this.vAPIConnectionParam.connTimeout, this.vAPIConnectionParam.readTimeout, this.vAPIConnectionParam.advConfig);
            OutputStream os = conn.getOutputStream();
            String postData = this.buildPostParamForSummaryReport(true);
            if (!this.testMode) {
                this.listener.getLogger().println("ReportManager is using the following POST data for sending the summary report email:\n" + postData);
            } else {
                System.out.println(postData);
            }
            os.write(postData.getBytes(Charset.forName("UTF-8")));
            os.flush();
            if (!this.checkResponseCode(conn)) {
                String output;
                br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), "UTF-8"));
                StringBuffer sb = new StringBuffer();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
                if (!this.testMode) {
                    this.listener.getLogger().println("Failed to send report using the Verisium Manager server.  Exception is:\n" + sb.toString());
                }
            } else if (!this.testMode) {
                this.listener.getLogger().println("Report Summary email was sent succesfully.");
            }
        }
        catch (Exception e) {
            if (this.testMode) {
                e.printStackTrace();
            } else if (!this.testMode) {
                this.listener.getLogger().println("Failed to send report using the Verisium Manager server.");
            }
            throw e;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public String getReportFromWorkspace() {
        String fileInput = this.vmgrRun.getJobWorkingDir() + File.separator + this.vmgrRun.getRun().getNumber() + "." + this.vmgrRun.getRun().getId() + ".summary.report";
        Object output = "<div class=\"microAgentWaiting\"><div class=\"spinnerMicroAgentMessage\"><p><img src=\"/plugin/vmanager-plugin/img/weblinks.png\"></img></p><p>Failed to find a report file for this build.<br>Please check that the following file exist:<br>" + fileInput + "</p></div></div>";
        try {
            output = new String(Files.readAllBytes(Paths.get(fileInput, new String[0])), Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            System.out.println("Verisium Manager Action - Can't find file for loading report: " + fileInput);
            return output;
        }
        return output;
    }

    private boolean checkResponseCode(HttpURLConnection conn) {
        try {
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205 && conn.getResponseCode() != 406) {
                if ("html".equals(this.summaryReportParams.vManagerVersion)) {
                    if (!this.testMode) {
                        this.listener.getLogger().println("Error - Got wrong response from /reports/generate-summary-report - " + conn.getResponseCode());
                    }
                } else if (!this.testMode) {
                    this.listener.getLogger().println("Error - Got wrong response from /reports/stream-summary-report - " + conn.getResponseCode());
                }
                return false;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public CloseableHttpClient fixUntrustCertificate() throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry reg = RegistryBuilder.create().register("https", (Object)socketFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(reg);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        return httpClient;
    }
}

