/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.model.Run;
import hudson.plugins.vmanager.BuildStatusMap;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRRun;

public class PostActionBase {
    public static final int numberOfBuilds = 15;
    public VMGRRun vmgrRun;

    public String getTimestampSortData(VMGRRun run) {
        return String.valueOf(run.getRun().getTimeInMillis());
    }

    public String getBuildOwner(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "owner", true);
    }

    public String getSessionTriage(VMGRRun run) {
        Object output = "#";
        String sessionId = BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "id", false);
        if (sessionId.indexOf(",") > 0) {
            output = "../" + run.getRun().getNumber() + "/vManagerSessionsView";
        } else {
            String url = BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "url", false);
            if ("NA".equals(url)) {
                return "NA";
            }
            output = Utils.getRegressionURLFromVAPIURL(url) + "?sessionid=" + sessionId;
        }
        return output;
    }

    public String getSessionStatus(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "status", false);
    }

    public String getSessionName(VMGRRun run) {
        Object sessionName = BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "name", false);
        if (!"NA".equals(sessionName)) {
            String sessionCode = BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "session_code", false);
            sessionName = (String)sessionName + " (" + sessionCode + ")";
        }
        return sessionName;
    }

    public String getTotalRuns(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "total_runs_in_session", false);
    }

    public String getPassedRuns(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "passed_runs", false);
    }

    public String getFailedRuns(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "failed_runs", false);
    }

    public String getOtherRuns(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "other_runs", false);
    }

    public String getRunningRuns(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "running", false);
    }

    public String getWaitingRuns(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "waiting", false);
    }

    public String getTotalSessions(VMGRRun run) {
        return BuildStatusMap.getValue(run.getRun().getId(), run.getRun().getNumber(), run.getJobWorkingDir(), "number_of_entities", false);
    }

    public String getTimestampString(VMGRRun run) {
        return DateFormat.getDateTimeInstance(2, 2).format(new Date(run.getRun().getTimeInMillis()));
    }

    public String getBuildColumnSortData(Run<?, ?> build) {
        return String.valueOf(build.getNumber());
    }

    public String getSessionName(String sessionId) {
        String idNames = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir(), "idNames", false);
        if (!idNames.equals("NA")) {
            List<String> items = Arrays.asList(idNames.split("\\s*,\\s*"));
            for (String item : items) {
                if (!sessionId.equals(item.substring(0, item.indexOf("$@$")))) continue;
                return item.substring(item.indexOf("$@$") + 3, item.length());
            }
        }
        return "NO_NAME";
    }

    public String getSessionLinkForBuild(String sessionId) {
        String url = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir(), "url", false);
        if ("NA".equals(url)) {
            return "NA";
        }
        url = url.replaceAll("/vapi", "");
        return url + "/regression/index.html?sessionid=" + sessionId;
    }
}

