/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.vmanager.JUnitRequestHolder;
import org.jenkinsci.plugins.vmanager.StepHolder;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRBuildArchiver;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class VMGRLaunch
extends Builder {
    private final String vAPIUrl;
    private final boolean authRequired;
    private final boolean advConfig;
    private final String vAPIUser;
    private final String vAPICredentials;
    private final String vSIFName;
    private final String vSIFInputFile;
    private final String credentialInputFile;
    private final boolean deleteInputFile;
    private final boolean deleteCredentialInputFile;
    private final boolean useUserOnFarm;
    private final boolean dynamicUserId;
    private final String vsifType;
    private final String userFarmType;
    private final String envSourceInputFile;
    private final Secret vAPIPassword;
    private int connTimeout = 1;
    private int readTimeout = 30;
    private final boolean envVarible;
    private final String envVaribleFile;
    private final boolean attrValues;
    private final String attrValuesFile;
    private final String inaccessibleResolver;
    private final String envSourceInputFileType;
    private final String stoppedResolver;
    private final String failedResolver;
    private final String doneResolver;
    private final String suspendedResolver;
    private final boolean waitTillSessionEnds;
    private final boolean pauseSessionOnBuildInterruption;
    private int stepSessionTimeout = 0;
    private final boolean generateJUnitXML;
    private final boolean extraAttributesForFailures;
    private final String staticAttributeList;
    private final boolean markBuildAsFailedIfAllRunFailed;
    private final boolean failJobIfAllRunFailed;
    private final boolean markBuildAsPassedIfAllRunPassed;
    private final boolean failJobUnlessAllRunPassed;
    private final boolean userPrivateSSHKey;
    private final boolean vMGRBuildArchive;
    private final boolean deleteAlsoSessionDirectory;
    private final boolean genericCredentialForSessionDelete;
    private final String archiveUser;
    private final Secret archivePassword;
    private final String famMode;
    private final String famModeLocation;
    private final boolean noAppendSeed;
    private final String executionType;
    private final String sessionsInputFile;
    private final boolean deleteSessionInputFile;
    private final String envVariableType;
    private final String envVariableText;
    private final String attrVariableType;
    private final String attrVariableText;
    private final String defineVaribleFile;
    private final boolean defineVarible;
    private final String defineVariableType;
    private final String defineVariableText;
    private String defineVaribleFileFix;
    private String sessionsInputFileFix;
    private String vSIFInputFileFix;
    private String vSIFNameFix;
    private String credentialInputFileFix;
    private String envSourceInputFileFix;
    private String envVaribleFileFix;
    private String attrValuesFileFix;
    private String famModeLocationFix;
    private final String executionScript;
    private final String executionShellLocation;
    private final String executionVsifFile;
    private final String credentialType;

    @DataBoundConstructor
    public VMGRLaunch(String vAPIUrl, String vAPIUser, Secret vAPIPassword, String vSIFName, String vSIFInputFile, String credentialInputFile, boolean deleteInputFile, boolean deleteCredentialInputFile, boolean useUserOnFarm, boolean authRequired, String vsifType, String userFarmType, boolean dynamicUserId, boolean advConfig, int connTimeout, int readTimeout, boolean envVarible, String envVaribleFile, String inaccessibleResolver, String stoppedResolver, String failedResolver, String doneResolver, String suspendedResolver, boolean waitTillSessionEnds, int stepSessionTimeout, boolean generateJUnitXML, boolean extraAttributesForFailures, String staticAttributeList, boolean markBuildAsFailedIfAllRunFailed, boolean failJobIfAllRunFailed, String envSourceInputFile, boolean vMGRBuildArchive, boolean deleteAlsoSessionDirectory, boolean genericCredentialForSessionDelete, String archiveUser, Secret archivePassword, String famMode, String famModeLocation, boolean noAppendSeed, boolean markBuildAsPassedIfAllRunPassed, boolean failJobUnlessAllRunPassed, boolean userPrivateSSHKey, boolean attrValues, String attrValuesFile, String executionType, String sessionsInputFile, boolean deleteSessionInputFile, String envVariableType, String envVariableText, String attrVariableType, String attrVariableText, boolean pauseSessionOnBuildInterruption, String envSourceInputFileType, String executionScript, String executionShellLocation, String executionVsifFile, String defineVaribleFile, boolean defineVarible, String defineVariableType, String defineVariableText, String vAPICredentials, String credentialType) {
        this.vAPIUrl = vAPIUrl;
        this.vAPIUser = vAPIUser;
        this.vAPIPassword = vAPIPassword;
        this.vSIFName = vSIFName;
        this.vSIFInputFile = vSIFInputFile;
        this.credentialInputFile = credentialInputFile;
        this.authRequired = authRequired;
        this.advConfig = advConfig;
        this.envVarible = envVarible;
        this.deleteInputFile = deleteInputFile;
        this.deleteCredentialInputFile = deleteCredentialInputFile;
        this.useUserOnFarm = useUserOnFarm;
        this.vsifType = vsifType;
        this.userFarmType = userFarmType;
        this.dynamicUserId = dynamicUserId;
        this.envVaribleFile = envVaribleFile;
        this.attrValues = attrValues;
        this.attrValuesFile = attrValuesFile;
        this.envSourceInputFile = envSourceInputFile;
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.envSourceInputFileType = envSourceInputFileType;
        this.inaccessibleResolver = inaccessibleResolver;
        this.stoppedResolver = stoppedResolver;
        this.failedResolver = failedResolver;
        this.doneResolver = doneResolver;
        this.suspendedResolver = suspendedResolver;
        this.waitTillSessionEnds = waitTillSessionEnds;
        this.stepSessionTimeout = stepSessionTimeout;
        this.generateJUnitXML = generateJUnitXML;
        this.extraAttributesForFailures = extraAttributesForFailures;
        this.markBuildAsFailedIfAllRunFailed = markBuildAsFailedIfAllRunFailed;
        this.failJobIfAllRunFailed = failJobIfAllRunFailed;
        this.markBuildAsPassedIfAllRunPassed = markBuildAsPassedIfAllRunPassed;
        this.failJobUnlessAllRunPassed = failJobUnlessAllRunPassed;
        this.userPrivateSSHKey = userPrivateSSHKey;
        this.staticAttributeList = staticAttributeList;
        this.vMGRBuildArchive = vMGRBuildArchive;
        this.deleteAlsoSessionDirectory = deleteAlsoSessionDirectory;
        this.genericCredentialForSessionDelete = genericCredentialForSessionDelete;
        this.archiveUser = archiveUser;
        this.archivePassword = archivePassword;
        this.famMode = famMode;
        this.famModeLocation = famModeLocation;
        this.noAppendSeed = noAppendSeed;
        this.executionType = executionType;
        this.sessionsInputFile = sessionsInputFile;
        this.deleteSessionInputFile = deleteSessionInputFile;
        this.envVariableType = envVariableType;
        this.envVariableText = envVariableText;
        this.attrVariableType = attrVariableType;
        this.attrVariableText = attrVariableText;
        this.pauseSessionOnBuildInterruption = pauseSessionOnBuildInterruption;
        this.executionScript = executionScript;
        this.executionShellLocation = executionShellLocation;
        this.executionVsifFile = executionVsifFile;
        this.defineVaribleFile = defineVaribleFile;
        this.defineVarible = defineVarible;
        this.defineVariableType = defineVariableType;
        this.defineVariableText = defineVariableText;
        this.vAPICredentials = vAPICredentials;
        this.credentialType = credentialType;
    }

    public String getExecutionVsifFile() {
        return this.executionVsifFile;
    }

    public String getExecutionShellLocation() {
        return this.executionShellLocation;
    }

    public String getExecutionScript() {
        return this.executionScript;
    }

    public String getSessionsInputFile() {
        return this.sessionsInputFile;
    }

    public boolean isPauseSessionOnBuildInterruption() {
        return this.pauseSessionOnBuildInterruption;
    }

    public String getAttrVariableType() {
        return this.attrVariableType;
    }

    public String getAttrVariableText() {
        return this.attrVariableText;
    }

    public String getEnvVariableType() {
        return this.envVariableType;
    }

    public String getEnvVariableText() {
        return this.envVariableText;
    }

    public boolean isDeleteSessionInputFile() {
        return this.deleteSessionInputFile;
    }

    public String getExecutionType() {
        return this.executionType;
    }

    public boolean isExtraAttributesForFailures() {
        return this.extraAttributesForFailures;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public boolean isNoAppendSeed() {
        return this.noAppendSeed;
    }

    public boolean isMarkBuildAsFailedIfAllRunFailed() {
        return this.markBuildAsFailedIfAllRunFailed;
    }

    public boolean isFailJobIfAllRunFailed() {
        return this.failJobIfAllRunFailed;
    }

    public boolean isMarkBuildAsPassedIfAllRunPassed() {
        return this.markBuildAsPassedIfAllRunPassed;
    }

    public boolean isFailJobUnlessAllRunPassed() {
        return this.failJobUnlessAllRunPassed;
    }

    public boolean isUserPrivateSSHKey() {
        return this.userPrivateSSHKey;
    }

    public String getStaticAttributeList() {
        return this.staticAttributeList;
    }

    public boolean isGenerateJUnitXML() {
        return this.generateJUnitXML;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public Secret getVAPIPassword() {
        return this.vAPIPassword;
    }

    public Secret getArchivePassword() {
        return this.archivePassword;
    }

    public String getVSIFName() {
        return this.vSIFName;
    }

    public String getEnvVaribleFile() {
        return this.envVaribleFile;
    }

    public String getAttrValuesFile() {
        return this.attrValuesFile;
    }

    public String getEnvSourceInputFile() {
        return this.envSourceInputFile;
    }

    public String getVSIFInputFile() {
        return this.vSIFInputFile;
    }

    public String getCredentialInputFile() {
        return this.credentialInputFile;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public boolean isDeleteCredentialInputFile() {
        return this.deleteCredentialInputFile;
    }

    public boolean isUseUserOnFarm() {
        return this.useUserOnFarm;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public String getVsifType() {
        return this.vsifType;
    }

    public String getUserFarmType() {
        return this.userFarmType;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public boolean isEnvVarible() {
        return this.envVarible;
    }

    public boolean isAttrValues() {
        return this.attrValues;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getStepSessionTimeout() {
        return this.stepSessionTimeout;
    }

    public String getInaccessibleResolver() {
        return this.inaccessibleResolver;
    }

    public String getEnvSourceInputFileType() {
        return this.envSourceInputFileType;
    }

    public String getStoppedResolver() {
        return this.stoppedResolver;
    }

    public String getFailedResolver() {
        return this.failedResolver;
    }

    public String getDoneResolver() {
        return this.doneResolver;
    }

    public String getSuspendedResolver() {
        return this.suspendedResolver;
    }

    public boolean isWaitTillSessionEnds() {
        return this.waitTillSessionEnds;
    }

    public boolean isVMGRBuildArchive() {
        return this.vMGRBuildArchive;
    }

    public boolean isDeleteAlsoSessionDirectory() {
        return this.deleteAlsoSessionDirectory;
    }

    public boolean isGenericCredentialForSessionDelete() {
        return this.genericCredentialForSessionDelete;
    }

    public String getArchiveUser() {
        return this.archiveUser;
    }

    public String getFamMode() {
        return this.famMode;
    }

    public String getFamModeLocation() {
        return this.famModeLocation;
    }

    public String getDefineVaribleFile() {
        return this.defineVaribleFile;
    }

    public boolean isDefineVarible() {
        return this.defineVarible;
    }

    public String getDefineVariableType() {
        return this.defineVariableType;
    }

    public String getDefineVariableText() {
        return this.defineVariableText;
    }

    public String getVAPICredentials() {
        return this.vAPICredentials;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String vAPIPassword = this.getVAPIPassword().getPlainText();
        String archivePassword = this.getArchivePassword().getPlainText();
        String workingJobDir = build.getRootDir().getAbsolutePath();
        listener.getLogger().println("Root dir is: " + workingJobDir);
        String macroVAPIUrl = this.vAPIUrl;
        try {
            macroVAPIUrl = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.vAPIUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.getLogger().println("Failed to extract out macro from the input of vAPIUrl: " + this.vAPIUrl);
        }
        listener.getLogger().println("The HOST for vAPI is: " + macroVAPIUrl);
        listener.getLogger().println("The user/password type for vAPI is: " + this.credentialType);
        String tempUser = this.vAPIUser;
        String tempPassword = vAPIPassword;
        if ("credential".equals(this.credentialType)) {
            StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.vAPICredentials, StandardUsernamePasswordCredentials.class, (Run)build, Collections.emptyList());
            if (c != null) {
                tempUser = c.getUsername();
                tempPassword = c.getPassword().getPlainText();
            }
            listener.getLogger().println("Credentials set with ID " + this.vAPICredentials);
        }
        listener.getLogger().println("The vAPIUser for vAPI is: " + tempUser);
        listener.getLogger().println("The vAPIPassword for vAPI is: *******");
        listener.getLogger().println("The authRequired for vAPI is: " + this.authRequired);
        listener.getLogger().println("The id is: " + build.getId());
        listener.getLogger().println("The number is: " + build.getNumber());
        listener.getLogger().println("The workspace dir is: " + String.valueOf(build.getWorkspace()));
        if (this.advConfig) {
            listener.getLogger().println("The connection timeout is: " + this.connTimeout + " minutes");
            listener.getLogger().println("The read api timeout is: " + this.readTimeout + " minutes");
        } else {
            listener.getLogger().println("The connection timeout is: 1 minutes");
            listener.getLogger().println("The read api timeout is: 30 minutes");
        }
        listener.getLogger().println("In case build is interrupted, sesssion will get paused: " + this.pauseSessionOnBuildInterruption);
        listener.getLogger().println("The execution type set is " + this.executionType);
        if ("batch".equals(this.executionType)) {
            try {
                this.sessionsInputFileFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.sessionsInputFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                listener.getLogger().println("Failed to extract out macro from the input of sessionsInputFile: " + this.sessionsInputFile);
                this.sessionsInputFileFix = this.sessionsInputFile;
            }
            listener.getLogger().println("The session input file name is: " + this.sessionsInputFileFix);
            listener.getLogger().println("The deleteSessionInputFile : " + this.deleteSessionInputFile);
        }
        if ("hybrid".equals(this.executionType)) {
            listener.getLogger().println("Hybrid batch model with script: " + this.executionScript);
            listener.getLogger().println("Hybrid batch model with shell: " + this.executionShellLocation);
            listener.getLogger().println("Hybrid batch model with vsif: " + this.executionVsifFile);
        } else {
            listener.getLogger().println("The vsif to be executed is " + this.vsifType);
            try {
                this.vSIFNameFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.vSIFName);
            }
            catch (Exception e) {
                e.printStackTrace();
                listener.getLogger().println("Failed to extract out macro from the input of vSIFName: " + this.vSIFName);
                this.vSIFNameFix = this.vSIFName;
            }
            listener.getLogger().println("The vSIFName is: " + this.vSIFNameFix);
            try {
                this.vSIFInputFileFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.vSIFInputFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                listener.getLogger().println("Failed to extract out macro from the input of vSIFInputFile: " + this.vSIFInputFile);
                this.vSIFInputFileFix = this.vSIFInputFile;
            }
            listener.getLogger().println("The vSIF Path For External VSIF Input is: " + this.vSIFInputFileFix);
            listener.getLogger().println("The deleteInputFile for vAPI is: " + this.deleteInputFile);
            if (this.envVarible) {
                listener.getLogger().println("An environment varible file was selected.");
            }
            if (this.attrValues) {
                listener.getLogger().println("An attribute values file was selected.");
            }
            if (this.defineVarible) {
                listener.getLogger().println("A define varible file was selected.");
            }
            if (this.useUserOnFarm) {
                listener.getLogger().println("An User's Credential use was selected.");
                listener.getLogger().println("The User's Credential type is: " + this.userFarmType);
                listener.getLogger().println("User is using private stored SSH key: " + this.userPrivateSSHKey);
                if ("dynamic".equals(this.userFarmType)) {
                    try {
                        this.credentialInputFileFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.credentialInputFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        listener.getLogger().println("Failed to extract out macro from the input of credentialInputFile: " + this.credentialInputFile);
                        this.credentialInputFileFix = this.credentialInputFile;
                    }
                    listener.getLogger().println("The credential file is: " + this.credentialInputFileFix);
                    listener.getLogger().println("The credential file was set to be deleted after use: " + this.deleteCredentialInputFile);
                }
                if (this.envSourceInputFile != null && !"".equals(this.envSourceInputFile.trim())) {
                    try {
                        this.envSourceInputFileFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.envSourceInputFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        listener.getLogger().println("Failed to extract out macro from the input of envSourceInputFile: " + this.envSourceInputFile);
                        this.envSourceInputFileFix = this.envSourceInputFile;
                    }
                    listener.getLogger().println("The User's source file is: " + this.envSourceInputFileFix);
                    listener.getLogger().println("The User's source file type is: " + this.envSourceInputFileType);
                } else {
                    listener.getLogger().println("The User's source file wasn't set");
                }
            }
        }
        StepHolder stepHolder = null;
        JUnitRequestHolder jUnitRequestHolder = null;
        if (this.waitTillSessionEnds) {
            listener.getLogger().println("Build set to finish only when session finish to run");
            listener.getLogger().println("In case session is at state 'inaccessible' the build will " + this.inaccessibleResolver);
            listener.getLogger().println("In case session is at state 'failed' the build will " + this.failedResolver);
            listener.getLogger().println("In case session is at state 'stopped' the build will " + this.stoppedResolver);
            listener.getLogger().println("In case session is at state 'suspended' the build will " + this.suspendedResolver);
            listener.getLogger().println("In case session is at state 'done' the build will " + this.doneResolver);
            listener.getLogger().println("Timeout for entire step is " + this.stepSessionTimeout + " minutes");
            listener.getLogger().println("User choosed to mark regression as Failed in case all runs are failing: " + this.markBuildAsFailedIfAllRunFailed);
            listener.getLogger().println("User choosed to fail the job in case all runs are failing: " + this.failJobIfAllRunFailed);
            listener.getLogger().println("User choosed to mark regression as Passed in case all runs are passed: " + this.markBuildAsPassedIfAllRunPassed);
            listener.getLogger().println("User choosed to fail the job unless all runs are passed: " + this.failJobUnlessAllRunPassed);
            listener.getLogger().println("Generate XML Report XML output: " + this.generateJUnitXML);
            if (this.generateJUnitXML) {
                listener.getLogger().println("Do not append seed to test names: " + this.noAppendSeed);
                jUnitRequestHolder = new JUnitRequestHolder(this.generateJUnitXML, this.extraAttributesForFailures, this.staticAttributeList, this.noAppendSeed);
                listener.getLogger().println("Extra Attributes in JUnit Report: " + this.extraAttributesForFailures);
                if (this.extraAttributesForFailures) {
                    listener.getLogger().println("Extra Attributes list in JUnit Report is: " + this.staticAttributeList);
                }
            }
            stepHolder = new StepHolder(this.inaccessibleResolver, this.stoppedResolver, this.failedResolver, this.doneResolver, this.suspendedResolver, this.waitTillSessionEnds, this.stepSessionTimeout, jUnitRequestHolder, this.markBuildAsFailedIfAllRunFailed, this.failJobIfAllRunFailed, this.markBuildAsPassedIfAllRunPassed, this.failJobUnlessAllRunPassed, this.pauseSessionOnBuildInterruption);
        }
        VMGRBuildArchiver vMGRBuildArchiver = null;
        if (this.vMGRBuildArchive) {
            listener.getLogger().println("Session was set to get deleted when build is deleted");
            listener.getLogger().println("Delete also session directory on disk: " + this.deleteAlsoSessionDirectory);
            listener.getLogger().println("Use dedicated credentials for deleting the session: " + this.genericCredentialForSessionDelete);
            listener.getLogger().println("Use FAM Mode: " + this.famMode);
            if ("true".equals(this.famMode)) {
                try {
                    this.famModeLocationFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.famModeLocation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    listener.getLogger().println("Failed to extract out macro from the input of famModeLocation: " + this.famModeLocation);
                    this.famModeLocationFix = this.famModeLocation;
                }
                listener.getLogger().println("FAM Mode Location: " + this.famModeLocationFix);
            }
            if (this.genericCredentialForSessionDelete) {
                listener.getLogger().println("Dedicated User for session delete: " + this.archiveUser);
                listener.getLogger().println("Dedicated password for session delete: *******");
            }
            vMGRBuildArchiver = new VMGRBuildArchiver(this.vMGRBuildArchive, this.deleteAlsoSessionDirectory, this.genericCredentialForSessionDelete, this.archiveUser, archivePassword, this.famMode, this.famModeLocationFix);
        }
        try {
            String output;
            Utils utils = new Utils((Run)build, (TaskListener)listener);
            String[] vsifFileNames = null;
            String[] sessionNames = null;
            Object jsonEnvInput = null;
            String jsonAttrValuesInput = null;
            String jsonDefineInput = null;
            String[] farmUserPassword = null;
            String tmpExecutionType = this.executionType;
            if ("batch".equals(this.executionType)) {
                if (this.sessionsInputFile == null || this.sessionsInputFile.trim().equals("")) {
                    listener.getLogger().println("The session input file chosen is dynamic. Dynamic workspace directory: '" + String.valueOf(build.getWorkspace()) + "'");
                } else {
                    listener.getLogger().println("The session input file chosen is static. Sessions input file name is: '" + this.sessionsInputFileFix.trim() + "'");
                }
                sessionNames = utils.loadDataFromInputFiles(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.sessionsInputFileFix, (TaskListener)listener, this.deleteSessionInputFile, "session names", "sessions.input");
                if (sessionNames.length == 0) {
                    listener.getLogger().println("No session were found within sessions.input file.  Exit Job.\n");
                    return false;
                }
            } else if ("hybrid".equals(this.executionType)) {
                tmpExecutionType = "batch";
                utils.batchExecManager((TaskListener)listener, TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.executionScript), this.executionShellLocation, TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.executionVsifFile), build.getId(), build.getNumber(), launcher);
                sessionNames = utils.loadDataFromInputFiles(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), "", (TaskListener)listener, false, "session names", "sessions.input");
                if (sessionNames.length == 0) {
                    listener.getLogger().println("No session were found within sessions.input file.  Exit Job.\n");
                    return false;
                }
            } else {
                String tmpAttrText;
                if ("static".equals(this.vsifType)) {
                    listener.getLogger().println("The VSIF file chosen is static. VSIF file static location is: '" + this.vSIFNameFix + "'");
                    vsifFileNames = new String[]{this.vSIFNameFix};
                } else {
                    if (this.vSIFInputFile == null || this.vSIFInputFile.trim().equals("")) {
                        listener.getLogger().println("The VSIF file chosen is dynamic. VSIF directory dynamic workspace directory: '" + String.valueOf(build.getWorkspace()) + "'");
                    } else {
                        listener.getLogger().println("The VSIF file chosen is dynamic. VSIF file name is: '" + this.vSIFInputFileFix.trim() + "'");
                    }
                    vsifFileNames = utils.loadDataFromInputFiles(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.vSIFInputFileFix, (TaskListener)listener, this.deleteInputFile, "VSIF", "vsif.input");
                }
                if (this.envVarible) {
                    if (this.envVariableType == null || "".equals(this.envVariableType) || "file".equals(this.envVariableType)) {
                        this.envVaribleFileFix = this.envVaribleFile;
                        if (this.envVaribleFile == null || this.envVaribleFile.trim().equals("")) {
                            listener.getLogger().println("The environment varible file chosen is dynamic. Env File directory dynamic workspace directory: '" + String.valueOf(build.getWorkspace()) + "'");
                        } else {
                            try {
                                this.envVaribleFileFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.envVaribleFile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                listener.getLogger().println("Failed to extract out macro from the input of envVaribleFile: " + this.envVaribleFile);
                                this.envVaribleFileFix = this.envVaribleFile;
                            }
                            listener.getLogger().println("The environment varible file chosen is static. Environment file name is: '" + this.envVaribleFileFix.trim() + "'");
                        }
                        jsonEnvInput = utils.loadJSONEnvInput(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.envVaribleFileFix, (TaskListener)listener);
                        try {
                            jsonEnvInput = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)jsonEnvInput);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            listener.getLogger().println("Failed to extract out macro from the input of envVaribleFile: " + this.envVaribleFileFix);
                        }
                        listener.getLogger().println("Found the following environment for the vsif: " + (String)jsonEnvInput);
                    }
                    if ("textarea".equals(this.envVariableType)) {
                        String tmpEnvText = null;
                        try {
                            tmpEnvText = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)StringUtils.normalizeSpace((String)this.envVariableText));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            listener.getLogger().println("Failed to extract out macro from the input of envVariableText: " + StringUtils.normalizeSpace((String)this.envVariableText));
                            tmpEnvText = StringUtils.normalizeSpace((String)this.envVariableText);
                        }
                        jsonEnvInput = "\"environment\":{  " + tmpEnvText + "}";
                        listener.getLogger().println("Found the following environment variable textarea for the vsif: " + (String)jsonEnvInput);
                    }
                }
                if (this.defineVarible) {
                    if (this.defineVariableType == null || "".equals(this.defineVariableType) || "file".equals(this.defineVariableType)) {
                        this.defineVaribleFileFix = this.defineVaribleFile;
                        if (this.defineVaribleFile == null || this.defineVaribleFile.trim().equals("")) {
                            listener.getLogger().println("The define values file chosen is dynamic. Define File directory dynamic workspace directory: '" + String.valueOf(build.getWorkspace()) + "'");
                        } else {
                            try {
                                this.defineVaribleFileFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.defineVaribleFile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                listener.getLogger().println("Failed to extract out macro from the input of defineVaribleFile: " + this.defineVaribleFile);
                                this.defineVaribleFileFix = this.defineVaribleFile;
                            }
                            listener.getLogger().println("The define values file chosen is static. Define values file name is: '" + this.defineVaribleFileFix.trim() + "'");
                        }
                        jsonDefineInput = utils.loadJSONDefineInput(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.defineVaribleFileFix, (TaskListener)listener);
                        try {
                            jsonDefineInput = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)jsonDefineInput);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            listener.getLogger().println("Failed to extract out macro from the input of defineVaribleFile: " + this.defineVaribleFileFix);
                        }
                        listener.getLogger().println("Found the following define values for the vsif: " + jsonDefineInput);
                    }
                    if ("textarea".equals(this.defineVariableType)) {
                        tmpAttrText = null;
                        String fetchDefineJsonFromTextArea = utils.loadJSONDefineValuesFromTextArea(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), (TaskListener)listener, this.defineVariableText);
                        try {
                            tmpAttrText = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)StringUtils.normalizeSpace((String)fetchDefineJsonFromTextArea));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            listener.getLogger().println("Failed to extract out macro from the input of fetchJsonFromTextArea: " + StringUtils.normalizeSpace((String)fetchDefineJsonFromTextArea));
                            tmpAttrText = StringUtils.normalizeSpace((String)fetchDefineJsonFromTextArea);
                        }
                        jsonDefineInput = tmpAttrText;
                        listener.getLogger().println("Found the following define values textarea for the vsif: " + jsonDefineInput);
                    }
                }
                if (this.attrValues) {
                    if (this.attrVariableType == null || "".equals(this.attrVariableType) || "file".equals(this.attrVariableType)) {
                        this.attrValuesFileFix = this.attrValuesFile;
                        if (this.attrValuesFile == null || this.attrValuesFile.trim().equals("")) {
                            listener.getLogger().println("The attribute values file chosen is dynamic. Env File directory dynamic workspace directory: '" + String.valueOf(build.getWorkspace()) + "'");
                        } else {
                            try {
                                this.attrValuesFileFix = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.attrValuesFile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                listener.getLogger().println("Failed to extract out macro from the input of attrValuesFile: " + this.attrValuesFile);
                                this.attrValuesFileFix = this.attrValuesFile;
                            }
                            listener.getLogger().println("The attribute values file chosen is static. Attribute values file name is: '" + this.attrValuesFileFix.trim() + "'");
                        }
                        jsonAttrValuesInput = utils.loadJSONAttrValuesInput(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.attrValuesFileFix, (TaskListener)listener);
                        try {
                            jsonAttrValuesInput = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)jsonAttrValuesInput);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            listener.getLogger().println("Failed to extract out macro from the input of attrValuesFile: " + this.attrValuesFileFix);
                        }
                        listener.getLogger().println("Found the following attribute values for the vsif: " + jsonAttrValuesInput);
                    }
                    if ("textarea".equals(this.attrVariableType)) {
                        tmpAttrText = null;
                        String fetchJsonFromTextArea = utils.loadJSONAttrValuesFromTextArea(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), (TaskListener)listener, this.attrVariableText);
                        try {
                            tmpAttrText = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)StringUtils.normalizeSpace((String)fetchJsonFromTextArea));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            listener.getLogger().println("Failed to extract out macro from the input of fetchJsonFromTextArea: " + StringUtils.normalizeSpace((String)fetchJsonFromTextArea));
                            tmpAttrText = StringUtils.normalizeSpace((String)fetchJsonFromTextArea);
                        }
                        jsonAttrValuesInput = tmpAttrText;
                        listener.getLogger().println("Found the following attribute values textarea for the vsif: " + jsonAttrValuesInput);
                    }
                }
                if ("dynamic".equals(this.userFarmType)) {
                    if (this.credentialInputFile == null || this.credentialInputFile.trim().equals("")) {
                        listener.getLogger().println("The credential file chosen is dynamic. Credential directory dynamic workspace directory: '" + String.valueOf(build.getWorkspace()) + "'");
                    } else {
                        listener.getLogger().println("The credential file chosen is static. Credential file name is: '" + this.credentialInputFileFix.trim() + "'");
                    }
                    farmUserPassword = utils.loadFileCredentials(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.credentialInputFileFix, (TaskListener)listener, this.deleteCredentialInputFile);
                    if (this.userPrivateSSHKey) {
                        tempUser = farmUserPassword[0];
                        tempPassword = farmUserPassword[1];
                    }
                }
            }
            if (!"success".equals(output = utils.executeVSIFLaunch(vsifFileNames, macroVAPIUrl, this.authRequired, tempUser, tempPassword, (TaskListener)listener, this.dynamicUserId, build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.connTimeout, this.readTimeout, this.advConfig, (String)jsonEnvInput, this.useUserOnFarm, this.userFarmType, farmUserPassword, stepHolder, this.envSourceInputFileFix, workingJobDir, vMGRBuildArchiver, this.userPrivateSSHKey, jsonAttrValuesInput, tmpExecutionType, sessionNames, this.envSourceInputFileType, launcher, jsonDefineInput))) {
                listener.getLogger().println("Failed to launch vsifs for build " + build.getId() + " " + build.getNumber() + "\n");
                listener.getLogger().println(output + "\n");
                return false;
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to build " + build.getId() + " " + build.getNumber());
            listener.getLogger().println(e.getMessage());
            for (StackTraceElement ste : e.getStackTrace()) {
                listener.getLogger().println(" " + String.valueOf(ste));
            }
            listener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)e));
            return false;
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Verisium Manager vAPI HOST ");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckStaticAttributeList(@QueryParameter String value) throws IOException, ServletException {
            if (value != null) {
                if (value.indexOf(";") > 0) {
                    return FormValidation.error((String)"(;) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (value.indexOf("|") > 0) {
                    return FormValidation.error((String)"(|) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (value.indexOf(".") > 0) {
                    return FormValidation.error((String)"(.) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                List<String> items = Arrays.asList(value.split("\\s*,\\s*"));
                Iterator<String> iter = items.iterator();
                String tmpAttr = null;
                while (iter.hasNext()) {
                    tmpAttr = iter.next();
                    if (tmpAttr.indexOf(" ") > 0) {
                        return FormValidation.error((String)("'" + tmpAttr + "' is not a valid option for Verisium Manager attribute code name. Attribute code names can't have space.  Try using underscore instaed."));
                    }
                    if (tmpAttr.equals("first_failure_name")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (tmpAttr.equals("first_failure_description")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (tmpAttr.equals("computed_seed")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (tmpAttr.equals("test_group")) {
                        return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                    }
                    if (!tmpAttr.equals("test_name")) continue;
                    return FormValidation.warning((String)("'" + tmpAttr + "' is already included as part of the stack error message by default."));
                }
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillInaccessibleResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Mark the build as failed", "fail");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Ignore, and continue to wait", "ignore");
            return items;
        }

        public ListBoxModel doFillEnvSourceInputFileTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("bash", "BSH");
            items.add("csh", "CSH");
            return items;
        }

        public ListBoxModel doFillStoppedResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Mark the build as failed", "fail");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Ignore, and continue to wait", "ignore");
            return items;
        }

        public ListBoxModel doFillFailedResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Mark the build as failed", "fail");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Ignore, and continue to wait", "ignore");
            return items;
        }

        public ListBoxModel doFillDoneResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Ignore, and continue to wait", "ignore");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Mark the build as failed", "fail");
            return items;
        }

        public ListBoxModel doFillSuspendedResolverItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Ignore, and continue to wait", "ignore");
            items.add("Continue, and move to the next build step", "continue");
            items.add("Mark the build as failed", "fail");
            return items;
        }

        public ListBoxModel doFillVAPICredentialsItems(@AncestorInPath Item item, @QueryParameter String vAPICredentials) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(vAPICredentials);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(vAPICredentials);
        }

        public String getDisplayName() {
            return "Cadence vManager Session Launcher";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String vAPIUser, @QueryParameter(value="vAPIPassword") Secret vAPIPassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @QueryParameter(value="authRequired") boolean authRequired, @QueryParameter(value="credentialType") String credentialType, @QueryParameter(value="vAPICredentials") String vAPICredentials, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                String tempUser = vAPIUser;
                String tempPassword = vAPIPassword.getPlainText();
                boolean foundMatchUserPassword = false;
                if ("credential".equals(credentialType)) {
                    List listOfC = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList());
                    Iterator cIterator = listOfC.iterator();
                    StandardUsernamePasswordCredentials tmpHolder = null;
                    while (cIterator.hasNext()) {
                        tmpHolder = (StandardUsernamePasswordCredentials)cIterator.next();
                        if (!vAPICredentials.equals(tmpHolder.getId())) continue;
                        tempUser = tmpHolder.getUsername();
                        tempPassword = tmpHolder.getPassword().getPlainText();
                        foundMatchUserPassword = true;
                        break;
                    }
                } else {
                    foundMatchUserPassword = true;
                }
                if (foundMatchUserPassword) {
                    Utils utils = new Utils();
                    String output = utils.checkVAPIConnection(vAPIUrl, authRequired, tempUser, tempPassword);
                    if (!output.startsWith("Failed")) {
                        return FormValidation.ok((String)("Success. " + output));
                    }
                    return FormValidation.error((String)output);
                }
                return FormValidation.error((String)"Could not extract the user/password from the supplied Credential object.  Object was not found within your Jenkins domain.");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        @POST
        public FormValidation doTestArchiveUser(@QueryParameter(value="archiveUser") String archiveUser, @QueryParameter(value="archivePassword") Secret archivePassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                String tempPassword = archivePassword.getPlainText();
                Utils utils = new Utils();
                String output = utils.checkVAPIConnection(vAPIUrl, true, archiveUser, tempPassword);
                if (!output.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + output));
                }
                return FormValidation.error((String)output);
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        @POST
        public FormValidation doTestExtraStaticAttr(@QueryParameter(value="vAPIUser") String vAPIUser, @QueryParameter(value="vAPIPassword") Secret vAPIPassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @QueryParameter(value="authRequired") boolean authRequired, @QueryParameter(value="staticAttributeList") String staticAttributeList, @QueryParameter(value="credentialType") String credentialType, @QueryParameter(value="vAPICredentials") String vAPICredentials, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user context is null, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                String tempUser = vAPIUser;
                String tempPassword = vAPIPassword.getPlainText();
                boolean foundMatchUserPassword = false;
                if ("credential".equals(credentialType)) {
                    List listOfC = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList());
                    Iterator cIterator = listOfC.iterator();
                    StandardUsernamePasswordCredentials tmpHolder = null;
                    while (cIterator.hasNext()) {
                        tmpHolder = (StandardUsernamePasswordCredentials)cIterator.next();
                        if (!vAPICredentials.equals(tmpHolder.getId())) continue;
                        tempUser = tmpHolder.getUsername();
                        tempPassword = tmpHolder.getPassword().getPlainText();
                        foundMatchUserPassword = true;
                        break;
                    }
                } else {
                    foundMatchUserPassword = true;
                }
                if (foundMatchUserPassword) {
                    Utils utils = new Utils();
                    String output = utils.checkExtraStaticAttr(vAPIUrl, authRequired, tempUser, tempPassword, staticAttributeList);
                    if (!output.startsWith("Failed")) {
                        return FormValidation.ok((String)("Success. " + output));
                    }
                    return FormValidation.error((String)output);
                }
                return FormValidation.error((String)"Could not extract the user/password from the supplied Credential object.  Object was not found within your Jenkins domain.");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        public FormValidation doCheckVAPICredentials(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            if (CredentialsProvider.listCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always()).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }
    }

    @Extension
    public static final class VMGRDeletedJobListener
    extends RunListener<Run> {
        private static final Logger logger = Logger.getLogger(VMGRDeletedJobListener.class.getName());

        public void onDeleted(Run run) {
            VMGRBuildArchiver vMGRBuildArchiver = new VMGRBuildArchiver();
            try {
                vMGRBuildArchiver.deleteSessions(run, logger);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to delete session during build removal.", ex);
            }
        }
    }
}

