/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.jenkinsci.plugins.vmanager.Utils;

public class VMGRBuildArchiver {
    private boolean vMGRBuildArchive = false;
    private String archiveUser;
    private String archivePassword;
    private boolean deleteAlsoSessionDirectory = false;
    private boolean genericCredentialForSessionDelete = false;
    private String famMode;
    private String famModeLocation;

    public VMGRBuildArchiver(boolean vMGRBuildArchive, boolean deleteAlsoSessionDirectory, boolean genericCredentialForSessionDelete, String archiveUser, String archivePassword, String famMode, String famModeLocation) {
        this.archiveUser = archiveUser;
        this.archivePassword = archivePassword;
        this.vMGRBuildArchive = vMGRBuildArchive;
        this.deleteAlsoSessionDirectory = deleteAlsoSessionDirectory;
        this.genericCredentialForSessionDelete = genericCredentialForSessionDelete;
        this.famMode = famMode;
        this.famModeLocation = famModeLocation;
    }

    public VMGRBuildArchiver() {
    }

    public boolean isVMGRBuildArchive() {
        return this.vMGRBuildArchive;
    }

    public void setVMGRBuildArchive(boolean isVMGRBuildArchive) {
        this.vMGRBuildArchive = isVMGRBuildArchive;
    }

    public String getArchiveUser() {
        return this.archiveUser;
    }

    public void setArchiveUser(String archiveUser) {
        this.archiveUser = archiveUser;
    }

    public String getArchivePassword() {
        return this.archivePassword;
    }

    public void setArchivePassword(String archivePassword) {
        this.archivePassword = archivePassword;
    }

    public boolean isDeleteAlsoSessionDirectory() {
        return this.deleteAlsoSessionDirectory;
    }

    public void setSeleteAlsoSessionDirectory(boolean deleteAlsoSessionDirectory) {
        this.deleteAlsoSessionDirectory = deleteAlsoSessionDirectory;
    }

    public boolean isGenericCredentialForSessionDelete() {
        return this.genericCredentialForSessionDelete;
    }

    public void setGenericCredentialForSessionDelete(boolean genericCredentialForSessionDelete) {
        this.genericCredentialForSessionDelete = genericCredentialForSessionDelete;
    }

    public void markBuildForArchive(List<String> listOfSessions, String apiURL, boolean requireAuth, String userUsedForLogin, String passwordUsedForLogin, String workingJobDir, TaskListener listener, Launcher launcher, Utils utils) throws InterruptedException {
        Object sessions = null;
        Iterator<String> iter = listOfSessions.iterator();
        while (iter.hasNext()) {
            if (sessions == null) {
                sessions = iter.next();
                continue;
            }
            sessions = (String)sessions + "," + iter.next();
        }
        Object fileOutput = "sdi.properties";
        if (utils.getFilePath() == null) {
            fileOutput = workingJobDir + File.separator + (String)fileOutput;
        }
        try {
            StringBuffer writer = new StringBuffer();
            String url = apiURL.trim();
            url = url.substring(0, url.length() - 6);
            writer.append("url=" + url + "\n");
            writer.append("deleteAlsoSessionDirectory=" + this.deleteAlsoSessionDirectory + "\n");
            writer.append("genericCredentialForSessionDelete=" + this.genericCredentialForSessionDelete + "\n");
            writer.append("requireAuth=" + requireAuth + "\n");
            writer.append("famMode=" + this.famMode + "\n");
            if ("true".equals(this.famMode)) {
                writer.append("famModeLocation=" + this.famModeLocation + "\n");
            }
            if (this.genericCredentialForSessionDelete) {
                writer.append("archiveUser=" + this.archiveUser + "\n");
                writer.append("archivePassword=" + Secret.fromString((String)this.archivePassword).getEncryptedValue() + "\n");
            } else {
                writer.append("archiveUser=" + userUsedForLogin + "\n");
                writer.append("archivePassword=" + Secret.fromString((String)passwordUsedForLogin).getEncryptedValue() + "\n");
            }
            writer.append("sessions=" + (String)sessions + "\n");
            utils.saveFileOnDisk((String)fileOutput, writer.toString());
            utils.moveFromNodeToMaster((String)fileOutput);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            listener.getLogger().print("ERROR - Failed to create sdi.properties file on " + (String)fileOutput);
            listener.getLogger().print(ex.getMessage());
        }
    }

    public void deleteSessions(Run run, Logger logger) throws Exception {
        File tmpFile = new File(run.getRootDir().getPath() + File.separator + "sdi.properties");
        if (!tmpFile.exists()) {
            return;
        }
        Properties buildSdi = this.loadProperties(run.getRootDir().getPath(), logger);
        if ("true".equals(buildSdi.getProperty("famMode"))) {
            long timeInMs = System.currentTimeMillis();
            File destFile = new File(buildSdi.getProperty("famModeLocation").trim() + File.separator + run.getNumber() + "-" + timeInMs + "-sdi.properties");
            Files.copy(tmpFile.toPath(), destFile.toPath(), new CopyOption[0]);
        } else {
            String reason;
            Object apiUrl = null;
            String decryptedPassword = Secret.fromString((String)buildSdi.getProperty("archivePassword").trim()).getPlainText();
            String userCredentials = buildSdi.getProperty("archiveUser").trim() + ":" + decryptedPassword;
            boolean requireAuth = true;
            if ("false".equals(buildSdi.getProperty("requireAuth").trim())) {
                requireAuth = false;
            }
            if ("true".equals(buildSdi.getProperty("genericCredentialForSessionDelete").trim())) {
                String updateSessionOwner = "{\"update\":{\"owner\":\"" + buildSdi.getProperty("archiveUser").trim() + "\"},\"rs\":{\"filter\":{\"@c\":\".InFilter\",\"attName\":\"id\",\"operand\":\"IN\",\"values\":[" + buildSdi.getProperty("sessions") + "]}}}";
                apiUrl = buildSdi.getProperty("url").trim();
                apiUrl = (String)apiUrl + "update";
                HttpURLConnection conn = this.getVAPIConnection((String)apiUrl, requireAuth, userCredentials);
                OutputStream os = conn.getOutputStream();
                os.write(updateSessionOwner.getBytes(Charset.forName("UTF-8")));
                os.flush();
                if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205) {
                    reason = "";
                    if (conn.getResponseCode() == 503) {
                        reason = "Failed to delete sessions.  vAPI process failed to connect to remote Verisium Manager server.";
                    }
                    if (conn.getResponseCode() == 401) {
                        reason = "Failed to delete sessions.  Authentication Error";
                    }
                    if (conn.getResponseCode() == 408) {
                        reason = "Failed to delete sessions.  No more licences are available for vAPI";
                    }
                    logger.log(Level.SEVERE, reason);
                    this.processErrorFromRespone(conn, logger);
                }
                conn.disconnect();
            }
            apiUrl = buildSdi.getProperty("url").trim();
            apiUrl = (String)apiUrl + "delete";
            HttpURLConnection conn = this.getVAPIConnection((String)apiUrl, requireAuth, userCredentials);
            OutputStream os = conn.getOutputStream();
            String input = "{\"rs\":{\"filter\":{\"@c\":\".InFilter\",\"attName\":\"id\",\"operand\":\"IN\",\"values\":[" + buildSdi.getProperty("sessions") + "]}},\"with-session-dir\":" + buildSdi.getProperty("deleteAlsoSessionDirectory").trim() + "}";
            os.write(input.getBytes(Charset.forName("UTF-8")));
            os.flush();
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205) {
                reason = "";
                if (conn.getResponseCode() == 503) {
                    reason = "Failed to delete sessions.  vAPI process failed to connect to remote Verisium Manager server.";
                }
                if (conn.getResponseCode() == 401) {
                    reason = "Failed to delete sessions.  Authentication Error";
                }
                if (conn.getResponseCode() == 408) {
                    reason = "Failed to delete sessions.  No more licences are available for vAPI";
                }
                logger.log(Level.SEVERE, reason);
                this.processErrorFromRespone(conn, logger);
            } else {
                logger.log(Level.INFO, "Sessions " + buildSdi.getProperty("sessions") + " was deleted from Verisium Manager DB");
            }
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processErrorFromRespone(HttpURLConnection conn, Logger logger) throws IOException {
        Object errorMessage = "";
        StringBuilder resultFromError = null;
        int responseCode = 0;
        BufferedReader br = null;
        try {
            String output;
            resultFromError = new StringBuilder(conn.getResponseMessage());
            responseCode = conn.getResponseCode();
            br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.forName("UTF-8")));
            while ((output = br.readLine()) != null) {
                resultFromError.append(output);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (br != null) {
                br.close();
            }
            errorMessage = "Failed : HTTP error code : " + responseCode + " (" + String.valueOf(resultFromError) + ")\n";
            logger.log(Level.SEVERE, (String)errorMessage);
        }
    }

    private Properties loadProperties(String path, Logger logger) throws IOException {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(path + File.separator + "sdi.properties");
            prop.load(input);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to read " + path + File.separator + "sdi.properties during delete of session operation", ex);
            throw ex;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop;
    }

    public HttpURLConnection getVAPIConnection(String apiUrl, boolean requireAuth, String authString) throws Exception {
        URL url = new URL(apiUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (apiUrl.indexOf("https://") > -1) {
            Utils.configureAllowAll((HttpsURLConnection)conn);
        }
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setConnectTimeout(60000);
        conn.setReadTimeout(1800000);
        if (requireAuth) {
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes(Charset.forName("UTF-8")));
            String authStringEnc = new String(authEncBytes, Charset.forName("UTF-8"));
            conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
        }
        return conn;
    }
}

