/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.Utils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class VMGRAPI
extends Builder {
    private final String vAPIUrl;
    private final boolean authRequired;
    private final String vAPIUser;
    private final Secret vAPIPassword;
    private final String vAPIInput;
    private final String vJsonInputFile;
    private final boolean deleteInputFile;
    private final boolean dynamicUserId;
    private final String apiType;
    private final String apiUrl;
    private final String requestMethod;
    private final boolean advConfig;
    private int connTimeout = 1;
    private int readTimeout = 30;

    @DataBoundConstructor
    public VMGRAPI(String vAPIUrl, String vAPIUser, Secret vAPIPassword, String vAPIInput, String vJsonInputFile, boolean deleteInputFile, boolean authRequired, String apiType, boolean dynamicUserId, String apiUrl, String requestMethod, boolean advConfig, int connTimeout, int readTimeout) {
        this.vAPIUrl = vAPIUrl;
        this.vAPIUser = vAPIUser;
        this.vAPIPassword = vAPIPassword;
        this.vAPIInput = vAPIInput;
        this.vJsonInputFile = vJsonInputFile;
        this.authRequired = authRequired;
        this.deleteInputFile = deleteInputFile;
        this.apiType = apiType;
        this.dynamicUserId = dynamicUserId;
        this.apiUrl = apiUrl;
        this.requestMethod = requestMethod;
        this.advConfig = advConfig;
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public String getVAPIInput() {
        return this.vAPIInput;
    }

    public String getVJsonInputFile() {
        return this.vJsonInputFile;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public String getApiType() {
        return this.apiType;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public Secret getVAPIPassword() {
        return this.vAPIPassword;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String vAPIPassword = this.getVAPIPassword().getPlainText();
        listener.getLogger().println("The HOST for vAPI is: " + this.vAPIUrl);
        listener.getLogger().println("The vAPIUser for vAPI is: " + this.vAPIUser);
        listener.getLogger().println("The vAPIPassword for vAPI is: *******");
        listener.getLogger().println("The Static jSON query for vAPI is: " + this.vAPIInput);
        listener.getLogger().println("The Input file name for vAPI is: " + this.vJsonInputFile);
        listener.getLogger().println("The authRequired for vAPI is: " + this.authRequired);
        listener.getLogger().println("The deleteInputFile for vAPI is: " + this.deleteInputFile);
        listener.getLogger().println("The type of input file for vAPI is " + this.apiType);
        listener.getLogger().println("The api call for vAPI is: " + this.apiUrl);
        listener.getLogger().println("The id is: " + build.getId());
        listener.getLogger().println("The number is: " + build.getNumber());
        listener.getLogger().println("The workspace dir is: " + String.valueOf(build.getWorkspace()));
        listener.getLogger().println("The request method dir is: " + this.requestMethod);
        if (this.advConfig) {
            listener.getLogger().println("The connection timeout is: " + this.connTimeout + " minutes");
            listener.getLogger().println("The read api timeout is: " + this.readTimeout + " minutes");
        } else {
            listener.getLogger().println("The connection timeout is: 1 minutes");
            listener.getLogger().println("The read api timeout is: 30 minutes");
        }
        try {
            Utils utils = new Utils((Run)build, (TaskListener)listener);
            String jSonInput = null;
            if ("static".equals(this.apiType)) {
                listener.getLogger().println("The vAPI query string input chosen is static. jSON input is: '" + this.vAPIInput + "'");
                jSonInput = this.vAPIInput;
            } else {
                if (this.vJsonInputFile == null || this.vJsonInputFile.trim().equals("")) {
                    listener.getLogger().println("The vAPI query string chosen is dynamic. jSON input file dynamic workspace directory: '" + String.valueOf(build.getWorkspace()) + "'");
                } else {
                    listener.getLogger().println("The vAPI query string chosen is dynamic. jSON input file static location: '" + this.vJsonInputFile.trim() + "'");
                }
                jSonInput = utils.loadJSONFromFile(build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.vJsonInputFile, (TaskListener)listener, this.deleteInputFile);
            }
            String output = utils.executeAPI(jSonInput, this.apiUrl, this.vAPIUrl, this.authRequired, this.vAPIUser, vAPIPassword, this.requestMethod, (TaskListener)listener, this.dynamicUserId, build.getId(), build.getNumber(), String.valueOf(build.getWorkspace()), this.connTimeout, this.readTimeout, this.advConfig);
            if (!"success".equals(output)) {
                listener.getLogger().println("Failed to call vAPI for build " + build.getId() + " " + build.getNumber() + "\n");
                listener.getLogger().println(output + "\n");
                return false;
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to call vAPI for build " + build.getId() + " " + build.getNumber());
            return false;
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Verisium Manager vAPI HOST ");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiUrl(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Verisium Manager vAPI URL ");
            }
            if (value.length() < 8) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRequestMethod(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || "".equals(value)) {
                return FormValidation.error((String)"Please choose the REST API request method (POST/GET/DELETE/PUT)");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillRequestMethodItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("POST", "POST");
            items.add("GET", "GET");
            items.add("PUT", "PUT");
            items.add("DELETE", "DELETE");
            return items;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Cadence vManager API";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String vAPIUser, @QueryParameter(value="vAPIPassword") Secret vAPIPassword, @QueryParameter(value="vAPIUrl") String vAPIUrl, @QueryParameter(value="authRequired") boolean authRequired, @AncestorInPath Item item) throws IOException, ServletException {
            if (item == null) {
                return FormValidation.error((String)"Current Jenkins user lacks context, so validation will not be carried out.");
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                String tempPassword = vAPIPassword.getPlainText();
                Utils utils = new Utils();
                String output = utils.checkVAPIConnection(vAPIUrl, authRequired, vAPIUser, tempPassword);
                if (!output.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + output));
                }
                return FormValidation.error((String)output);
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }
    }
}

