/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.JUnitRequestHolder;
import org.jenkinsci.plugins.vmanager.Utils;

public class UnitTestFormatter {
    List runs = null;
    JUnitRequestHolder jUnitRequestHolder = null;
    Map<String, String> extraAttrLabels = null;

    public UnitTestFormatter(List runs, JUnitRequestHolder jUnitRequestHolder, Map<String, String> extraAttrLabels) {
        this.runs = runs;
        this.jUnitRequestHolder = jUnitRequestHolder;
        this.extraAttrLabels = extraAttrLabels;
    }

    public List getRuns() {
        return this.runs;
    }

    public void setRuns(JSONArray runs) {
        this.runs = runs;
    }

    public void dumpXMLFile(String workPlacePath, int buildNumber, String buildID, Utils utils) throws IOException {
        if (this.runs.size() > 0) {
            Object fileOutput = "session_runs.xml";
            if (utils.getFilePath() == null) {
                fileOutput = workPlacePath + File.separator + (String)fileOutput;
            }
            StringBuffer writer = new StringBuffer();
            writer.append("<testsuite tests=\"Verisium Manager\">\n");
            Iterator runsIter = this.runs.iterator();
            JSONObject tmpRun = null;
            String testStatus = "NA";
            String testGroup = "NA";
            String name = "NA";
            String testSeed = "NA";
            int testDuration = 0;
            String testFirstErrorCode = "NA";
            String testFirstErrorDescription = "NA";
            while (runsIter.hasNext()) {
                tmpRun = (JSONObject)runsIter.next();
                testStatus = tmpRun.has("status") ? tmpRun.getString("status") : "NA";
                testGroup = tmpRun.has("test_group") ? UnitTestFormatter.stripNonValidXMLCharacters(tmpRun.getString("test_group")) : "NA";
                name = tmpRun.has("test_name") ? UnitTestFormatter.stripNonValidXMLCharacters(tmpRun.getString("test_name")) : "NA";
                testSeed = tmpRun.has("computed_seed") ? UnitTestFormatter.stripNonValidXMLCharacters(tmpRun.getString("computed_seed")) : "NA";
                if (tmpRun.has("duration")) {
                    try {
                        testDuration = Integer.parseInt(tmpRun.getString("duration"));
                    }
                    catch (Exception exception) {}
                } else {
                    testDuration = 0;
                }
                Object seedNameForAppending = "";
                if (!this.jUnitRequestHolder.isNoAppendSeed()) {
                    seedNameForAppending = " : Seed-" + testSeed;
                }
                if ("failed".equals(testStatus)) {
                    testFirstErrorCode = tmpRun.has("first_failure_name") ? UnitTestFormatter.stripNonValidXMLCharacters(tmpRun.getString("first_failure_name")) : "RUN_STILL_IN_PROGRESS";
                    testFirstErrorDescription = tmpRun.has("first_failure_description") ? UnitTestFormatter.stripNonValidXMLCharacters(tmpRun.getString("first_failure_description")) : "    Run is in state running,other or waiting.\n     Reason for run to mark as failed is because session change status to such that build was marked as failed.";
                    writer.append("\t\t<testcase classname=\"" + testGroup + "\" name=\"" + name + (String)seedNameForAppending + "\" time=\"" + testDuration + "\">\n");
                    writer.append("\t\t\t<failure message=\"" + testFirstErrorCode + "\" type=\"" + testFirstErrorCode + "\">First Error Description: \n" + testFirstErrorDescription + "\nComputed Seed: \n" + testSeed + "\n" + UnitTestFormatter.stripNonValidXMLCharacters(this.addExtraAttrValues(tmpRun)) + "</failure>\n");
                    writer.append("\t\t</testcase>\n");
                    continue;
                }
                if ("stopped".equals(testStatus) || "running".equals(testStatus) || "other".equals(testStatus) || "waiting".equals(testStatus)) {
                    writer.append("\t\t<testcase classname=\"" + testGroup + "\" name=\"" + name + (String)seedNameForAppending + "\" time=\"" + testDuration + "\">\n");
                    writer.append("\t\t <skipped />\n");
                    writer.append("\t\t</testcase>\n");
                    continue;
                }
                writer.append("\t\t<testcase classname=\"" + testGroup + "\" name=\"" + name + (String)seedNameForAppending + "\" time=\"" + testDuration + "\"/>\n");
            }
            writer.append("</testsuite>\n");
            utils.saveFileOnDisk((String)fileOutput, writer.toString());
        }
    }

    private String addExtraAttrValues(JSONObject tmpRun) {
        if (!this.jUnitRequestHolder.istExtraAttributesForFailures()) {
            return "";
        }
        if (this.jUnitRequestHolder.getStaticAttributeList() == null || "".equals(this.jUnitRequestHolder.getStaticAttributeList().trim())) {
            return "";
        }
        List<String> items = Arrays.asList(this.jUnitRequestHolder.getStaticAttributeList().split("\\s*,\\s*"));
        Iterator<String> iter = items.iterator();
        Object extraAttributesForRuns = "";
        String tmpAttr = null;
        String attrValue = null;
        while (iter.hasNext()) {
            tmpAttr = iter.next();
            if (tmpAttr.indexOf(" ") > 0 || tmpAttr.equals("first_failure_name") || tmpAttr.equals("first_failure_description") || tmpAttr.equals("computed_seed") || tmpAttr.equals("test_group") || tmpAttr.equals("test_name")) continue;
            if (tmpRun.has(tmpAttr)) {
                attrValue = tmpRun.getString(tmpAttr);
                attrValue = attrValue.replaceAll("<__SEPARATOR__>", "\n    ");
                extraAttributesForRuns = (String)extraAttributesForRuns + this.extraAttrLabels.get(tmpAttr) + ":\n    " + attrValue + "\n";
                continue;
            }
            attrValue = "NA";
        }
        return extraAttributesForRuns;
    }

    public static String stripNonValidXMLCharacters(String t) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < t.length(); ++i) {
            char c = t.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        sb.append("&#" + c + ";");
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

